/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure;

import java.util.Objects;
import proguard.analysis.datastructure.Location;

public class FileLocation
extends Location {
    public final String filename;

    public FileLocation(String filename, int line) {
        super(line);
        this.filename = filename;
    }

    @Override
    public String getName() {
        return this.filename;
    }

    public String toString() {
        return this.filename + " (line " + this.line + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileLocation other = (FileLocation)o;
        return this.line == other.line && Objects.equals(this.filename, other.filename);
    }

    public int hashCode() {
        return Objects.hash(this.filename, this.line);
    }

    @Override
    public int compareTo(Location o) {
        if (!o.getClass().equals(this.getClass())) {
            return -1;
        }
        FileLocation other = (FileLocation)o;
        if (this.filename.equals(other.filename)) {
            return this.line - other.line;
        }
        return this.filename.compareTo(other.filename);
    }
}

