/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.SpecificDoubleValue;

public final class ParticularDoubleValue
extends SpecificDoubleValue {
    private final double value;

    public ParticularDoubleValue(double value) {
        this.value = value;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public DoubleValue negate() {
        return new ParticularDoubleValue(-this.value);
    }

    @Override
    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    @Override
    public LongValue convertToLong() {
        return new ParticularLongValue((long)this.value);
    }

    @Override
    public FloatValue convertToFloat() {
        return new ParticularFloatValue((float)this.value);
    }

    @Override
    public DoubleValue generalize(DoubleValue other) {
        return other.generalize(this);
    }

    @Override
    public DoubleValue add(DoubleValue other) {
        return other.add(this);
    }

    @Override
    public DoubleValue subtract(DoubleValue other) {
        return other.subtractFrom(this);
    }

    @Override
    public DoubleValue subtractFrom(DoubleValue other) {
        return other.subtract(this);
    }

    @Override
    public DoubleValue multiply(DoubleValue other) {
        return other.multiply(this);
    }

    @Override
    public DoubleValue divide(DoubleValue other) {
        return other.divideOf(this);
    }

    @Override
    public DoubleValue divideOf(DoubleValue other) {
        return other.divide(this);
    }

    @Override
    public DoubleValue remainder(DoubleValue other) {
        return other.remainderOf(this);
    }

    @Override
    public DoubleValue remainderOf(DoubleValue other) {
        return other.remainder(this);
    }

    @Override
    public IntegerValue compare(DoubleValue other) {
        return other.compareReverse(this);
    }

    @Override
    public DoubleValue generalize(ParticularDoubleValue other) {
        return Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits(other.value) ? this : BasicValueFactory.DOUBLE_VALUE;
    }

    @Override
    public DoubleValue add(ParticularDoubleValue other) {
        return new ParticularDoubleValue(this.value + other.value);
    }

    @Override
    public DoubleValue subtract(ParticularDoubleValue other) {
        return new ParticularDoubleValue(this.value - other.value);
    }

    @Override
    public DoubleValue subtractFrom(ParticularDoubleValue other) {
        return new ParticularDoubleValue(other.value - this.value);
    }

    @Override
    public DoubleValue multiply(ParticularDoubleValue other) {
        return new ParticularDoubleValue(this.value * other.value);
    }

    @Override
    public DoubleValue divide(ParticularDoubleValue other) {
        return new ParticularDoubleValue(this.value / other.value);
    }

    @Override
    public DoubleValue divideOf(ParticularDoubleValue other) {
        return new ParticularDoubleValue(other.value / this.value);
    }

    @Override
    public DoubleValue remainder(ParticularDoubleValue other) {
        return new ParticularDoubleValue(this.value % other.value);
    }

    @Override
    public DoubleValue remainderOf(ParticularDoubleValue other) {
        return new ParticularDoubleValue(other.value % this.value);
    }

    @Override
    public IntegerValue compare(ParticularDoubleValue other) {
        return this.value < other.value ? ParticularValueFactory.INTEGER_VALUE_M1 : (this.value == other.value ? ParticularValueFactory.INTEGER_VALUE_0 : ParticularValueFactory.INTEGER_VALUE_1);
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && Double.doubleToLongBits(this.value) == Double.doubleToLongBits(((ParticularDoubleValue)object).value);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ (int)Double.doubleToLongBits(this.value);
    }

    public String toString() {
        return this.value + "d";
    }
}

