/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.Collections;
import java.util.stream.Collectors;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.RecordAttribute;
import proguard.classfile.attribute.RecordComponentInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.attribute.visitor.RecordComponentInfoVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.NamedAttributeDeleter;
import proguard.classfile.kotlin.KotlinAnnotatable;
import proguard.classfile.kotlin.KotlinAnnotation;
import proguard.classfile.kotlin.KotlinAnnotationArgument;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstants;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.reflect.util.KotlinCallableReferenceInitializer;
import proguard.classfile.kotlin.visitor.AllPropertyVisitor;
import proguard.classfile.kotlin.visitor.AllTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinAnnotationArgumentVisitor;
import proguard.classfile.kotlin.visitor.KotlinAnnotationVisitor;
import proguard.classfile.kotlin.visitor.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitor.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitor.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitor.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitor.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitor.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitor.ReferencedKotlinMetadataVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceInitializer
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
RecordComponentInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final boolean checkAccessRules;
    private final WarningPrinter missingClassWarningPrinter;
    private final WarningPrinter missingProgramMemberWarningPrinter;
    private final WarningPrinter missingLibraryMemberWarningPrinter;
    private final WarningPrinter dependencyWarningPrinter;
    private final MemberFinder memberFinder = new MemberFinder();
    private final MemberFinder strictMemberFinder = new MemberFinder(false);
    private final KotlinReferenceInitializer kotlinReferenceInitializer;

    public ClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool) {
        this(programClassPool, libraryClassPool, true);
    }

    public ClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, boolean checkAccessRules) {
        this(programClassPool, libraryClassPool, checkAccessRules, null, null, null, null);
    }

    public ClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter missingClassWarningPrinter, WarningPrinter missingProgramMemberWarningPrinter, WarningPrinter missingLibraryMemberWarningPrinter, WarningPrinter dependencyWarningPrinter) {
        this(programClassPool, libraryClassPool, true, missingClassWarningPrinter, missingProgramMemberWarningPrinter, missingLibraryMemberWarningPrinter, dependencyWarningPrinter);
    }

    public ClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, boolean checkAccessRules, WarningPrinter missingClassWarningPrinter, WarningPrinter missingProgramMemberWarningPrinter, WarningPrinter missingLibraryMemberWarningPrinter, WarningPrinter dependencyWarningPrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.checkAccessRules = checkAccessRules;
        this.missingClassWarningPrinter = missingClassWarningPrinter;
        this.missingProgramMemberWarningPrinter = missingProgramMemberWarningPrinter;
        this.missingLibraryMemberWarningPrinter = missingLibraryMemberWarningPrinter;
        this.dependencyWarningPrinter = dependencyWarningPrinter;
        this.kotlinReferenceInitializer = new KotlinReferenceInitializer();
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + clazz.getClass().getName());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        programClass.kotlinMetadataAccept(this.kotlinReferenceInitializer);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
        libraryClass.kotlinMetadataAccept(this.kotlinReferenceInitializer);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.referencedClass = this.findReferencedClass(programClass, programField.getDescriptor(programClass));
        programField.attributesAccept(programClass, this);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.referencedClasses = this.findReferencedClasses(programClass, programMethod.getDescriptor(programClass));
        programMethod.attributesAccept(programClass, this);
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        libraryField.referencedClass = this.findReferencedClass(libraryClass, libraryField.getDescriptor(libraryClass));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryMethod.referencedClasses = this.findReferencedClasses(libraryClass, libraryMethod.getDescriptor(libraryClass));
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.javaLangStringClass = this.findClass(clazz, "java/lang/String");
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        dynamicConstant.referencedClasses = this.findReferencedClasses(clazz, dynamicConstant.getType(clazz));
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.referencedClasses = this.findReferencedClasses(clazz, invokeDynamicConstant.getType(clazz));
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        methodHandleConstant.javaLangInvokeMethodHandleClass = this.findClass(clazz, "java/lang/invoke/MethodHandle");
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        Clazz referencedClass;
        String className = fieldrefConstant.getClassName(clazz);
        if (ClassUtil.isInternalArrayType(className)) {
            className = "java/lang/Object";
        }
        if ((referencedClass = this.findClass(clazz, className)) != null) {
            String name = fieldrefConstant.getName(clazz);
            String type = fieldrefConstant.getType(clazz);
            Clazz referencingClass = this.checkAccessRules ? clazz : null;
            fieldrefConstant.referencedField = this.memberFinder.findField(referencingClass, referencedClass, name, type);
            fieldrefConstant.referencedClass = this.memberFinder.correspondingClass();
            if (fieldrefConstant.referencedField == null) {
                WarningPrinter missingMemberWarningPrinter;
                boolean isProgramClass = referencedClass instanceof ProgramClass;
                WarningPrinter warningPrinter = missingMemberWarningPrinter = isProgramClass ? this.missingProgramMemberWarningPrinter : this.missingLibraryMemberWarningPrinter;
                if (missingMemberWarningPrinter != null) {
                    missingMemberWarningPrinter.print(clazz.getName(), className, "Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find referenced field '" + ClassUtil.externalFullFieldDescription(0, name, type) + "' in " + (isProgramClass ? "program" : "library") + " class " + ClassUtil.externalClassName(className));
                }
            }
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        Clazz referencedClass;
        String className = anyMethodrefConstant.getClassName(clazz);
        if (ClassUtil.isInternalArrayType(className)) {
            className = "java/lang/Object";
        }
        if ((referencedClass = this.findClass(clazz, className)) != null) {
            String name = anyMethodrefConstant.getName(clazz);
            String type = anyMethodrefConstant.getType(clazz);
            boolean isFieldRef = anyMethodrefConstant.getTag() == 9;
            Clazz referencingClass = this.checkAccessRules ? clazz : null;
            anyMethodrefConstant.referencedMethod = this.memberFinder.findMethod(referencingClass, referencedClass, name, type);
            anyMethodrefConstant.referencedClass = this.memberFinder.correspondingClass();
            if (anyMethodrefConstant.referencedMethod == null) {
                WarningPrinter missingMemberWarningPrinter;
                boolean isProgramClass = referencedClass instanceof ProgramClass;
                WarningPrinter warningPrinter = missingMemberWarningPrinter = isProgramClass ? this.missingProgramMemberWarningPrinter : this.missingLibraryMemberWarningPrinter;
                if (missingMemberWarningPrinter != null) {
                    missingMemberWarningPrinter.print(clazz.getName(), className, "Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find referenced method '" + ClassUtil.externalFullMethodDescription(className, 0, name, type) + "' in " + (isProgramClass ? "program" : "library") + " class " + ClassUtil.externalClassName(className));
                }
            }
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClass = this.findClass(clazz, ClassUtil.internalClassNameFromClassType(classConstant.getName(clazz)));
        classConstant.javaLangClassClass = this.findClass(clazz, "java/lang/Class");
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        methodTypeConstant.javaLangInvokeMethodTypeClass = this.findClass(clazz, "java/lang/invoke/MethodType");
        methodTypeConstant.referencedClasses = this.findReferencedClasses(clazz, methodTypeConstant.getType(clazz));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitRecordAttribute(Clazz clazz, RecordAttribute recordAttributeAttribute) {
        recordAttributeAttribute.componentsAccept(clazz, this);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        String enclosingClassName = enclosingMethodAttribute.getClassName(clazz);
        enclosingMethodAttribute.referencedClass = this.findClass(clazz, enclosingClassName);
        if (enclosingMethodAttribute.referencedClass != null) {
            if (enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
                String name = enclosingMethodAttribute.getName(clazz);
                String type = enclosingMethodAttribute.getType(clazz);
                enclosingMethodAttribute.referencedMethod = enclosingMethodAttribute.referencedClass.findMethod(name, type);
                if (enclosingMethodAttribute.referencedMethod == null && this.missingProgramMemberWarningPrinter != null) {
                    String className = clazz.getName();
                    this.missingProgramMemberWarningPrinter.print(className, enclosingClassName, "Warning: " + ClassUtil.externalClassName(className) + ": can't find enclosing method '" + ClassUtil.externalFullMethodDescription(enclosingClassName, 0, name, type) + "' in program class " + ClassUtil.externalClassName(enclosingClassName));
                }
            }
        } else if (enclosingClassName != null && enclosingClassName.indexOf(36) != -1) {
            String myEnclosingClassName = enclosingClassName;
            do {
                myEnclosingClassName = myEnclosingClassName.substring(0, myEnclosingClassName.lastIndexOf("$"));
                enclosingMethodAttribute.referencedClass = this.findClass(clazz, myEnclosingClassName, false);
            } while (enclosingMethodAttribute.referencedClass == null && myEnclosingClassName.indexOf(36) != -1);
            if (enclosingMethodAttribute.referencedClass == null && clazz != null && this.missingClassWarningPrinter != null) {
                this.reportMissingClass(clazz.getName(), enclosingClassName);
            }
        }
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, Member member, SignatureAttribute signatureAttribute) {
        try {
            signatureAttribute.referencedClasses = this.findReferencedClasses(clazz, signatureAttribute.getSignature(clazz));
        }
        catch (Exception corruptSignature) {
            member.accept(clazz, new NamedAttributeDeleter("Signature"));
        }
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, RecordComponentInfo recordComponentInfo, SignatureAttribute signatureAttribute) {
        try {
            signatureAttribute.referencedClasses = this.findReferencedClasses(clazz, signatureAttribute.getSignature(clazz));
        }
        catch (Exception corruptSignature) {
            recordComponentInfo.attributesAccept(clazz, new NamedAttributeDeleter("Signature"));
        }
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        if (this.isValidClassSignature(clazz, signatureAttribute.getSignature(clazz))) {
            signatureAttribute.referencedClasses = this.findReferencedClasses(clazz, signatureAttribute.getSignature(clazz));
        } else {
            clazz.accept(new NamedAttributeDeleter("Signature"));
        }
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitRecordComponentInfo(Clazz clazz, RecordComponentInfo recordComponentInfo) {
        String name = recordComponentInfo.getName(clazz);
        String type = recordComponentInfo.getDescriptor(clazz);
        recordComponentInfo.referencedField = this.memberFinder.findField(clazz, name, type);
        recordComponentInfo.attributesAccept(clazz, this);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClass = this.findReferencedClass(clazz, localVariableInfo.getDescriptor(clazz));
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.referencedClasses = this.findReferencedClasses(clazz, localVariableTypeInfo.getSignature(clazz));
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.referencedClasses = this.findReferencedClasses(clazz, annotation.getType(clazz));
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.initializeElementValue(clazz, annotation, constantElementValue);
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.initializeElementValue(clazz, annotation, enumConstantElementValue);
        enumConstantElementValue.referencedClasses = this.findReferencedClasses(clazz, enumConstantElementValue.getTypeName(clazz));
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.initializeElementValue(clazz, annotation, classElementValue);
        classElementValue.referencedClasses = this.findReferencedClasses(clazz, classElementValue.getClassName(clazz));
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.initializeElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.initializeElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void initializeElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        if (annotation != null && annotation.referencedClasses != null && elementValue.u2elementNameIndex != 0) {
            Clazz referencedClass;
            String name = elementValue.getMethodName(clazz);
            elementValue.referencedClass = referencedClass = annotation.referencedClasses[0];
            elementValue.referencedMethod = referencedClass.findMethod(name, null);
        }
    }

    private Clazz findReferencedClass(Clazz referencingClass, String descriptor) {
        DescriptorClassEnumeration enumeration = new DescriptorClassEnumeration(descriptor);
        enumeration.nextFluff();
        if (enumeration.hasMoreClassNames()) {
            return this.findClass(referencingClass, enumeration.nextClassName());
        }
        return null;
    }

    private Clazz[] findReferencedClasses(Clazz referencingClass, String descriptor) {
        DescriptorClassEnumeration enumeration = new DescriptorClassEnumeration(descriptor);
        int classCount = enumeration.classCount();
        if (classCount > 0) {
            Clazz[] referencedClasses = new Clazz[classCount];
            boolean foundReferencedClasses = false;
            for (int index = 0; index < classCount; ++index) {
                String fluff = enumeration.nextFluff();
                String name = enumeration.nextClassName();
                Clazz referencedClass = this.findClass(referencingClass, name);
                if (referencedClass == null) continue;
                referencedClasses[index] = referencedClass;
                foundReferencedClasses = true;
            }
            if (foundReferencedClasses) {
                return referencedClasses;
            }
        }
        return null;
    }

    private Clazz findKotlinClass(Clazz referencingClass, String name) {
        Clazz clazz = KotlinConstants.dummyClassPool.getClass(name);
        if (clazz == null) {
            clazz = this.findClass(referencingClass, name);
        }
        return clazz;
    }

    private Clazz findClass(Clazz referencingClass, String name) {
        return this.findClass(referencingClass, name, true);
    }

    private Clazz findClass(Clazz referencingClass, String name, boolean report) {
        Clazz clazz;
        if (ClassUtil.isInternalArrayType(name)) {
            if (!ClassUtil.isInternalClassType(name)) {
                return null;
            }
            name = ClassUtil.internalClassNameFromClassType(name);
        }
        if ((clazz = this.programClassPool.getClass(name)) == null) {
            clazz = this.libraryClassPool.getClass(name);
            if (report && clazz == null && this.missingClassWarningPrinter != null) {
                this.reportMissingClass(referencingClass.getName(), name);
            }
        } else if (this.dependencyWarningPrinter != null) {
            String referencingClassName = referencingClass.getName();
            this.dependencyWarningPrinter.print(referencingClassName, name, "Warning: library class " + ClassUtil.externalClassName(referencingClassName) + " depends on program class " + ClassUtil.externalClassName(name));
        }
        return clazz;
    }

    private void reportMissingClass(String referencingClassName, String name) {
        this.missingClassWarningPrinter.print(referencingClassName, name, "Warning: " + ClassUtil.externalClassName(referencingClassName) + ": can't find referenced class " + ClassUtil.externalClassName(name));
    }

    private boolean isValidClassSignature(Clazz clazz, String signature) {
        try {
            new DescriptorClassEnumeration(signature).classCount();
            InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signature);
            if (!internalTypeEnumeration.hasMoreTypes()) {
                return false;
            }
            String superName = clazz.getSuperName();
            String signSuperName = ClassUtil.internalClassNameFromClassType(internalTypeEnumeration.nextType());
            if (superName != null && !signSuperName.startsWith(superName)) {
                return false;
            }
            for (int i = 0; i < clazz.getInterfaceCount(); ++i) {
                if (!internalTypeEnumeration.hasMoreTypes()) {
                    return false;
                }
                String intfName = clazz.getInterfaceName(i);
                String signIntfName = ClassUtil.internalClassNameFromClassType(internalTypeEnumeration.nextType());
                if (signIntfName.startsWith(intfName)) continue;
                return false;
            }
            return !internalTypeEnumeration.hasMoreTypes();
        }
        catch (Exception corruptedSignature) {
            return false;
        }
    }

    private class KotlinCompanionParentPropertyInitializer
    implements AttributeVisitor,
    InnerClassesInfoVisitor,
    ConstantVisitor {
        private KotlinCompanionParentPropertyInitializer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
            innerClassesAttribute.innerClassEntriesAccept(clazz, this);
        }

        @Override
        public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
            innerClassesInfo.outerClassConstantAccept(clazz, this);
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            if (classConstant.referencedClass != null) {
                clazz.kotlinMetadataAccept(new AllPropertyVisitor(new KotlinInterClassPropertyReferenceInitializer(classConstant.referencedClass)));
            }
        }
    }

    private static class KotlinInterClassSyntheticFunctionInitializer
    implements KotlinFunctionVisitor,
    AttributeVisitor {
        private KotlinFunctionMetadata currentFunction;

        private KotlinInterClassSyntheticFunctionInitializer() {
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            if (kotlinFunctionMetadata.referencedMethod == null) {
                this.currentFunction = kotlinFunctionMetadata;
                clazz.attributeAccept("EnclosingMethod", this);
            }
        }

        @Override
        public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
            Method enclosingMethod = enclosingMethodAttribute.referencedMethod;
            Clazz enclosingMethodClass = enclosingMethodAttribute.referencedClass;
            if (enclosingMethod != null && this.currentFunction.jvmSignature != null && enclosingMethod.getName(enclosingMethodClass).equals(this.currentFunction.jvmSignature.method)) {
                this.currentFunction.referencedMethod = enclosingMethod;
                this.currentFunction.referencedMethodClass = enclosingMethodClass;
            }
        }
    }

    private class KotlinInterClassPropertyReferenceInitializer
    implements KotlinPropertyVisitor {
        private final Clazz clazz;

        KotlinInterClassPropertyReferenceInitializer(Clazz clazz) {
            this.clazz = clazz;
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            if (kotlinPropertyMetadata.backingFieldSignature != null && kotlinPropertyMetadata.referencedBackingField == null) {
                kotlinPropertyMetadata.referencedBackingField = ClassReferenceInitializer.this.strictMemberFinder.findField(this.clazz, kotlinPropertyMetadata.backingFieldSignature.memberName, kotlinPropertyMetadata.backingFieldSignature.descriptor);
                kotlinPropertyMetadata.referencedBackingFieldClass = ClassReferenceInitializer.this.strictMemberFinder.correspondingClass();
            }
            if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null && kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations == null) {
                kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations = ClassReferenceInitializer.this.strictMemberFinder.findMethod(this.clazz, kotlinPropertyMetadata.syntheticMethodForAnnotations.method, kotlinPropertyMetadata.syntheticMethodForAnnotations.descriptor.toString());
                kotlinPropertyMetadata.referencedSyntheticMethodClass = ClassReferenceInitializer.this.strictMemberFinder.correspondingClass();
            }
        }
    }

    private class KotlinDefaultMethodInitializer
    implements KotlinFunctionVisitor {
        boolean isInterface = false;
        boolean hasDefaults = false;

        private KotlinDefaultMethodInitializer() {
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            if (kotlinFunctionMetadata.referencedMethod == null) {
                return;
            }
            String methodName = kotlinFunctionMetadata.referencedMethod.getName(kotlinFunctionMetadata.referencedMethodClass);
            if (methodName.endsWith("$default")) {
                return;
            }
            this.hasDefaults = false;
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, (_clazz, vp) -> this.hasDefaults |= vp.flags.hasDefaultValue);
            if (this.hasDefaults) {
                Clazz defaultImplsClass;
                String defaultMethodName = methodName + "$default";
                String descriptor = this.getDescriptor(kotlinFunctionMetadata);
                kotlinFunctionMetadata.referencedDefaultMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(kotlinFunctionMetadata.referencedMethodClass, defaultMethodName, descriptor);
                kotlinFunctionMetadata.referencedDefaultMethodClass = ClassReferenceInitializer.this.strictMemberFinder.correspondingClass();
                if (kotlinFunctionMetadata.referencedDefaultMethod == null && this.isInterface && (defaultImplsClass = ClassReferenceInitializer.this.programClassPool.getClass(clazz.getName() + "$DefaultImpls")) != null) {
                    kotlinFunctionMetadata.referencedDefaultMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(defaultImplsClass, defaultMethodName, descriptor);
                    kotlinFunctionMetadata.referencedDefaultMethodClass = ClassReferenceInitializer.this.strictMemberFinder.correspondingClass();
                }
            }
        }

        private String getDescriptor(KotlinFunctionMetadata kotlinFunctionMetadata) {
            String originalDescriptor = kotlinFunctionMetadata.referencedMethod.getDescriptor(kotlinFunctionMetadata.referencedMethodClass);
            int requiredIntParams = 1 + ClassUtil.internalMethodParameterCount(originalDescriptor) / 32;
            String descriptor = originalDescriptor.replace(")", String.join((CharSequence)"", Collections.nCopies(requiredIntParams, "I")) + "Ljava/lang/Object;)");
            if ((kotlinFunctionMetadata.referencedMethod.getAccessFlags() & 8) == 0) {
                descriptor = descriptor.replace("(", "(L" + kotlinFunctionMetadata.referencedMethodClass.getName() + ";");
            }
            return descriptor;
        }
    }

    private class KotlinDefaultImplsInitializer
    implements KotlinFunctionVisitor {
        private Clazz defaultImplsClass;

        private KotlinDefaultImplsInitializer() {
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            if (this.defaultImplsClass != null && kotlinFunctionMetadata.jvmSignature != null && !kotlinFunctionMetadata.flags.modality.isAbstract) {
                kotlinFunctionMetadata.referencedDefaultImplementationMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(this.defaultImplsClass, kotlinFunctionMetadata.jvmSignature.method, this.getDescriptor(kotlinDeclarationContainerMetadata, kotlinFunctionMetadata));
                if (kotlinFunctionMetadata.referencedDefaultImplementationMethod != null) {
                    kotlinFunctionMetadata.referencedDefaultImplementationMethodClass = this.defaultImplsClass;
                }
            }
        }

        private String getDescriptor(KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            return kotlinFunctionMetadata.jvmSignature.descriptor.toString().replace("(", "(L" + kotlinDeclarationContainerMetadata.ownerClassName + ";");
        }
    }

    public static class KotlinTypeAliasReferenceInitializer
    implements KotlinMetadataVisitor,
    KotlinTypeAliasVisitor {
        private final KotlinTypeMetadata kotlinTypeMetadata;
        private final String simpleName;

        KotlinTypeAliasReferenceInitializer(KotlinTypeMetadata kotlinTypeMetadata, String simpleName) {
            this.simpleName = simpleName;
            this.kotlinTypeMetadata = kotlinTypeMetadata;
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, this);
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            if (this.kotlinTypeMetadata.aliasName.equals(clazz.getName() + "." + this.simpleName)) {
                kotlinClassKindMetadata.typeAliasesAccept(clazz, this);
            }
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            if (this.simpleName.equals(kotlinTypeAliasMetadata.name)) {
                this.kotlinTypeMetadata.referencedTypeAlias = kotlinTypeAliasMetadata;
            }
        }
    }

    private class KotlinReferenceInitializer
    implements KotlinMetadataVisitor,
    KotlinPropertyVisitor,
    KotlinFunctionVisitor,
    KotlinConstructorVisitor,
    KotlinTypeVisitor,
    KotlinTypeAliasVisitor,
    KotlinValueParameterVisitor,
    KotlinTypeParameterVisitor,
    KotlinAnnotationVisitor,
    KotlinAnnotationArgumentVisitor {
        private final KotlinDefaultImplsInitializer kotlinDefaultImplsInitializer;
        private final KotlinDefaultMethodInitializer kotlinDefaultMethodInitializer;
        private final KotlinInterClassSyntheticFunctionInitializer interClassSyntheticFunctionInitializer;
        private final KotlinCallableReferenceInitializer callableReferenceInitializer;

        private KotlinReferenceInitializer() {
            this.kotlinDefaultImplsInitializer = new KotlinDefaultImplsInitializer();
            this.kotlinDefaultMethodInitializer = new KotlinDefaultMethodInitializer();
            this.interClassSyntheticFunctionInitializer = new KotlinInterClassSyntheticFunctionInitializer();
            this.callableReferenceInitializer = new KotlinCallableReferenceInitializer(ClassReferenceInitializer.this.programClassPool, ClassReferenceInitializer.this.libraryClassPool);
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            kotlinDeclarationContainerMetadata.ownerReferencedClass = clazz;
            kotlinDeclarationContainerMetadata.propertiesAccept(clazz, this);
            kotlinDeclarationContainerMetadata.delegatedPropertiesAccept(clazz, this);
            kotlinDeclarationContainerMetadata.functionsAccept(clazz, this);
            kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, this);
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            kotlinClassKindMetadata.referencedClass = ClassReferenceInitializer.this.findClass(clazz, kotlinClassKindMetadata.className);
            if (kotlinClassKindMetadata.anonymousObjectOriginName != null) {
                kotlinClassKindMetadata.anonymousObjectOriginClass = ClassReferenceInitializer.this.findClass(clazz, kotlinClassKindMetadata.anonymousObjectOriginName, false);
                if (kotlinClassKindMetadata.anonymousObjectOriginClass == null) {
                    kotlinClassKindMetadata.anonymousObjectOriginName = null;
                }
            }
            if (kotlinClassKindMetadata.companionObjectName != null) {
                String name = clazz.getName() + "$" + kotlinClassKindMetadata.companionObjectName;
                kotlinClassKindMetadata.referencedCompanionClass = ClassReferenceInitializer.this.findClass(clazz, name);
                kotlinClassKindMetadata.referencedCompanionField = ClassReferenceInitializer.this.memberFinder.findField(clazz, kotlinClassKindMetadata.companionObjectName, ClassUtil.internalTypeFromClassName(name));
            }
            kotlinClassKindMetadata.referencedEnumEntries = kotlinClassKindMetadata.enumEntryNames.stream().map(enumEntry -> ClassReferenceInitializer.this.strictMemberFinder.findField(clazz, (String)enumEntry, null)).collect(Collectors.toList());
            kotlinClassKindMetadata.referencedNestedClasses = kotlinClassKindMetadata.nestedClassNames.stream().map(nestedName -> ClassReferenceInitializer.this.findClass(clazz, clazz.getName() + "$" + nestedName)).collect(Collectors.toList());
            kotlinClassKindMetadata.referencedSealedSubClasses = kotlinClassKindMetadata.sealedSubclassNames.stream().map(sealedSubName -> ClassReferenceInitializer.this.findClass(clazz, sealedSubName)).collect(Collectors.toList());
            kotlinClassKindMetadata.typeParametersAccept(clazz, this);
            kotlinClassKindMetadata.superTypesAccept(clazz, this);
            kotlinClassKindMetadata.constructorsAccept(clazz, this);
            kotlinClassKindMetadata.inlineClassUnderlyingPropertyTypeAccept(clazz, this);
            this.visitKotlinDeclarationContainerMetadata(clazz, kotlinClassKindMetadata);
            if (kotlinClassKindMetadata.flags.isInterface || kotlinClassKindMetadata.flags.isAnnotationClass) {
                kotlinClassKindMetadata.referencedDefaultImplsClass = ClassReferenceInitializer.this.programClassPool.getClass(kotlinClassKindMetadata.className + "$DefaultImpls");
                if (kotlinClassKindMetadata.referencedDefaultImplsClass != null) {
                    this.kotlinDefaultImplsInitializer.defaultImplsClass = kotlinClassKindMetadata.referencedDefaultImplsClass;
                    kotlinClassKindMetadata.functionsAccept(clazz, this.kotlinDefaultImplsInitializer);
                    kotlinClassKindMetadata.accept(clazz, new AllPropertyVisitor(new KotlinInterClassPropertyReferenceInitializer(kotlinClassKindMetadata.referencedDefaultImplsClass)));
                }
            }
            this.kotlinDefaultMethodInitializer.isInterface = kotlinClassKindMetadata.flags.isInterface;
            kotlinClassKindMetadata.functionsAccept(clazz, this.kotlinDefaultMethodInitializer);
            if (kotlinClassKindMetadata.flags.isCompanionObject) {
                clazz.attributeAccept("InnerClasses", new KotlinCompanionParentPropertyInitializer());
            }
        }

        @Override
        public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
            this.visitKotlinDeclarationContainerMetadata(clazz, kotlinFileFacadeKindMetadata);
            this.kotlinDefaultMethodInitializer.isInterface = false;
            kotlinFileFacadeKindMetadata.functionsAccept(clazz, this.kotlinDefaultMethodInitializer);
        }

        @Override
        public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
            kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
            this.kotlinDefaultMethodInitializer.isInterface = false;
            kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this.kotlinDefaultMethodInitializer);
            kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this.interClassSyntheticFunctionInitializer);
            kotlinSyntheticClassKindMetadata.accept(clazz, this.callableReferenceInitializer);
        }

        @Override
        public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
            kotlinMultiFileFacadeKindMetadata.referencedPartClasses = kotlinMultiFileFacadeKindMetadata.partClassNames.stream().map(partName -> ClassReferenceInitializer.this.findClass(clazz, partName)).collect(Collectors.toList());
        }

        @Override
        public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
            kotlinMultiFilePartKindMetadata.referencedFacadeClass = ClassReferenceInitializer.this.findClass(clazz, kotlinMultiFilePartKindMetadata.facadeName);
            this.visitKotlinDeclarationContainerMetadata(clazz, kotlinMultiFilePartKindMetadata);
            this.kotlinDefaultMethodInitializer.isInterface = false;
            kotlinMultiFilePartKindMetadata.functionsAccept(clazz, this.kotlinDefaultMethodInitializer);
            if (kotlinMultiFilePartKindMetadata.referencedFacadeClass != null) {
                kotlinMultiFilePartKindMetadata.accept(clazz, new AllPropertyVisitor(new KotlinInterClassPropertyReferenceInitializer(kotlinMultiFilePartKindMetadata.referencedFacadeClass)));
            }
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            if (kotlinPropertyMetadata.backingFieldSignature != null) {
                kotlinPropertyMetadata.referencedBackingField = ClassReferenceInitializer.this.strictMemberFinder.findField(clazz, kotlinPropertyMetadata.backingFieldSignature.memberName, kotlinPropertyMetadata.backingFieldSignature.descriptor);
                kotlinPropertyMetadata.referencedBackingFieldClass = ClassReferenceInitializer.this.strictMemberFinder.correspondingClass();
            }
            if (kotlinPropertyMetadata.getterSignature != null) {
                kotlinPropertyMetadata.referencedGetterMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(clazz, kotlinPropertyMetadata.getterSignature.method, kotlinPropertyMetadata.getterSignature.descriptor.toString());
            }
            if (kotlinPropertyMetadata.setterSignature != null) {
                kotlinPropertyMetadata.referencedSetterMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(clazz, kotlinPropertyMetadata.setterSignature.method, kotlinPropertyMetadata.setterSignature.descriptor.toString());
            }
            if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
                kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations = ClassReferenceInitializer.this.strictMemberFinder.findMethod(clazz, kotlinPropertyMetadata.syntheticMethodForAnnotations.method, kotlinPropertyMetadata.syntheticMethodForAnnotations.descriptor.toString());
                kotlinPropertyMetadata.referencedSyntheticMethodClass = ClassReferenceInitializer.this.strictMemberFinder.correspondingClass();
            }
            if (kotlinPropertyMetadata.syntheticMethodForDelegate != null) {
                kotlinPropertyMetadata.referencedSyntheticMethodForDelegateMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(clazz, kotlinPropertyMetadata.syntheticMethodForDelegate.method, kotlinPropertyMetadata.syntheticMethodForDelegate.descriptor.toString());
                kotlinPropertyMetadata.referencedSyntheticMethodForDelegateClass = ClassReferenceInitializer.this.strictMemberFinder.correspondingClass();
            }
            kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            kotlinFunctionMetadata.referencedMethodClass = clazz;
            if (kotlinFunctionMetadata.jvmSignature != null) {
                kotlinFunctionMetadata.referencedMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(kotlinFunctionMetadata.referencedMethodClass, kotlinFunctionMetadata.jvmSignature.method, kotlinFunctionMetadata.jvmSignature.descriptor.toString());
            }
            if (kotlinFunctionMetadata.lambdaClassOriginName != null) {
                kotlinFunctionMetadata.referencedLambdaClassOrigin = ClassReferenceInitializer.this.findClass(clazz, kotlinFunctionMetadata.lambdaClassOriginName, false);
                if (kotlinFunctionMetadata.referencedLambdaClassOrigin == null) {
                    kotlinFunctionMetadata.lambdaClassOriginName = null;
                }
            }
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinMetadata, new AllTypeVisitor(this));
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinMetadata, this);
        }

        @Override
        public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
            if (kotlinConstructorMetadata.jvmSignature != null) {
                kotlinConstructorMetadata.referencedMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(clazz, kotlinConstructorMetadata.jvmSignature.method, kotlinConstructorMetadata.jvmSignature.descriptor.toString());
            }
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, this);
        }

        @Override
        public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
            String className = kotlinTypeMetadata.className;
            if (className != null) {
                kotlinTypeMetadata.referencedClass = ClassReferenceInitializer.this.findKotlinClass(clazz, className);
            } else if (kotlinTypeMetadata.aliasName != null) {
                String simpleName;
                String classNameFilter;
                String aliasName = kotlinTypeMetadata.aliasName;
                int innerClassMarkerIndex = aliasName.lastIndexOf(46);
                if (innerClassMarkerIndex != -1) {
                    classNameFilter = aliasName.substring(0, innerClassMarkerIndex);
                    simpleName = aliasName.substring(innerClassMarkerIndex + 1);
                } else {
                    classNameFilter = ClassUtil.internalPackagePrefix(aliasName) + "*";
                    simpleName = ClassUtil.internalSimpleClassName(kotlinTypeMetadata.aliasName);
                }
                ClassReferenceInitializer.this.programClassPool.classesAccept(classNameFilter, (ClassVisitor)new ReferencedKotlinMetadataVisitor(new KotlinTypeAliasReferenceInitializer(kotlinTypeMetadata, simpleName)));
            }
            kotlinTypeMetadata.annotationsAccept(clazz, this);
            kotlinTypeMetadata.typeArgumentsAccept(clazz, this);
            kotlinTypeMetadata.outerClassAccept(clazz, this);
            kotlinTypeMetadata.upperBoundsAccept(clazz, this);
            kotlinTypeMetadata.abbreviationAccept(clazz, this);
        }

        @Override
        public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
            kotlinTypeAliasMetadata.referencedDeclarationContainer = kotlinDeclarationContainerMetadata;
            kotlinTypeAliasMetadata.annotationsAccept(clazz, this);
            kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        }

        @Override
        public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        }

        @Override
        public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        }

        @Override
        public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)this);
        }

        @Override
        public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)this);
        }

        @Override
        public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
            kotlinTypeParameterMetadata.annotationsAccept(clazz, this);
            kotlinTypeParameterMetadata.upperBoundsAccept(clazz, this);
        }

        @Override
        public void visitAnyAnnotation(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation) {
            annotation.referencedAnnotationClass = ClassReferenceInitializer.this.findClass(clazz, annotation.className);
            if (annotation.referencedAnnotationClass != null) {
                annotation.argumentsAccept(clazz, annotatable, this);
            }
        }

        @Override
        public void visitAnyArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.Value value) {
            argument.referencedAnnotationMethodClass = annotation.referencedAnnotationClass;
            argument.referencedAnnotationMethod = ClassReferenceInitializer.this.strictMemberFinder.findMethod(annotation.referencedAnnotationClass, argument.name, null);
        }

        @Override
        public void visitClassArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.ClassValue value) {
            this.visitAnyArgument(clazz, annotatable, annotation, argument, value);
            value.referencedClass = ClassReferenceInitializer.this.findKotlinClass(clazz, value.className);
        }

        @Override
        public void visitEnumArgument(Clazz clazz, KotlinAnnotatable annotatable, KotlinAnnotation annotation, KotlinAnnotationArgument argument, KotlinAnnotationArgument.EnumValue value) {
            this.visitAnyArgument(clazz, annotatable, annotation, argument, value);
            value.referencedClass = ClassReferenceInitializer.this.findClass(clazz, value.className);
        }
    }
}

