/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import proguard.analysis.cpa.defaults.BamCpaRun;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SequentialCpaRun;
import proguard.analysis.cpa.domain.arg.ArgBamCpaRun;
import proguard.analysis.cpa.domain.arg.ArgProgramLocationDependentAbstractStateFactory;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.ConfigurableProgramAnalysis;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.interfaces.ReachedSet;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationCpa;
import proguard.analysis.cpa.jvm.domain.memory.TraceExtractor;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.classfile.MethodSignature;

public abstract class JvmMemoryLocationBamCpaRun<CpaT extends ConfigurableProgramAnalysis, AbstractStateT extends LatticeAbstractState<AbstractStateT>>
extends SequentialCpaRun<JvmMemoryLocationCpa<AbstractStateT>, JvmMemoryLocationAbstractState, ArgBamCpaRun<CpaT, ? extends ProgramLocationDependent<JvmCfaNode, JvmCfaEdge, MethodSignature>, JvmCfaNode, JvmCfaEdge, MethodSignature>>
implements TraceExtractor<AbstractStateT> {
    protected final AbstractStateT threshold;

    public JvmMemoryLocationBamCpaRun(BamCpaRun<CpaT, JvmAbstractState<AbstractStateT>, JvmCfaNode, JvmCfaEdge, MethodSignature> inputCpaRun, AbstractStateT threshold) {
        this(inputCpaRun, threshold, (AbortOperator)NeverAbortOperator.INSTANCE);
    }

    public JvmMemoryLocationBamCpaRun(BamCpaRun<CpaT, JvmAbstractState<AbstractStateT>, JvmCfaNode, JvmCfaEdge, MethodSignature> inputCpaRun, AbstractStateT threshold, AbortOperator abortOperator) {
        this(new ArgBamCpaRun<CpaT, JvmAbstractState<AbstractStateT>, JvmCfaNode, JvmCfaEdge, MethodSignature>(inputCpaRun, new ArgProgramLocationDependentAbstractStateFactory(s -> {
            JvmAbstractState state = (JvmAbstractState)s.getStateByName("Jvm");
            if (!state.getFrame().getLocalVariables().stream().allMatch(threshold::isLessOrEqual)) return false;
            if (!state.getFrame().getOperandStack().stream().allMatch(threshold::isLessOrEqual)) return false;
            if (!state.getStaticFields().values().stream().allMatch(threshold::isLessOrEqual)) return false;
            return true;
        })), threshold, abortOperator);
    }

    public JvmMemoryLocationBamCpaRun(ArgBamCpaRun<CpaT, JvmAbstractState<AbstractStateT>, JvmCfaNode, JvmCfaEdge, MethodSignature> inputCpaRun, AbstractStateT threshold, AbortOperator abortOperator) {
        super(inputCpaRun);
        this.threshold = threshold;
        this.cpa = new JvmMemoryLocationCpa<AbstractStateT>(threshold);
        this.abortOperator = abortOperator;
    }

    @Override
    public ReachedSet createReachedSet() {
        return new ProgramLocationDependentReachedSet();
    }

    @Override
    public ProgramLocationDependentReachedSet<JvmCfaNode, JvmCfaEdge, JvmMemoryLocationAbstractState, MethodSignature> getOutputReachedSet() {
        return (ProgramLocationDependentReachedSet)super.getOutputReachedSet();
    }
}

