/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import proguard.analysis.cpa.domain.taint.TaintAbstractState;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.operators.JvmDefaultExpandOperator;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.instruction.Instruction;

public class JvmTaintExpandOperator
extends JvmDefaultExpandOperator<TaintAbstractState> {
    private final Map<String, TaintSource> fqnToSources;

    public JvmTaintExpandOperator(JvmCfa cfa, Map<String, TaintSource> fqnToSources) {
        super(cfa);
        this.fqnToSources = fqnToSources;
    }

    @Override
    public JvmAbstractState<TaintAbstractState> expand(AbstractState expandedInitialState, AbstractState reducedExitState, JvmCfaNode blockEntryNode, Call call) {
        JvmAbstractState<TaintAbstractState> result = super.expand(expandedInitialState, reducedExitState, blockEntryNode, call);
        TaintSource detectedSource = this.fqnToSources.get(call.getTarget().getFqn());
        if (detectedSource != null) {
            detectedSource.taintsGlobals.forEach(g -> result.setStatic((String)g, new TaintAbstractState(detectedSource)));
        }
        return result;
    }

    @Override
    protected List<TaintAbstractState> calculateReturnValues(AbstractState reducedExitState, Instruction returnInstruction, Call call) {
        int i;
        TaintSource detectedSource = this.fqnToSources.get(call.getTarget().getFqn());
        if (detectedSource == null || !detectedSource.taintsReturn) {
            return super.calculateReturnValues(reducedExitState, returnInstruction, call);
        }
        ArrayList<TaintAbstractState> returnValues = new ArrayList<TaintAbstractState>();
        TaintAbstractState answerContent = new TaintAbstractState(new TaintSource[0]);
        answerContent.add(detectedSource);
        for (i = 0; i < returnInstruction.stackPopCount(null); ++i) {
            TaintAbstractState returnByte = (TaintAbstractState)((JvmAbstractState)reducedExitState).peek(i);
            answerContent = answerContent.join(returnByte);
        }
        for (i = returnInstruction.stackPopCount(null); i > 0; --i) {
            returnValues.add(answerContent);
        }
        return returnValues;
    }
}

