/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import proguard.analysis.cpa.domain.taint.TaintAbstractState;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.transfer.JvmTransferRelation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodSignature;
import proguard.classfile.util.ClassUtil;

public class JvmTaintTransferRelation
extends JvmTransferRelation<TaintAbstractState> {
    private final Map<String, TaintSource> taintSources;

    public JvmTaintTransferRelation(Map<String, TaintSource> taintSources) {
        this.taintSources = taintSources;
    }

    @Override
    public void invokeMethod(JvmAbstractState<TaintAbstractState> state, Call call, List<TaintAbstractState> operands) {
        MethodSignature target = call.getTarget();
        TaintSource detectedSource = this.taintSources.get(target.getFqn());
        int pushCount = ClassUtil.internalTypeSize(target.descriptor.returnType == null ? "?" : target.descriptor.returnType);
        TaintAbstractState answerContent = operands.stream().reduce(this.getAbstractDefault(), TaintAbstractState::join);
        if (detectedSource != null && detectedSource.taintsReturn && !answerContent.contains(detectedSource)) {
            answerContent = answerContent.copy();
            answerContent.add(detectedSource);
        }
        for (int i = 0; i < pushCount; ++i) {
            state.push(answerContent);
        }
        HashMap<String, TaintAbstractState> fqnToValue = new HashMap<String, TaintAbstractState>();
        if (detectedSource != null) {
            TaintAbstractState newValue = new TaintAbstractState(detectedSource);
            for (String fqn : detectedSource.taintsGlobals) {
                fqnToValue.merge(fqn, newValue, TaintAbstractState::join);
            }
        }
        fqnToValue.forEach(state::setStatic);
    }

    @Override
    public TaintAbstractState getAbstractDefault() {
        return TaintAbstractState.bottom;
    }
}

