/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.util;

import java.util.Arrays;
import proguard.analysis.CallResolver;
import proguard.analysis.CallVisitor;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.visitors.JvmIntraproceduralCfaFillerAllInstructionVisitor;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.CallGraph;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.analysis.datastructure.callgraph.SymbolicCall;
import proguard.classfile.ClassPool;
import proguard.classfile.LibraryClass;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.visitor.AllMethodVisitor;

public class CfaUtil {
    public static JvmCfa createIntraproceduralCfaFromClassPool(ClassPool programClassPool) {
        JvmCfa cfa = new JvmCfa();
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new JvmIntraproceduralCfaFillerAllInstructionVisitor(cfa))));
        return cfa;
    }

    public static void addInterproceduralEdgesToCfa(JvmCfa cfa, CallGraph callGraph) {
        callGraph.outgoing.values().forEach(calls -> calls.forEach(call -> {
            if (call instanceof SymbolicCall || ((ConcreteCall)call).getTargetClass() instanceof LibraryClass || ((ConcreteCall)call).getTargetMethod() instanceof ProgramMethod && Arrays.stream(((ProgramMethod)((ConcreteCall)call).getTargetMethod()).attributes).noneMatch(a -> a instanceof CodeAttribute)) {
                cfa.addUnknownTargetInterproceduralEdge((Call)call);
            } else {
                cfa.addInterproceduralEdge((Call)call);
            }
        }));
    }

    public static JvmCfa createInterproceduralCfaFromClassPoolAndCallGraph(ClassPool programClassPool, CallGraph callGraph) {
        JvmCfa cfa = CfaUtil.createIntraproceduralCfaFromClassPool(programClassPool);
        CfaUtil.addInterproceduralEdgesToCfa(cfa, callGraph);
        return cfa;
    }

    public static JvmCfa createInterproceduralCfaFromClassPool(ClassPool programClassPool) {
        CallGraph callGraph = new CallGraph();
        CallResolver resolver = new CallResolver.Builder(programClassPool, new ClassPool(), callGraph, new CallVisitor[0]).setEvaluateAllCode(true).build();
        programClassPool.classesAccept(resolver);
        MethodSignature.clearCache();
        JvmCfa cfa = CfaUtil.createIntraproceduralCfaFromClassPool(programClassPool);
        CfaUtil.addInterproceduralEdgesToCfa(cfa, callGraph);
        return cfa;
    }
}

