/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.domain.taint;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TaintSource {
    public final String fqn;
    public final boolean taintsThis;
    public final boolean taintsReturn;
    public final Set<Integer> taintsArgs;
    public final Set<String> taintsGlobals;

    public TaintSource(String fqn, boolean taintsThis, boolean taintsReturn, Set<Integer> taintsArgs, Set<String> taintsGlobals) {
        this.fqn = fqn;
        this.taintsThis = taintsThis;
        this.taintsReturn = taintsReturn;
        this.taintsArgs = taintsArgs;
        this.taintsGlobals = taintsGlobals;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaintSource)) {
            return false;
        }
        TaintSource other = (TaintSource)obj;
        return Objects.equals(this.fqn, other.fqn) && this.taintsThis == other.taintsThis && this.taintsReturn == other.taintsReturn && Objects.equals(this.taintsArgs, other.taintsArgs) && Objects.equals(this.taintsGlobals, other.taintsGlobals);
    }

    public int hashCode() {
        return Objects.hash(this.fqn, this.taintsThis, this.taintsReturn, this.taintsArgs, this.taintsGlobals);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[TaintSource] ").append(this.fqn);
        if (this.taintsThis) {
            builder.append(", taints this");
        }
        if (this.taintsReturn) {
            builder.append(", taints return");
        }
        if (!this.taintsArgs.isEmpty()) {
            builder.append(", taints args (").append(this.taintsArgs.stream().map(Object::toString).sorted().collect(Collectors.joining(", "))).append(")");
        }
        if (!this.taintsGlobals.isEmpty()) {
            builder.append(", taints globals (").append(this.taintsGlobals.stream().sorted().collect(Collectors.joining(", "))).append(")");
        }
        return builder.toString();
    }
}

