/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.bam;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.classfile.Signature;

public class BamCacheImpl<SignatureT extends Signature>
implements BamCache<SignatureT> {
    private static final Logger log = LogManager.getLogger(BamCacheImpl.class);
    private final Map<SignatureT, Map<HashKey, BlockAbstraction>> cache = new HashMap<SignatureT, Map<HashKey, BlockAbstraction>>();
    private int size = 0;

    @Override
    public void put(AbstractState stateKey, Precision precisionKey, SignatureT blockKey, BlockAbstraction blockAbstraction) {
        if (this.cache.computeIfAbsent(blockKey, k -> new HashMap()).put(this.getHashKey(stateKey, precisionKey), blockAbstraction) == null) {
            ++this.size;
            log.debug((Object)this.size);
        }
    }

    @Override
    public BlockAbstraction get(AbstractState stateKey, Precision precisionKey, SignatureT blockKey) {
        return (BlockAbstraction)this.cache.getOrDefault(blockKey, Collections.emptyMap()).get(this.getHashKey(stateKey, precisionKey));
    }

    @Override
    public Collection<BlockAbstraction> get(SignatureT blockKey) {
        return this.cache.getOrDefault(blockKey, Collections.emptyMap()).values();
    }

    @Override
    public Collection<BlockAbstraction> get(Precision precision, SignatureT blockKey) {
        return this.cache.getOrDefault(blockKey, Collections.emptyMap()).entrySet().stream().filter(e -> ((HashKey)e.getKey()).precisionKey.equals(precision)).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    @Override
    public Collection<BlockAbstraction> values() {
        return this.cache.values().stream().map(Map::values).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Set<SignatureT> getAllMethods() {
        return Collections.unmodifiableSet(this.cache.keySet());
    }

    private HashKey getHashKey(AbstractState stateKey, Precision precisionKey) {
        return new HashKey(stateKey, precisionKey);
    }

    private static class HashKey {
        private final AbstractState stateKey;
        private final Precision precisionKey;

        public HashKey(AbstractState stateKey, Precision precisionKey) {
            this.stateKey = stateKey;
            this.precisionKey = precisionKey;
        }

        public AbstractState getStateKey() {
            return this.stateKey;
        }

        public Precision getPrecisionKey() {
            return this.precisionKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HashKey)) {
                return false;
            }
            HashKey other = (HashKey)o;
            return Objects.equals(this.stateKey, other.stateKey) && Objects.equals(this.precisionKey, other.precisionKey);
        }

        public int hashCode() {
            return Objects.hash(this.stateKey, this.precisionKey);
        }
    }
}

