/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.defaults;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DifferentialMap<K, V>
implements Map<K, V> {
    private DifferentialMapNode<K, V> node;
    protected final Predicate<DifferentialMap<?, ?>> shouldCollapse;

    public DifferentialMap() {
        this(Collections.emptyMap(), m -> false);
    }

    public DifferentialMap(Map<K, V> m) {
        this(m, m instanceof DifferentialMap ? ((DifferentialMap)m).shouldCollapse : map -> false);
    }

    public DifferentialMap(Map<K, V> m, Predicate<DifferentialMap<?, ?>> shouldCollapse) {
        this.node = m instanceof DifferentialMap ? ((DifferentialMap)m).node : new DifferentialMapRootNode(m);
        this.shouldCollapse = shouldCollapse;
    }

    public void collapse() {
        if (this.node instanceof DifferentialMapRootNode) {
            return;
        }
        this.node = new DifferentialMapRootNode(this.node.reconstructFullMap());
    }

    public int getDepth() {
        return this.node.depth;
    }

    @Override
    public int size() {
        return this.node.size();
    }

    @Override
    public boolean isEmpty() {
        return this.node.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.node.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.node.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.node.get(key);
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        this.node = new DifferentialMapInnerNode(this.node, new PutAction<K, V>(key, value));
        if (this.shouldCollapse.test(this)) {
            this.collapse();
        }
        return value;
    }

    @Override
    public V remove(Object key) {
        V answer = this.get(key);
        this.node = new DifferentialMapInnerNode(this.node, new RemoveAction(key));
        if (this.shouldCollapse.test(this)) {
            this.collapse();
        }
        return answer;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        m.forEach(this::put);
    }

    @Override
    public void clear() {
        this.node = new DifferentialMapRootNode(Collections.emptyMap());
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new KeySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return new ValueCollection();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public int hashCode() {
        return this.node.reconstructFullMap().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj || obj instanceof DifferentialMap && this.node == ((DifferentialMap)obj).node) {
            return true;
        }
        if (!(obj instanceof Map)) {
            return false;
        }
        return this.node.reconstructFullMap().equals(obj);
    }

    private class DifferentialEntry
    extends AbstractMap.SimpleEntry<K, V> {
        public DifferentialEntry(K key, V value) {
            super(key, value);
        }

        public DifferentialEntry(Map.Entry<? extends K, ? extends V> entry) {
            super(entry);
        }

        @Override
        public V setValue(V value) {
            return DifferentialMap.this.put(this.getKey(), value);
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return DifferentialMap.this.size();
        }

        @Override
        public void clear() {
            DifferentialMap.this.clear();
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object candidateValue = DifferentialMap.this.get(e.getKey());
            return candidateValue != null && new AbstractMap.SimpleEntry(e.getKey(), candidateValue).equals(e);
        }

        @Override
        public boolean remove(Object o) {
            return DifferentialMap.this.remove(o) != null;
        }

        private class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private final Set<K> passedKeys = new HashSet();
            private final DifferentialMapNode.RootAndActions rootAndActions;
            private final Iterator<Action<K, V>> actionIterator;
            private Iterator<Map.Entry<K, V>> rootIterator;
            private Map.Entry<K, V> current;
            private Map.Entry<K, V> next;

            private EntryIterator() {
                this.rootAndActions = DifferentialMap.this.node.getRootAndActions();
                this.actionIterator = this.rootAndActions.actionStack.iterator();
                this.rootIterator = null;
                this.current = null;
                this.next = null;
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry entry = this.current = this.next == null ? this.peekNext() : this.next;
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                DifferentialMap.this.remove(this.current.getKey());
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return (this.next == null ? (this.next = this.peekNext()) : this.next) != null;
            }

            private Map.Entry<K, V> peekNext() {
                while (this.actionIterator.hasNext()) {
                    Action action = this.actionIterator.next();
                    if (this.passedKeys.contains(action.key)) continue;
                    if (action instanceof RemoveAction) {
                        this.passedKeys.add(action.key);
                        continue;
                    }
                    this.passedKeys.add(action.key);
                    return new DifferentialEntry(action.key, ((PutAction)action).value);
                }
                if (this.rootIterator == null) {
                    this.rootIterator = this.rootAndActions.rootMap.entrySet().stream().filter(e -> !this.passedKeys.contains(e.getKey())).iterator();
                }
                return this.rootIterator.hasNext() ? new DifferentialEntry(this.rootIterator.next()) : null;
            }
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public int size() {
            return DifferentialMap.this.size();
        }

        @Override
        public void clear() {
            DifferentialMap.this.clear();
        }

        @Override
        @NotNull
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public boolean contains(Object o) {
            return DifferentialMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object key) {
            return DifferentialMap.this.remove(key) != null;
        }

        private class KeyIterator
        implements Iterator<K> {
            private final Iterator<Map.Entry<K, V>> entryIterator;

            private KeyIterator() {
                this.entryIterator = DifferentialMap.this.entrySet().iterator();
            }

            @Override
            public K next() {
                return this.entryIterator.next().getKey();
            }

            @Override
            public void remove() {
                this.entryIterator.remove();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }
        }
    }

    private class ValueCollection
    extends AbstractCollection<V> {
        private ValueCollection() {
        }

        @Override
        public int size() {
            return DifferentialMap.this.size();
        }

        @Override
        public void clear() {
            DifferentialMap.this.clear();
        }

        @Override
        @NotNull
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public boolean contains(Object o) {
            return DifferentialMap.this.containsValue(o);
        }

        private class ValueIterator
        implements Iterator<V> {
            private final Iterator<Map.Entry<K, V>> entryIterator;

            private ValueIterator() {
                this.entryIterator = DifferentialMap.this.entrySet().iterator();
            }

            @Override
            public V next() {
                return this.entryIterator.next().getValue();
            }

            @Override
            public void remove() {
                this.entryIterator.remove();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }
        }
    }

    private static class RemoveAction<K, V>
    extends Action<K, V> {
        public RemoveAction(K key) {
            super(key);
        }
    }

    private static class PutAction<K, V>
    extends Action<K, V> {
        public final V value;

        public PutAction(K key, V value) {
            super(key);
            this.value = value;
        }
    }

    private static abstract class Action<K, V> {
        public final K key;

        protected Action(K key) {
            this.key = key;
        }
    }

    private static class DifferentialMapInnerNode<K, V>
    extends DifferentialMapNode<K, V> {
        public final DifferentialMapNode<K, V> parent;
        public final Action<K, V> action;
        private transient int size;

        private DifferentialMapInnerNode(DifferentialMapNode<K, V> parent, Action<K, V> action) {
            super(parent.depth + 1);
            this.parent = parent;
            this.action = action;
            this.size = -1;
        }

        @Override
        public int size() {
            if (this.size >= 0) {
                return this.size;
            }
            DifferentialMapNode.RootAndActions rootAndActions = this.getRootAndActions();
            DifferentialMapNode.GenAndKill genAndKill = this.getGenAndKill(rootAndActions.actionStack);
            this.size = (int)((long)rootAndActions.rootMap.size() - genAndKill.kill.stream().filter(rootAndActions.rootMap::containsKey).count() + genAndKill.gen.keySet().stream().filter(k -> !rootAndActions.rootMap.containsKey(k)).count());
            return this.size;
        }

        @Override
        public boolean containsKey(Object key) {
            DifferentialMapNode.RootAndActions rootAndActions = this.getRootAndActions();
            DifferentialMapNode.GenAndKill genAndKill = this.getGenAndKill(rootAndActions.actionStack);
            return genAndKill.gen.containsKey(key) || !genAndKill.kill.contains(key) && rootAndActions.rootMap.containsKey(key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            DifferentialMapNode.RootAndActions rootAndActions = this.getRootAndActions();
            DifferentialMapNode.GenAndKill genAndKill = this.getGenAndKill(rootAndActions.actionStack);
            if (genAndKill.gen.containsValue(value)) return true;
            if (!rootAndActions.rootMap.entrySet().stream().filter(e -> !genAndKill.kill.contains(e.getKey())).map(Map.Entry::getValue).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public V get(Object key) {
            Object genValue;
            DifferentialMapNode.RootAndActions rootAndActions = this.getRootAndActions();
            DifferentialMapNode.GenAndKill genAndKill = this.getGenAndKill(rootAndActions.actionStack);
            return genAndKill.kill.contains(key) ? null : ((genValue = genAndKill.gen.get(key)) == null ? (V)rootAndActions.rootMap.get(key) : (V)genValue);
        }

        @Override
        public DifferentialMapNode.RootAndActions getRootAndActions() {
            Stack actionStack = new Stack();
            DifferentialMapNode n = this;
            while (n instanceof DifferentialMapInnerNode) {
                DifferentialMapInnerNode innerNode = n;
                actionStack.push(innerNode.action);
                n = innerNode.parent;
            }
            return new DifferentialMapNode.RootAndActions(((DifferentialMapRootNode)n).rootMap, actionStack);
        }

        @Override
        public Map<K, V> reconstructFullMap() {
            DifferentialMapNode.RootAndActions rootAndActions = this.getRootAndActions();
            DifferentialMapNode.GenAndKill genAndKill = this.getGenAndKill(rootAndActions.actionStack);
            HashMap answer = new HashMap(rootAndActions.rootMap);
            genAndKill.kill.forEach(answer::remove);
            answer.putAll(genAndKill.gen);
            return answer;
        }
    }

    private static class DifferentialMapRootNode<K, V>
    extends DifferentialMapNode<K, V> {
        public final Map<K, V> rootMap;

        private DifferentialMapRootNode(Map<K, V> rootMap) {
            super(0);
            this.rootMap = rootMap;
        }

        @Override
        public int size() {
            return this.rootMap.size();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.rootMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.rootMap.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.rootMap.get(key);
        }

        @Override
        public DifferentialMapNode.RootAndActions getRootAndActions() {
            return new DifferentialMapNode.RootAndActions(this.rootMap, new Stack());
        }

        @Override
        public Map<K, V> reconstructFullMap() {
            return this.rootMap;
        }
    }

    private static abstract class DifferentialMapNode<K, V> {
        public final int depth;

        private DifferentialMapNode(int depth) {
            this.depth = depth;
        }

        public abstract int size();

        public abstract boolean containsKey(Object var1);

        public abstract boolean containsValue(Object var1);

        public abstract V get(Object var1);

        public abstract Map<K, V> reconstructFullMap();

        public abstract RootAndActions getRootAndActions();

        public GenAndKill getGenAndKill(Stack<Action<K, V>> actionStack) {
            HashMap gen = new HashMap();
            HashSet kill = new HashSet();
            while (!actionStack.isEmpty()) {
                Action<K, V> action = actionStack.pop();
                if (action instanceof PutAction) {
                    kill.remove(action.key);
                    gen.put(action.key, ((PutAction)action).value);
                    continue;
                }
                kill.add(action.key);
                gen.remove(action.key);
            }
            return new GenAndKill(gen, kill);
        }

        protected class GenAndKill {
            public final Map<K, V> gen;
            public final Set<K> kill;

            public GenAndKill(Map<K, V> gen, Set<K> kill) {
                this.gen = gen;
                this.kill = kill;
            }
        }

        protected class RootAndActions {
            public final Map<K, V> rootMap;
            public final Stack<Action<K, V>> actionStack;

            public RootAndActions(Map<K, V> rootMap, Stack<Action<K, V>> actionStack) {
                this.rootMap = rootMap;
                this.actionStack = actionStack;
            }
        }
    }
}

