/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.cfa.nodes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import proguard.analysis.cpa.interfaces.CfaNode;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmUnknownCfaNode;
import proguard.analysis.cpa.jvm.util.InstructionClassifier;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;

public class JvmCfaNode
implements CfaNode<JvmCfaEdge, MethodSignature> {
    private final List<JvmCfaEdge> leavingEdges;
    private final List<JvmCfaEdge> enteringEdges;
    private final MethodSignature signature;
    private final int offset;
    private final Clazz clazz;

    public JvmCfaNode(MethodSignature signature, int offset, Clazz clazz) {
        this.leavingEdges = new ArrayList<JvmCfaEdge>(1);
        this.enteringEdges = new ArrayList<JvmCfaEdge>(1);
        this.signature = signature;
        this.offset = offset;
        this.clazz = clazz;
    }

    public JvmCfaNode(List<JvmCfaEdge> leavingEdges, List<JvmCfaEdge> enteringEdges, MethodSignature signature, int offset, Clazz clazz) {
        this.leavingEdges = leavingEdges;
        this.enteringEdges = enteringEdges;
        this.signature = signature;
        this.offset = offset;
        this.clazz = clazz;
    }

    @Override
    public List<JvmCfaEdge> getLeavingEdges() {
        return this.leavingEdges;
    }

    @Override
    public List<JvmCfaEdge> getEnteringEdges() {
        return this.enteringEdges;
    }

    @Override
    public boolean isEntryNode() {
        return this.offset == 0;
    }

    @Override
    public boolean isExitNode() {
        return this.isReturnExitNode() || this.isExceptionExitNode();
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.offset, this.getClass());
    }

    public Clazz getClazz() {
        return this.clazz;
    }

    public void addLeavingEdge(JvmCfaEdge edge) {
        this.leavingEdges.add(edge);
    }

    public void addEnteringEdge(JvmCfaEdge edge) {
        this.enteringEdges.add(edge);
    }

    public Optional<JvmCfaEdge> getEnteringInvokeEdge() {
        return this.enteringEdges.stream().filter(e -> e instanceof JvmInstructionCfaEdge && InstructionClassifier.isInvoke(((JvmInstructionCfaEdge)e).getInstruction().opcode)).findFirst();
    }

    public Optional<JvmCfaEdge> getLeavingInvokeEdge() {
        return this.leavingEdges.stream().filter(e -> e instanceof JvmInstructionCfaEdge && InstructionClassifier.isInvoke(((JvmInstructionCfaEdge)e).getInstruction().opcode)).findFirst();
    }

    public Collection<JvmCfaEdge> getEnteringIntraproceduralEdges() {
        return this.enteringEdges.stream().filter(e -> !(e instanceof JvmCallCfaEdge)).collect(Collectors.toList());
    }

    public Collection<JvmCfaEdge> getLeavingIntraproceduralEdges() {
        return this.leavingEdges.stream().filter(e -> !(e instanceof JvmCallCfaEdge)).collect(Collectors.toList());
    }

    public Collection<JvmCallCfaEdge> getKnownMethodCallEdges() {
        return this.leavingEdges.stream().filter(e -> e instanceof JvmCallCfaEdge && !(e.getTarget() instanceof JvmUnknownCfaNode)).map(JvmCallCfaEdge.class::cast).collect(Collectors.toList());
    }

    public String toString() {
        return "JvmCfaNode{" + this.signature.toString() + ":" + this.offset + '}';
    }
}

