/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.domain.taint.TaintAbstractState;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.operators.JvmDefaultExpandOperator;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.util.HeapUtil;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.instruction.Instruction;

public class JvmTaintExpandOperator
extends JvmDefaultExpandOperator<TaintAbstractState> {
    private final Map<String, TaintSource> fqnToSources;

    public JvmTaintExpandOperator(JvmCfa cfa, Map<String, TaintSource> fqnToSources, boolean expandHeap) {
        super(cfa, expandHeap);
        this.fqnToSources = fqnToSources;
    }

    public JvmTaintExpandOperator(JvmCfa cfa, Map<String, TaintSource> fqnToSources) {
        this(cfa, fqnToSources, true);
    }

    public JvmTaintAbstractState expand(AbstractState expandedInitialState, AbstractState reducedExitState, JvmCfaNode blockEntryNode, Call call) {
        JvmTaintAbstractState result = (JvmTaintAbstractState)super.expand(expandedInitialState, reducedExitState, blockEntryNode, call);
        TaintSource detectedSource = this.fqnToSources.get(call.getTarget().getFqn());
        if (detectedSource == null) {
            return result;
        }
        TaintAbstractState detectedTaint = new TaintAbstractState(detectedSource);
        detectedSource.taintsGlobals.forEach(g -> result.setStatic((String)g, detectedTaint));
        if (!(result.getHeap() instanceof JvmTaintTreeHeapFollowerAbstractState)) {
            return result;
        }
        JvmTaintTreeHeapFollowerAbstractState expandedHeap = (JvmTaintTreeHeapFollowerAbstractState)((JvmTaintAbstractState)expandedInitialState).getHeap();
        detectedSource.taintsGlobals.stream().map(JvmStaticFieldLocation::new).map(expandedHeap::getReferenceAbstractState).forEach(r -> result.setObjectTaint(r, detectedTaint));
        if (detectedSource.taintsArgs.isEmpty() && !detectedSource.taintsThis) {
            return result;
        }
        String descriptor = call.getTarget().descriptor.toString();
        int parameterSize = call.getJvmArgumentSize();
        detectedSource.taintsArgs.stream().map(a -> HeapUtil.getArgumentReference(expandedHeap, parameterSize, descriptor, call.isStatic(), a - 1)).forEach(r -> result.setObjectTaint(r, detectedTaint));
        if (detectedSource.taintsThis) {
            result.setObjectTaint(expandedHeap.getReferenceAbstractState(new JvmStackLocation(parameterSize - 1)), detectedTaint);
        }
        return result;
    }

    @Override
    protected List<TaintAbstractState> calculateReturnValues(AbstractState reducedExitState, Instruction returnInstruction, Call call) {
        int i;
        TaintSource detectedSource = this.fqnToSources.get(call.getTarget().getFqn());
        if (detectedSource == null || !detectedSource.taintsReturn) {
            return super.calculateReturnValues(reducedExitState, returnInstruction, call);
        }
        ArrayList<TaintAbstractState> returnValues = new ArrayList<TaintAbstractState>();
        TaintAbstractState answerContent = new TaintAbstractState(new TaintSource[0]);
        answerContent.add(detectedSource);
        int returnSize = returnInstruction.stackPopCount(null);
        for (i = 0; i < returnSize; ++i) {
            TaintAbstractState returnByte = (TaintAbstractState)((JvmAbstractState)reducedExitState).peek(i);
            answerContent = answerContent.join(returnByte);
        }
        for (i = returnSize; i > 1; --i) {
            returnValues.add(TaintAbstractState.bottom);
        }
        if (returnSize > 0) {
            returnValues.add(answerContent);
        }
        return returnValues;
    }

    public JvmTaintAbstractState createJvmAbstractState(JvmCfaNode programLocation, JvmFrameAbstractState<TaintAbstractState> frame, JvmHeapAbstractState<TaintAbstractState> heap, MapAbstractState<String, TaintAbstractState> staticFields) {
        return new JvmTaintAbstractState(programLocation, frame, heap, staticFields);
    }

    public Map<String, TaintSource> getFqnToSources() {
        return this.fqnToSources;
    }
}

