/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.defaults.BamCpaRun;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SimpleCpa;
import proguard.analysis.cpa.domain.taint.TaintAbstractState;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.interfaces.ProgramLocationDependent;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.BamLocationDependentJvmMemoryLocation;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationBamCpaRun;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintBamCpaRun;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.heap.HeapModel;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.state.HashMapAbstractStateFactory;
import proguard.analysis.cpa.state.MapAbstractStateFactory;
import proguard.classfile.MethodSignature;

public class JvmTaintMemoryLocationBamCpaRun
extends JvmMemoryLocationBamCpaRun<SimpleCpa, TaintAbstractState> {
    private final Collection<? extends JvmTaintSink> taintSinks;
    private List<BamLocationDependentJvmMemoryLocation<?>> endPoints;

    protected JvmTaintMemoryLocationBamCpaRun(JvmTaintBamCpaRun jvmTaintCpaRun, TaintAbstractState threshold, Collection<? extends JvmTaintSink> taintSinks, AbortOperator memoryLocationAbortOperator) {
        super(jvmTaintCpaRun, threshold, memoryLocationAbortOperator);
        this.taintSinks = taintSinks;
    }

    protected JvmTaintMemoryLocationBamCpaRun(JvmCfa cfa, Set<? extends TaintSource> taintSources, MethodSignature mainSignature, int maxCallStackDepth, HeapModel heapModel, TaintAbstractState threshold, Collection<? extends JvmTaintSink> taintSinks, AbortOperator abortOperator, AbortOperator memoryLocationAbortOperator, boolean reduceHeap, MapAbstractStateFactory heapNodeMapAbstractStateFactory, MapAbstractStateFactory staticFieldMapAbstractStateFactory) {
        this(new JvmTaintBamCpaRun(cfa, taintSources, mainSignature, maxCallStackDepth, heapModel, abortOperator, reduceHeap, heapNodeMapAbstractStateFactory, staticFieldMapAbstractStateFactory), threshold, taintSinks, memoryLocationAbortOperator);
    }

    @Override
    public List<JvmMemoryLocationAbstractState<?>> getInitialStates() {
        return this.getEndPoints().stream().map(JvmMemoryLocationAbstractState::new).collect(Collectors.toList());
    }

    @Override
    public Collection<BamLocationDependentJvmMemoryLocation<?>> getEndPoints() {
        ArrayList memoryLocations = new ArrayList();
        Map<String, Set<JvmMemoryLocation>> fqnToLocations = JvmTaintSink.convertSinksToMemoryLocations(this.taintSinks);
        if (this.endPoints != null) {
            return this.endPoints;
        }
        if (this.inputReachedSet == null) {
            this.execute();
            return this.endPoints;
        }
        ((BamCpa)((BamCpaRun)this.inputCpaRun).getCpa()).getCache().values().stream().map(BlockAbstraction::getReachedSet).forEach(reachedSet -> reachedSet.asCollection().stream().forEach(state -> ((JvmAbstractState)state.getStateByName("Jvm")).getProgramLocation().getLeavingEdges().stream().filter(e -> e instanceof CallEdge).map(e -> ((CallEdge)((Object)e)).getCall().getTarget().getFqn()).forEach(fqn -> fqnToLocations.getOrDefault(fqn, Collections.emptySet()).stream().filter(l -> !l.extractValueOrDefault((JvmAbstractState)state.getStateByName("Jvm"), TaintAbstractState.bottom).isEmpty() || !((JvmAbstractState)state.getStateByName("Jvm")).getHeap().getField(l, "", TaintAbstractState.bottom).isEmpty()).forEach(l -> memoryLocations.add(new BamLocationDependentJvmMemoryLocation((JvmMemoryLocation)l, (JvmCfaNode)((ProgramLocationDependent)((Object)state)).getProgramLocation(), (ProgramLocationDependentReachedSet)reachedSet))))));
        this.endPoints = memoryLocations;
        return this.endPoints;
    }

    public static class Builder {
        private JvmCfa cfa;
        private MethodSignature mainSignature;
        private Set<? extends TaintSource> taintSources = Collections.emptySet();
        private int maxCallStackDepth = -1;
        private HeapModel heapModel = HeapModel.FORGETFUL;
        private TaintAbstractState threshold = TaintAbstractState.bottom;
        private Collection<? extends JvmTaintSink> taintSinks = Collections.emptySet();
        private AbortOperator abortOperator = NeverAbortOperator.INSTANCE;
        private AbortOperator memoryLocationAbortOperator = NeverAbortOperator.INSTANCE;
        private boolean reduceHeap = true;
        private MapAbstractStateFactory heapNodeMapAbstractStateFactory = HashMapAbstractStateFactory.INSTANCE;
        private MapAbstractStateFactory staticFieldMapAbstractStateFactory = HashMapAbstractStateFactory.INSTANCE;

        public JvmTaintMemoryLocationBamCpaRun build() {
            if (this.cfa == null || this.mainSignature == null) {
                throw new IllegalStateException("CFA and the main signature must be set");
            }
            return new JvmTaintMemoryLocationBamCpaRun(this.cfa, this.taintSources, this.mainSignature, this.maxCallStackDepth, this.heapModel, this.threshold, this.taintSinks, this.abortOperator, this.memoryLocationAbortOperator, this.reduceHeap, this.heapNodeMapAbstractStateFactory, this.staticFieldMapAbstractStateFactory);
        }

        public Builder setCfa(JvmCfa cfa) {
            this.cfa = cfa;
            return this;
        }

        public Builder setTaintSources(Set<? extends TaintSource> taintSources) {
            this.taintSources = taintSources;
            return this;
        }

        public Builder setMainSignature(MethodSignature mainSignature) {
            this.mainSignature = mainSignature;
            return this;
        }

        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            this.maxCallStackDepth = maxCallStackDepth;
            return this;
        }

        public Builder setHeapModel(HeapModel heapModel) {
            this.heapModel = heapModel;
            return this;
        }

        public Builder setThreshold(TaintAbstractState threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder setTaintSinks(Collection<? extends JvmTaintSink> taintSinks) {
            this.taintSinks = taintSinks;
            return this;
        }

        public Builder setAbortOperator(AbortOperator abortOperator) {
            this.abortOperator = abortOperator;
            return this;
        }

        public Builder setMemoryLocationAbortOperator(AbortOperator memoryLocationAbortOperator) {
            this.memoryLocationAbortOperator = memoryLocationAbortOperator;
            return this;
        }

        public Builder setReduceHeap(boolean reduceHeap) {
            this.reduceHeap = reduceHeap;
            return this;
        }

        public Builder setHeapNodeMapAbstractStateFactory(MapAbstractStateFactory heapNodeMapAbstractStateFactory) {
            this.heapNodeMapAbstractStateFactory = heapNodeMapAbstractStateFactory;
            return this;
        }

        public Builder setStaticFieldMapAbstractStateFactory(MapAbstractStateFactory staticFieldMapAbstractStateFactory) {
            this.staticFieldMapAbstractStateFactory = staticFieldMapAbstractStateFactory;
            return this;
        }
    }
}

