/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import proguard.analysis.cpa.domain.taint.TaintAbstractState;
import proguard.analysis.cpa.domain.taint.TaintSource;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintAbstractState;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.transfer.JvmTransferRelation;
import proguard.analysis.cpa.jvm.util.HeapUtil;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.util.ClassUtil;

public class JvmTaintTransferRelation
extends JvmTransferRelation<TaintAbstractState> {
    private final Map<String, TaintSource> taintSources;

    public JvmTaintTransferRelation(Map<String, TaintSource> taintSources) {
        this.taintSources = taintSources;
    }

    @Override
    public void invokeMethod(JvmAbstractState<TaintAbstractState> state, Call call, List<TaintAbstractState> operands) {
        MethodSignature target = call.getTarget();
        TaintSource detectedSource = this.taintSources.get(target.getFqn());
        int pushCount = ClassUtil.internalTypeSize(target.descriptor.returnType == null ? "?" : target.descriptor.returnType);
        TaintAbstractState answerContent = operands.stream().reduce(this.getAbstractDefault(), TaintAbstractState::join);
        if (detectedSource != null && detectedSource.taintsReturn && !answerContent.contains(detectedSource)) {
            answerContent = answerContent.copy();
            answerContent.add(detectedSource);
        }
        for (int i = 1; i < pushCount; ++i) {
            state.push(this.getAbstractDefault());
        }
        if (pushCount > 0) {
            state.push(answerContent);
        }
        if (detectedSource == null) {
            return;
        }
        HashMap<String, TaintAbstractState> fqnToValue = new HashMap<String, TaintAbstractState>();
        TaintAbstractState newValue = new TaintAbstractState(detectedSource);
        detectedSource.taintsGlobals.forEach(fqn -> fqnToValue.merge((String)fqn, newValue, TaintAbstractState::join));
        fqnToValue.forEach(state::setStatic);
        if (!(state.getHeap() instanceof JvmTaintTreeHeapFollowerAbstractState)) {
            return;
        }
        JvmTaintAbstractState taintAbstractState = (JvmTaintAbstractState)state;
        JvmTaintTreeHeapFollowerAbstractState treeHeap = (JvmTaintTreeHeapFollowerAbstractState)taintAbstractState.getHeap();
        TaintAbstractState detectedTaint = new TaintAbstractState(detectedSource);
        detectedSource.taintsGlobals.stream().map(JvmStaticFieldLocation::new).map(treeHeap::getReferenceAbstractState).forEach(r -> taintAbstractState.setObjectTaint(r, detectedTaint));
        String descriptor = call.getTarget().descriptor.toString();
        int parameterSize = call.getJvmArgumentSize();
        detectedSource.taintsArgs.stream().map(a -> HeapUtil.getArgumentReference(treeHeap, parameterSize, descriptor, call.isStatic(), a - 1)).forEach(r -> taintAbstractState.setObjectTaint(r, detectedTaint));
        if (detectedSource.taintsThis) {
            taintAbstractState.setObjectTaint(treeHeap.getReferenceAbstractState(new JvmStackLocation(parameterSize - 1)), detectedTaint);
        }
    }

    @Override
    public TaintAbstractState getAbstractDefault() {
        return TaintAbstractState.bottom;
    }

    @Override
    protected JvmAbstractState<TaintAbstractState> getAbstractSuccessorForInstruction(JvmAbstractState<TaintAbstractState> abstractState, Instruction instruction, Clazz clazz, Precision precision) {
        instruction.accept(clazz, null, null, 0, new InstructionAbstractInterpreter(abstractState));
        return abstractState;
    }

    protected class InstructionAbstractInterpreter
    extends JvmTransferRelation.InstructionAbstractInterpreter {
        public InstructionAbstractInterpreter(JvmAbstractState<TaintAbstractState> abstractState) {
            super(JvmTaintTransferRelation.this, abstractState);
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 46: 
                case 48: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    TaintAbstractState index = (TaintAbstractState)this.abstractState.pop();
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, this.abstractState.pop()));
                    break;
                }
                case 47: 
                case 49: {
                    TaintAbstractState index = (TaintAbstractState)this.abstractState.pop();
                    this.abstractState.push(JvmTaintTransferRelation.this.getAbstractDefault());
                    this.abstractState.push(this.abstractState.getArrayElementOrDefault(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, this.abstractState.pop()));
                    break;
                }
                case 79: 
                case 81: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    TaintAbstractState value = (TaintAbstractState)this.abstractState.pop();
                    TaintAbstractState index = (TaintAbstractState)this.abstractState.pop();
                    this.abstractState.pop();
                    this.abstractState.setArrayElement(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, value);
                    break;
                }
                case 80: 
                case 82: {
                    TaintAbstractState value = (TaintAbstractState)this.abstractState.pop();
                    this.abstractState.pop();
                    TaintAbstractState index = (TaintAbstractState)this.abstractState.pop();
                    this.abstractState.pop();
                    this.abstractState.setArrayElement(new JvmStackLocation(simpleInstruction.stackPopCount(clazz) - 1), index, value);
                    break;
                }
                default: {
                    super.visitSimpleInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
                }
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.constantLookupVisitor.resetResult();
            switch (constantInstruction.opcode) {
                case -76: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    TaintAbstractState result = (TaintAbstractState)this.abstractState.getFieldOrDefault(new JvmStackLocation(constantInstruction.stackPopCount(clazz) - 1), this.constantLookupVisitor.result, this.abstractState.pop());
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.push(JvmTaintTransferRelation.this.getAbstractDefault());
                    }
                    this.abstractState.push(result);
                    break;
                }
                case -75: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    TaintAbstractState value = (TaintAbstractState)this.abstractState.pop();
                    if (this.constantLookupVisitor.resultSize > 1) {
                        this.abstractState.pop();
                    }
                    this.abstractState.pop();
                    this.abstractState.setField(new JvmStackLocation(constantInstruction.stackPopCount(clazz) - 1), this.constantLookupVisitor.result, value);
                    break;
                }
                default: {
                    super.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
                }
            }
        }
    }
}

