/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.domain.taint.TaintAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapPrincipalAbstractState;
import proguard.analysis.cpa.state.MapAbstractStateFactory;

public class JvmTaintTreeHeapFollowerAbstractState
extends JvmTreeHeapFollowerAbstractState<TaintAbstractState>
implements JvmTaintHeapAbstractState {
    public JvmTaintTreeHeapFollowerAbstractState(JvmReferenceAbstractState principal, TaintAbstractState defaultValue, MapAbstractState<Reference, HeapNode<TaintAbstractState>> referenceToNode, MapAbstractStateFactory mapAbstractStateFactory) {
        super(principal, defaultValue, referenceToNode, mapAbstractStateFactory);
    }

    @Override
    public <T> void taintObject(T object, TaintAbstractState value) {
        this.setField(object, "", value);
    }

    @Override
    public <T> TaintAbstractState getField(T object, String fqn, TaintAbstractState defaultValue) {
        return super.getField(object, fqn, defaultValue.join(super.getField(object, "", TaintAbstractState.bottom)));
    }

    @Override
    public <T> TaintAbstractState getArrayElementOrDefault(T array, TaintAbstractState index, TaintAbstractState defaultValue) {
        return super.getArrayElementOrDefault(array, index, defaultValue.join(super.getField(array, "", TaintAbstractState.bottom)));
    }

    @Override
    protected void assignField(SetAbstractState<Reference> object, String descriptor, TaintAbstractState value) {
        if (!descriptor.equals("")) {
            super.assignField(object, descriptor, value);
            return;
        }
        this.taintObjects(this.getReachableReferences(object, (JvmTreeHeapPrincipalAbstractState)this.principal.getHeap()), this.referenceToNode, value);
    }

    @Override
    public JvmTaintTreeHeapFollowerAbstractState join(JvmHeapAbstractState<TaintAbstractState> abstractState) {
        JvmTaintTreeHeapFollowerAbstractState other = (JvmTaintTreeHeapFollowerAbstractState)abstractState;
        MapAbstractState<Reference, HeapNode<TaintAbstractState>> newReferenceToNode = this.referenceToNode.join(other.referenceToNode);
        if (this.referenceToNode == newReferenceToNode) {
            return this;
        }
        if (other.referenceToNode == newReferenceToNode) {
            return other;
        }
        this.propagateObjectTaint(this.referenceToNode, newReferenceToNode, other.principal.getHeap());
        this.propagateObjectTaint(other.referenceToNode, newReferenceToNode, this.principal.getHeap());
        return new JvmTaintTreeHeapFollowerAbstractState(this.principal, (TaintAbstractState)this.defaultValue, newReferenceToNode, this.mapAbstractStateFactory);
    }

    @Override
    public JvmTaintTreeHeapFollowerAbstractState copy() {
        return new JvmTaintTreeHeapFollowerAbstractState(this.principal, (TaintAbstractState)this.defaultValue, this.referenceToNode.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HeapNode)e.getValue()).copy(), HeapNode::join, this.mapAbstractStateFactory::createMapAbstractState)), this.mapAbstractStateFactory);
    }

    private SetAbstractState<Reference> getReachableReferences(Set<Reference> references, JvmTreeHeapPrincipalAbstractState principal) {
        SetAbstractState<Reference> result = new SetAbstractState<Reference>(new Reference[0]);
        ArrayDeque worklist = new ArrayDeque();
        references.forEach(worklist::push);
        while (!worklist.isEmpty()) {
            Reference reference = (Reference)worklist.pop();
            result.add(reference);
            Optional.ofNullable(principal.getHeapNode(reference)).ifPresent(n -> n.values().stream().flatMap(Collection::stream).filter(r -> !result.contains(r)).forEach(r -> {
                result.add(r);
                worklist.push(r);
            }));
        }
        return result;
    }

    private void taintObjects(SetAbstractState<Reference> references, Map<Reference, HeapNode<TaintAbstractState>> referenceToNode, TaintAbstractState value) {
        references.stream().map(referenceToNode::get).filter(Objects::nonNull).forEach(n -> n.replaceAll((k, v) -> v.join(value)));
        references.stream().map(xva$0 -> new SetAbstractState<Reference>(xva$0)).forEach(r -> this.mergeField((SetAbstractState<Reference>)r, "", value));
    }

    private void propagateObjectTaint(MapAbstractState<Reference, HeapNode<TaintAbstractState>> leftReferenceToNode, MapAbstractState<Reference, HeapNode<TaintAbstractState>> joinedReferenceToNode, JvmHeapAbstractState<SetAbstractState<Reference>> rightPrincipalHeap) {
        leftReferenceToNode.entrySet().stream().filter(e -> ((HeapNode)e.getValue()).containsKey("")).collect(Collectors.groupingBy(e -> (TaintAbstractState)((HeapNode)e.getValue()).get(""))).forEach((taint, group) -> this.taintObjects(this.getReachableReferences(group.stream().flatMap(heapEntry -> ((HeapNode)joinedReferenceToNode.get(heapEntry.getKey())).entrySet().stream().filter(o -> !((HeapNode)heapEntry.getValue()).containsKey(o.getKey())).map(o -> {
            o.setValue(((TaintAbstractState)o.getValue()).join((TaintAbstractState)taint));
            return rightPrincipalHeap.getField(new SetAbstractState<Reference>((Reference)heapEntry.getKey()), (String)o.getKey(), SetAbstractState.bottom);
        })).flatMap(Collection::stream).collect(Collectors.toSet()), (JvmTreeHeapPrincipalAbstractState)rightPrincipalHeap), (Map<Reference, HeapNode<TaintAbstractState>>)joinedReferenceToNode, (TaintAbstractState)taint));
    }
}

