/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.state.MapAbstractStateFactory;

public abstract class JvmTreeHeapAbstractState<StateT extends LatticeAbstractState<StateT>>
implements JvmHeapAbstractState<StateT> {
    protected final MapAbstractState<Reference, HeapNode<StateT>> referenceToNode;
    protected final MapAbstractStateFactory mapAbstractStateFactory;
    protected final StateT defaultValue;

    protected JvmTreeHeapAbstractState(MapAbstractState<Reference, HeapNode<StateT>> referenceToNode, MapAbstractStateFactory mapAbstractStateFactory, StateT defaultValue) {
        this.referenceToNode = referenceToNode;
        this.mapAbstractStateFactory = mapAbstractStateFactory;
        this.defaultValue = defaultValue;
    }

    @Override
    protected StateT getField(SetAbstractState<Reference> object, String descriptor, StateT defaultValue) {
        return (StateT)object.stream().reduce(this.defaultValue, (result, reference) -> result.join(this.referenceToNode.containsKey(reference) ? ((HeapNode)this.referenceToNode.get(reference)).getOrDefault(descriptor, defaultValue) : defaultValue), LatticeAbstractState::join);
    }

    protected void assignField(SetAbstractState<Reference> object, String descriptor, StateT value) {
        if (object.size() <= 1) {
            this.setField(object, descriptor, value);
        } else {
            this.mergeField(object, descriptor, value);
        }
    }

    protected void mergeField(SetAbstractState<Reference> object, String descriptor, StateT value) {
        object.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).merge(descriptor, value));
    }

    @Override
    protected void setField(SetAbstractState<Reference> object, String descriptor, StateT value) {
        object.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).put(descriptor, value));
    }

    @Override
    protected StateT getArrayElementOrDefault(SetAbstractState<Reference> array, StateT index, StateT defaultValue) {
        return (StateT)array.stream().reduce(this.defaultValue, (result, reference) -> result.join(this.referenceToNode.containsKey(reference) ? ((HeapNode)this.referenceToNode.get(reference)).getOrDefault("[]", defaultValue) : defaultValue), LatticeAbstractState::join);
    }

    @Override
    protected void setArrayElement(SetAbstractState<Reference> array, StateT index, StateT value) {
        array.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).merge("[]", value));
    }

    public HeapNode<StateT> getHeapNode(Reference reference) {
        return (HeapNode)this.referenceToNode.get(reference);
    }

    @Override
    public void expand(JvmHeapAbstractState<StateT> otherState) {
        if (!(otherState instanceof JvmTreeHeapAbstractState)) {
            throw new IllegalArgumentException("The other state should be a JvmTreeHeapAbstractState");
        }
        ((JvmTreeHeapAbstractState)otherState).referenceToNode.forEach(this.referenceToNode::putIfAbsent);
    }

    @Override
    public boolean isLessOrEqual(JvmHeapAbstractState<StateT> abstractState) {
        return abstractState instanceof JvmTreeHeapAbstractState && this.referenceToNode.isLessOrEqual(((JvmTreeHeapAbstractState)abstractState).referenceToNode);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JvmTreeHeapAbstractState)) {
            return false;
        }
        return this.referenceToNode.equals(((JvmTreeHeapAbstractState)obj).referenceToNode);
    }

    @Override
    public int hashCode() {
        return this.referenceToNode.hashCode();
    }
}

