/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import proguard.analysis.cpa.defaults.HashMapAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.HeapNode;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.cpa.state.MapAbstractStateFactory;

public class JvmTreeHeapPrincipalAbstractState
extends JvmTreeHeapAbstractState<SetAbstractState<Reference>> {
    public JvmTreeHeapPrincipalAbstractState(MapAbstractStateFactory mapAbstractStateFactory) {
        this(mapAbstractStateFactory.createMapAbstractState(), mapAbstractStateFactory);
    }

    private JvmTreeHeapPrincipalAbstractState(MapAbstractState<Reference, HeapNode<SetAbstractState<Reference>>> referenceToNode, MapAbstractStateFactory mapAbstractStateFactory) {
        super(referenceToNode, mapAbstractStateFactory, new SetAbstractState<Reference>(new Reference[0]));
    }

    @Override
    public <T> SetAbstractState<Reference> getField(T object, String fqn, SetAbstractState<Reference> defaultValue) {
        if (!(object instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), object.getClass().getName()));
        }
        return ((SetAbstractState)object).stream().reduce(new SetAbstractState<Reference>(new Reference[0]), (result, reference) -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).computeIfAbsent(fqn, d -> new SetAbstractState<Reference>(reference)), SetAbstractState::join);
    }

    @Override
    public <T> void setField(T object, String fqn, SetAbstractState<Reference> value) {
        if (!(object instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), object.getClass().getName()));
        }
        SetAbstractState objectReference = (SetAbstractState)object;
        if (objectReference.size() <= 1) {
            objectReference.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).put(fqn, value));
        } else {
            objectReference.forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).merge(fqn, value));
        }
    }

    @Override
    public <T> SetAbstractState<Reference> getArrayElementOrDefault(T array, SetAbstractState<Reference> index, SetAbstractState<Reference> defaultValue) {
        if (!(array instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), array.getClass().getName()));
        }
        return ((SetAbstractState)array).stream().reduce(new SetAbstractState<Reference>(new Reference[0]), (result, reference) -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).computeIfAbsent("[]", d -> new SetAbstractState<Reference>(reference)), SetAbstractState::join);
    }

    @Override
    public <T> void setArrayElement(T array, SetAbstractState<Reference> index, SetAbstractState<Reference> value) {
        if (!(array instanceof SetAbstractState)) {
            throw new IllegalStateException(String.format("%s does not support %s as reference type", this.getClass().getName(), array.getClass().getName()));
        }
        ((SetAbstractState)array).forEach(reference -> this.referenceToNode.computeIfAbsent(reference, r -> new HeapNode(this.mapAbstractStateFactory.createMapAbstractState())).merge("[]", value));
    }

    @Override
    public SetAbstractState<Reference> newObject(String className, JvmCfaNode creationCite) {
        return new SetAbstractState<Reference>(new Reference(creationCite, new JvmStackLocation(0)));
    }

    @Override
    public SetAbstractState<Reference> newArray(String type, List<SetAbstractState<Reference>> dimensions, JvmCfaNode creationCite) {
        return new SetAbstractState<Reference>(new Reference(creationCite, new JvmStackLocation(0)));
    }

    public Set<Reference> getStaticCreationReferences() {
        return this.referenceToNode.keySet().stream().filter(ref -> ref.creationSite instanceof JvmStaticFieldLocation).collect(Collectors.toSet());
    }

    @Override
    public void reduce(Optional<Set<Reference>> roots) {
        if (!roots.isPresent()) {
            return;
        }
        ArrayDeque worklist = new ArrayDeque(roots.get());
        HashSet discoveredReferences = new HashSet(roots.get());
        while (!worklist.isEmpty()) {
            Reference reference = (Reference)worklist.pop();
            HeapNode node = (HeapNode)this.referenceToNode.get(reference);
            if (node == null) continue;
            node.values().forEach(n -> n.stream().filter(discoveredReferences::add).forEach(worklist::add));
        }
        this.referenceToNode.entrySet().removeIf(e -> !discoveredReferences.contains(e.getKey()));
    }

    @Override
    public JvmTreeHeapPrincipalAbstractState join(JvmHeapAbstractState<SetAbstractState<Reference>> abstractState) {
        JvmTreeHeapPrincipalAbstractState other = (JvmTreeHeapPrincipalAbstractState)abstractState;
        MapAbstractState<Reference, HeapNode<SetAbstractState<Reference>>> newReferenceToNode = this.referenceToNode.join(other.referenceToNode);
        if (this.referenceToNode.equals(newReferenceToNode)) {
            return this;
        }
        if (other.referenceToNode.equals(newReferenceToNode)) {
            return other;
        }
        return new JvmTreeHeapPrincipalAbstractState(newReferenceToNode, this.mapAbstractStateFactory);
    }

    @Override
    public JvmTreeHeapPrincipalAbstractState copy() {
        return new JvmTreeHeapPrincipalAbstractState(this.referenceToNode.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((HeapNode)e.getValue()).copy(), HeapNode::join, HashMapAbstractState::new)), this.mapAbstractStateFactory);
    }
}

