/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import proguard.analysis.CallResolver;
import proguard.analysis.CallVisitor;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmUnknownCfaNode;
import proguard.analysis.cpa.jvm.cfa.visitors.JvmIntraproceduralCfaFillerAllInstructionVisitor;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.CallGraph;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.analysis.datastructure.callgraph.SymbolicCall;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.visitor.AllMethodVisitor;

public class CfaUtil {
    public static JvmCfa createIntraproceduralCfaFromClassPool(ClassPool programClassPool) {
        return CfaUtil.createIntraproceduralCfaFromClassPool(programClassPool, () -> true);
    }

    public static JvmCfa createIntraproceduralCfaFromClassPool(ClassPool programClassPool, final Supplier<Boolean> shouldAnalyzeNextCodeAttribute) {
        JvmCfa cfa = new JvmCfa();
        programClassPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new JvmIntraproceduralCfaFillerAllInstructionVisitor(cfa){

            @Override
            public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
                if (!((Boolean)shouldAnalyzeNextCodeAttribute.get()).booleanValue()) {
                    return;
                }
                super.visitCodeAttribute(clazz, method, codeAttribute);
            }
        })));
        return cfa;
    }

    public static void addInterproceduralEdgesToCfa(JvmCfa cfa, CallGraph callGraph) {
        callGraph.outgoing.values().stream().flatMap(Collection::stream).filter(call -> !call.hasIncompleteTarget() && cfa.getFunctionNode((MethodSignature)call.caller.signature, call.caller.offset) != null).forEach(call -> {
            if (call instanceof SymbolicCall || ((ConcreteCall)call).getTargetClass() instanceof LibraryClass || ((ConcreteCall)call).getTargetMethod() instanceof ProgramMethod && Arrays.stream(((ProgramMethod)((ConcreteCall)call).getTargetMethod()).attributes).noneMatch(a -> a instanceof CodeAttribute) || cfa.getFunctionEntryNode(call.getTarget()) == null) {
                cfa.addUnknownTargetInterproceduralEdge((Call)call);
            } else {
                cfa.addInterproceduralEdge((Call)call);
            }
        });
    }

    public static JvmCfa createInterproceduralCfaFromClassPoolAndCallGraph(ClassPool programClassPool, CallGraph callGraph) {
        JvmCfa cfa = CfaUtil.createIntraproceduralCfaFromClassPool(programClassPool);
        CfaUtil.addInterproceduralEdgesToCfa(cfa, callGraph);
        return cfa;
    }

    public static JvmCfa createInterproceduralCfaFromClassPool(ClassPool programClassPool) {
        CallGraph callGraph = new CallGraph();
        CallResolver resolver = new CallResolver.Builder(programClassPool, new ClassPool(), callGraph, new CallVisitor[0]).setEvaluateAllCode(true).build();
        programClassPool.classesAccept(resolver);
        MethodSignature.clearCache();
        JvmCfa cfa = CfaUtil.createIntraproceduralCfaFromClassPool(programClassPool);
        CfaUtil.addInterproceduralEdgesToCfa(cfa, callGraph);
        return cfa;
    }

    public static String toDot(JvmCfa cfa) {
        final StringBuffer sb = new StringBuffer();
        sb.append("digraph G { ");
        sb.append("node").append(Integer.toHexString(JvmUnknownCfaNode.INSTANCE.hashCode())).append(" [label=\"unknown\",style=dotted]");
        cfa.getAllNodes().forEach(node -> {
            String nodeAId = "node" + Integer.toHexString(node.hashCode());
            sb.append(nodeAId).append(" [label=\"");
            if (node.isExitNode()) {
                sb.append("exit ").append(node.getSignature());
            } else if (node.isEntryNode()) {
                sb.append("entry ").append(node.getSignature());
            } else {
                sb.append(node.getOffset());
            }
            sb.append("\"");
            if (node.isExitNode() || node.isEntryNode()) {
                sb.append(",shape=rect");
            }
            sb.append("]\n");
            node.getLeavingEdges().forEach(edge -> {
                JvmCfaNode target = edge.getTarget();
                String nodeBId = "node" + Integer.toHexString(target.hashCode());
                sb.append(nodeAId).append(" -> ").append(nodeBId).append("[label=\"");
                if (edge instanceof JvmInstructionCfaEdge) {
                    Instruction instruction = ((JvmInstructionCfaEdge)edge).getInstruction();
                    sb.append(instruction);
                    if (instruction instanceof ConstantInstruction) {
                        edge.getSource().getClazz().constantPoolEntryAccept(((ConstantInstruction)instruction).constantIndex, new ConstantVisitor(){

                            @Override
                            public void visitAnyConstant(Clazz clazz, Constant constant) {
                                sb.append(constant);
                            }

                            @Override
                            public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
                                sb.append(" ").append(refConstant.getClassName(clazz)).append(".").append(refConstant.getName(clazz)).append(refConstant.getType(clazz));
                            }
                        });
                    }
                } else if (edge instanceof JvmCallCfaEdge) {
                    sb.append(((JvmCallCfaEdge)edge).getCall());
                } else {
                    sb.append(edge);
                }
                sb.append("\"");
                if (edge instanceof JvmCallCfaEdge) {
                    if (edge.getTarget() == JvmUnknownCfaNode.INSTANCE) {
                        sb.append(",style=dotted");
                    } else {
                        sb.append(",style=dashed");
                    }
                }
                sb.append("]\n");
            });
        });
        sb.append("}");
        return sb.toString();
    }
}

