/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.IdentityHashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;

public class ClassSignature
extends Signature {
    private static final transient Map<Clazz, ClassSignature> signatureCache = new IdentityHashMap<Clazz, ClassSignature>();

    public ClassSignature(String className) {
        super(className);
    }

    public ClassSignature(Clazz clazz) {
        this(clazz.getName());
    }

    @Override
    public boolean isIncomplete() {
        return this.className == null;
    }

    @Override
    protected String calculateFqn() {
        return this.className;
    }

    @Override
    protected String calculatePrettyFqn() {
        return ClassUtil.externalClassName(this.className);
    }

    public static void clearCache() {
        signatureCache.clear();
    }

    public static ClassSignature computeIfAbsent(Clazz clazz) {
        return signatureCache.computeIfAbsent(clazz, c -> new ClassSignature(c.getName()));
    }
}

