/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import proguard.classfile.util.ClassUtil;

public class MethodDescriptor {
    public final String returnType;
    public final List<String> argumentTypes;

    public MethodDescriptor(String descriptor) {
        if (descriptor == null) {
            this.returnType = null;
            this.argumentTypes = null;
        } else {
            this.returnType = ClassUtil.internalMethodReturnType(descriptor);
            this.argumentTypes = new ArrayList<String>();
            for (int i = 0; i < ClassUtil.internalMethodParameterCount(descriptor); ++i) {
                this.argumentTypes.add(ClassUtil.internalMethodParameterType(descriptor, i));
            }
        }
    }

    public MethodDescriptor(String returnType, List<String> argumentTypes) {
        this.returnType = returnType;
        this.argumentTypes = argumentTypes;
    }

    public boolean isIncomplete() {
        return this.returnType == null || this.argumentTypes == null;
    }

    public static boolean matchesIgnoreNull(MethodDescriptor descriptor, MethodDescriptor wildcard) {
        return wildcard == null || Optional.ofNullable(descriptor).map(d -> !(wildcard.returnType != null && !Objects.equals(d.returnType, wildcard.returnType) || wildcard.argumentTypes != null && !Objects.equals(d.argumentTypes, wildcard.argumentTypes))).orElse(false) != false;
    }

    public static boolean matchesIgnoreNullAndDollar(MethodDescriptor descriptor, MethodDescriptor wildcard) {
        return wildcard == null || Optional.ofNullable(descriptor).map(d -> !(wildcard.returnType != null && !Objects.equals(Optional.ofNullable(d.returnType).map(s -> s.replace('$', '/')).orElse(null), wildcard.returnType.replace('$', '/')) || wildcard.argumentTypes != null && !Objects.equals(Optional.ofNullable(d.argumentTypes).map(l -> l.stream().map(t -> t.replace('$', '/')).collect(Collectors.toList())).orElse(null), wildcard.argumentTypes.stream().map(t -> t.replace('$', '/')).collect(Collectors.toList())))).orElse(false) != false;
    }

    public String getPrettyReturnType() {
        if (this.returnType != null) {
            return ClassUtil.externalShortClassName(ClassUtil.externalType(this.returnType));
        }
        return "?";
    }

    public String getPrettyArgumentTypes() {
        if (this.argumentTypes != null) {
            return this.argumentTypes.stream().map(ClassUtil::externalType).map(ClassUtil::externalShortClassName).collect(Collectors.joining(","));
        }
        return "?";
    }

    public String toString() {
        if (this.returnType != null) {
            if (this.argumentTypes != null) {
                return ClassUtil.internalMethodDescriptorFromInternalTypes(this.returnType, this.argumentTypes);
            }
            return "(?)" + this.returnType;
        }
        if (this.argumentTypes != null) {
            return ClassUtil.internalMethodDescriptorFromInternalTypes("?", this.argumentTypes);
        }
        return "(?)?";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodDescriptor that = (MethodDescriptor)o;
        return Objects.equals(this.returnType, that.returnType) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.returnType, this.argumentTypes);
    }
}

