/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;

public class MethodSignature
extends Signature {
    public static final MethodSignature UNKNOWN = new MethodSignature(null, null, (MethodDescriptor)null);
    private static final transient Map<Method, MethodSignature> signatureCache = new IdentityHashMap<Method, MethodSignature>();
    public final String method;
    public final MethodDescriptor descriptor;

    public MethodSignature(String clazz, String method, MethodDescriptor descriptor) {
        super(clazz);
        this.method = method;
        this.descriptor = descriptor;
    }

    public MethodSignature(String clazz, String method, String descriptor) {
        this(clazz, method, new MethodDescriptor(descriptor));
    }

    public MethodSignature(Clazz clazz, Method method) {
        this(clazz.getName(), method.getName(clazz), method.getDescriptor(clazz));
    }

    public static MethodSignature computeIfAbsent(Clazz clazz, Method method) {
        return signatureCache.computeIfAbsent(method, m -> new MethodSignature(clazz, method));
    }

    @Override
    public boolean isIncomplete() {
        return this.className == null || this.method == null || this.descriptor == null || this.descriptor.isIncomplete();
    }

    @Override
    protected String calculateFqn() {
        return String.format("L%s;%s%s", this.className == null ? "?" : this.className, this.method == null ? "?" : this.method, this.descriptor);
    }

    @Override
    protected String calculatePrettyFqn() {
        String result;
        String shortClassName;
        String params = this.descriptor == null ? "?" : this.descriptor.getPrettyArgumentTypes();
        String string = shortClassName = this.className == null ? "?" : ClassUtil.externalShortClassName(ClassUtil.externalClassName(this.className));
        if ("<init>".equals(this.method)) {
            result = String.format("%s(%s)", shortClassName, params);
        } else if ("<clinit>".equals(this.method)) {
            result = String.format("static initializer (%s)", shortClassName);
        } else {
            String returnType = this.descriptor == null ? "?" : this.descriptor.getPrettyReturnType();
            String methodName = this.method == null ? "?" : this.method;
            result = String.format("%s %s.%s(%s)", returnType, shortClassName, methodName, params);
        }
        return result;
    }

    public static void clearCache() {
        signatureCache.clear();
    }

    public static boolean matchesIgnoreNull(MethodSignature signature, MethodSignature wildcard) {
        return wildcard == null || Optional.ofNullable(signature).map(s -> !(wildcard.className != null && !Objects.equals(s.className, wildcard.className) || wildcard.method != null && !Objects.equals(s.method, wildcard.method) || wildcard.descriptor != null && !MethodDescriptor.matchesIgnoreNull(s.descriptor, wildcard.descriptor))).orElse(false) != false;
    }

    public static boolean matchesIgnoreNullAndDollar(MethodSignature signature, MethodSignature wildcard) {
        return wildcard == null || Optional.ofNullable(signature).map(s -> !(wildcard.className != null && !Objects.equals(Optional.ofNullable(s.className).map(c -> c.replace('$', '/')).orElse(null), wildcard.className.replace('$', '/')) || wildcard.method != null && !Objects.equals(Optional.ofNullable(s.method).map(m -> m.replace('$', '/')).orElse(null), wildcard.method.replace('$', '/')) || wildcard.descriptor != null && !MethodDescriptor.matchesIgnoreNullAndDollar(s.descriptor, wildcard.descriptor))).orElse(false) != false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.descriptor, that.descriptor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.method, this.descriptor);
    }
}

