/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io;

import java.io.DataInput;
import java.util.ArrayList;
import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMember;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.kotlin.KotlinMetadataInitializer;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.io.RuntimeDataInput;

public class LibraryClassReader
implements ClassVisitor,
MemberVisitor,
ConstantVisitor {
    private static final LibraryField[] EMPTY_LIBRARY_FIELDS = new LibraryField[0];
    private static final LibraryMethod[] EMPTY_LIBRARY_METHODS = new LibraryMethod[0];
    private final RuntimeDataInput dataInput;
    private final boolean skipNonPublicClasses;
    private final boolean skipNonPublicClassMembers;
    private final KotlinMetadataElementValueConsumer kmElementValueConsumer;
    private Constant[] constantPool;

    public LibraryClassReader(DataInput dataInput, boolean skipNonPublicClasses, boolean skipNonPublicClassMembers) {
        this(dataInput, skipNonPublicClasses, skipNonPublicClassMembers, null);
    }

    public LibraryClassReader(DataInput dataInput, boolean skipNonPublicClasses, boolean skipNonPublicClassMembers, KotlinMetadataElementValueConsumer kmElementValueConsumer) {
        this.dataInput = new RuntimeDataInput(dataInput);
        this.skipNonPublicClasses = skipNonPublicClasses;
        this.skipNonPublicClassMembers = skipNonPublicClassMembers;
        this.kmElementValueConsumer = kmElementValueConsumer;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        int u4magic = this.dataInput.readInt();
        ClassUtil.checkMagicNumber(u4magic);
        int u2minorVersion = this.dataInput.readUnsignedShort();
        int u2majorVersion = this.dataInput.readUnsignedShort();
        int u4version = ClassUtil.internalClassVersion(u2majorVersion, u2minorVersion);
        ClassUtil.checkVersionNumbers(u4version);
        int u2constantPoolCount = this.dataInput.readUnsignedShort();
        this.constantPool = new Constant[u2constantPoolCount];
        for (int index = 1; index < u2constantPoolCount; ++index) {
            Constant constant = this.createConstant();
            constant.accept(libraryClass, this);
            int tag = constant.getTag();
            if (tag == 7 || tag == 1 || tag == 3) {
                this.constantPool[index] = constant;
            }
            if (tag != 5 && tag != 6) continue;
            ++index;
        }
        libraryClass.u2accessFlags = this.dataInput.readUnsignedShort();
        if (this.skipNonPublicClasses && AccessUtil.accessLevel(libraryClass.getAccessFlags()) < 3) {
            return;
        }
        int u2thisClass = this.dataInput.readUnsignedShort();
        int u2superClass = this.dataInput.readUnsignedShort();
        libraryClass.thisClassName = this.getClassName(u2thisClass);
        libraryClass.superClassName = u2superClass == 0 ? null : this.getClassName(u2superClass);
        int u2interfacesCount = this.dataInput.readUnsignedShort();
        libraryClass.interfaceNames = new String[u2interfacesCount];
        for (int index = 0; index < u2interfacesCount; ++index) {
            int u2interface = this.dataInput.readUnsignedShort();
            libraryClass.interfaceNames[index] = this.getClassName(u2interface);
        }
        int u2fieldsCount = this.dataInput.readUnsignedShort();
        LibraryField[] reusableFields = new LibraryField[u2fieldsCount];
        int visibleFieldsCount = 0;
        for (int index = 0; index < u2fieldsCount; ++index) {
            LibraryField field = new LibraryField();
            this.visitLibraryMember(libraryClass, field);
            if (this.kmElementValueConsumer == null && AccessUtil.accessLevel(field.getAccessFlags()) < (this.skipNonPublicClassMembers ? 2 : 1)) continue;
            reusableFields[visibleFieldsCount++] = field;
        }
        if (visibleFieldsCount == 0) {
            libraryClass.fields = EMPTY_LIBRARY_FIELDS;
        } else {
            libraryClass.fields = new LibraryField[visibleFieldsCount];
            System.arraycopy(reusableFields, 0, libraryClass.fields, 0, visibleFieldsCount);
        }
        int u2methodsCount = this.dataInput.readUnsignedShort();
        LibraryMethod[] reusableMethods = new LibraryMethod[u2methodsCount];
        int visibleMethodsCount = 0;
        for (int index = 0; index < u2methodsCount; ++index) {
            LibraryMethod method = new LibraryMethod();
            this.visitLibraryMember(libraryClass, method);
            if (this.kmElementValueConsumer == null && AccessUtil.accessLevel(method.getAccessFlags()) < (this.skipNonPublicClassMembers ? 2 : 1)) continue;
            reusableMethods[visibleMethodsCount++] = method;
        }
        if (visibleMethodsCount == 0) {
            libraryClass.methods = EMPTY_LIBRARY_METHODS;
        } else {
            libraryClass.methods = new LibraryMethod[visibleMethodsCount];
            System.arraycopy(reusableMethods, 0, libraryClass.methods, 0, visibleMethodsCount);
        }
        this.skipClassAttributes(libraryClass);
    }

    @Override
    public void visitProgramMember(ProgramClass libraryClass, ProgramMember libraryMember) {
    }

    @Override
    public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        libraryMember.u2accessFlags = this.dataInput.readUnsignedShort();
        libraryMember.name = this.getString(this.dataInput.readUnsignedShort());
        libraryMember.descriptor = this.getString(this.dataInput.readUnsignedShort());
        this.skipMemberAttributes();
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        integerConstant.u4value = this.dataInput.readInt();
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.dataInput.skipBytes(8);
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.dataInput.skipBytes(8);
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char u2primitiveType = this.dataInput.readChar();
        int u4length = this.dataInput.readInt();
        this.dataInput.skipBytes(this.primitiveSize(u2primitiveType) * u4length);
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.dataInput.skipBytes(2);
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        int u2length = this.dataInput.readUnsignedShort();
        byte[] bytes = new byte[u2length];
        this.dataInput.readFully(bytes);
        utf8Constant.setBytes(bytes);
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        this.dataInput.skipBytes(3);
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.u2nameIndex = this.dataInput.readUnsignedShort();
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.dataInput.skipBytes(2);
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.dataInput.skipBytes(4);
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        this.dataInput.skipBytes(2);
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        this.dataInput.skipBytes(2);
    }

    private String getClassName(int constantIndex) {
        ClassConstant classEntry = (ClassConstant)this.constantPool[constantIndex];
        return this.getString(classEntry.u2nameIndex);
    }

    private String getString(int constantIndex) {
        return ((Utf8Constant)this.constantPool[constantIndex]).getString();
    }

    private int getInteger(int constantIndex) {
        return ((IntegerConstant)this.constantPool[constantIndex]).getValue();
    }

    private Constant createConstant() {
        int u1tag = this.dataInput.readUnsignedByte();
        switch (u1tag) {
            case 3: {
                return new IntegerConstant();
            }
            case 4: {
                return new FloatConstant();
            }
            case 5: {
                return new LongConstant();
            }
            case 6: {
                return new DoubleConstant();
            }
            case 8: {
                return new StringConstant();
            }
            case 1: {
                return new Utf8Constant();
            }
            case 17: {
                return new DynamicConstant();
            }
            case 18: {
                return new InvokeDynamicConstant();
            }
            case 15: {
                return new MethodHandleConstant();
            }
            case 9: {
                return new FieldrefConstant();
            }
            case 10: {
                return new MethodrefConstant();
            }
            case 11: {
                return new InterfaceMethodrefConstant();
            }
            case 7: {
                return new ClassConstant();
            }
            case 16: {
                return new MethodTypeConstant();
            }
            case 12: {
                return new NameAndTypeConstant();
            }
            case 19: {
                return new ModuleConstant();
            }
            case 20: {
                return new PackageConstant();
            }
        }
        throw new RuntimeException("Unknown constant type [" + u1tag + "] in constant pool");
    }

    private void skipClassAttributes(LibraryClass libraryClass) {
        int u2attributesCount = this.dataInput.readUnsignedShort();
        for (int index = 0; index < u2attributesCount; ++index) {
            int u2attributeNameIndex = this.dataInput.readUnsignedShort();
            String attributeName = this.getString(u2attributeNameIndex);
            if (this.kmElementValueConsumer != null && "RuntimeVisibleAnnotations".equals(attributeName)) {
                this.skipAttributeOrReadKotlinMetadataAnnotation(libraryClass);
                continue;
            }
            this.skipAttribute();
        }
    }

    private void skipMemberAttributes() {
        int u2attributesCount = this.dataInput.readUnsignedShort();
        for (int index = 0; index < u2attributesCount; ++index) {
            this.dataInput.skipBytes(2);
            this.skipAttribute();
        }
    }

    private void skipAttribute() {
        int u4attributeLength = this.dataInput.readInt();
        this.dataInput.skipBytes(u4attributeLength);
    }

    private void skipAttributeOrReadKotlinMetadataAnnotation(LibraryClass libraryClass) {
        this.dataInput.skipBytes(4);
        int u2annotationsCount = this.dataInput.readUnsignedShort();
        for (int index = 0; index < u2annotationsCount; ++index) {
            this.skipAnnotationOrReadKotlinMetadataAnnotation(libraryClass);
        }
    }

    private int primitiveSize(char primitiveType) {
        switch (primitiveType) {
            case 'B': 
            case 'Z': {
                return 1;
            }
            case 'C': 
            case 'S': {
                return 2;
            }
            case 'F': 
            case 'I': {
                return 4;
            }
            case 'D': 
            case 'J': {
                return 8;
            }
        }
        return 0;
    }

    private void skipAnnotationOrReadKotlinMetadataAnnotation(Clazz clazz) {
        Annotation annotation = new Annotation();
        annotation.u2typeIndex = this.dataInput.readUnsignedShort();
        String annotationType = this.getString(annotation.u2typeIndex);
        if (!"Lkotlin/Metadata;".equals(annotationType)) {
            this.skipAnnotationRemainingBytes(false, clazz, annotation);
            return;
        }
        annotation.u2elementValuesCount = this.dataInput.readUnsignedShort();
        KotlinMetadataElementValues kmValues = new KotlinMetadataElementValues();
        for (int index = 0; index < annotation.u2elementValuesCount; ++index) {
            int u2elementNameIndex = this.dataInput.readUnsignedShort();
            ElementValue elementValue = this.createElementValue();
            elementValue.u2elementNameIndex = u2elementNameIndex;
            String elementName = this.getString(u2elementNameIndex);
            elementValue.accept(clazz, annotation, KotlinMetadataInitializer.isValidKotlinMetadataAnnotationField(elementName) ? new KotlinMetadataAnnotationElementValueReader(KotlinMetadataInitializer.metadataTypeOf(elementName), kmValues) : new SkipAnnotationElementVisitor());
        }
        this.kmElementValueConsumer.accept(kmValues.k, kmValues.mv == null ? null : kmValues.mv.stream().mapToInt(i -> i).toArray(), kmValues.d1 == null ? null : kmValues.d1.toArray(new String[0]), kmValues.d2 == null ? null : kmValues.d2.toArray(new String[0]), kmValues.xi, kmValues.xs, kmValues.pn);
    }

    private ElementValue createElementValue() {
        int u1tag = this.dataInput.readUnsignedByte();
        switch (u1tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                return new ConstantElementValue((char)u1tag);
            }
            case 101: {
                return new EnumConstantElementValue();
            }
            case 99: {
                return new ClassElementValue();
            }
            case 64: {
                return new AnnotationElementValue();
            }
            case 91: {
                return new ArrayElementValue();
            }
        }
        throw new IllegalArgumentException("Unknown element value tag [" + u1tag + "]");
    }

    private void skipAnnotationRemainingBytes(boolean readTypeIndex, Clazz clazz, Annotation annotation) {
        if (readTypeIndex) {
            this.dataInput.skipBytes(2);
        }
        annotation.u2elementValuesCount = this.dataInput.readUnsignedShort();
        for (int index = 0; index < annotation.u2elementValuesCount; ++index) {
            this.dataInput.skipBytes(2);
            this.createElementValue().accept(clazz, annotation, new SkipAnnotationElementVisitor());
        }
    }

    public static interface KotlinMetadataElementValueConsumer {
        public void accept(int var1, int[] var2, String[] var3, String[] var4, int var5, String var6, String var7);
    }

    private class SkipAnnotationElementVisitor
    implements ElementValueVisitor {
        private SkipAnnotationElementVisitor() {
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            LibraryClassReader.this.dataInput.skipBytes(2);
        }

        @Override
        public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
            LibraryClassReader.this.dataInput.skipBytes(2);
            LibraryClassReader.this.dataInput.skipBytes(2);
        }

        @Override
        public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
            LibraryClassReader.this.dataInput.skipBytes(2);
        }

        @Override
        public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
            LibraryClassReader.this.skipAnnotationRemainingBytes(true, clazz, new Annotation());
        }

        @Override
        public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
            int u2elementValuesCount = LibraryClassReader.this.dataInput.readUnsignedShort();
            for (int index = 0; index < u2elementValuesCount; ++index) {
                LibraryClassReader.this.createElementValue().accept(clazz, annotation, this);
            }
        }
    }

    private class KotlinMetadataAnnotationElementValueReader
    implements ElementValueVisitor {
        private final KotlinMetadataInitializer.MetadataType elementName;
        private final KotlinMetadataElementValues kotlinMetadataFields;

        public KotlinMetadataAnnotationElementValueReader(KotlinMetadataInitializer.MetadataType elementName, KotlinMetadataElementValues kotlinMetadataFields) {
            this.elementName = elementName;
            this.kotlinMetadataFields = kotlinMetadataFields;
        }

        @Override
        public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
            int u2constantValueIndex = LibraryClassReader.this.dataInput.readUnsignedShort();
            switch (this.elementName) {
                case mv: {
                    if (this.kotlinMetadataFields.mv != null) break;
                    this.kotlinMetadataFields.mv = new ArrayList<Integer>();
                    break;
                }
                case d1: {
                    if (this.kotlinMetadataFields.d1 != null) break;
                    this.kotlinMetadataFields.d1 = new ArrayList<String>();
                    break;
                }
                case d2: {
                    if (this.kotlinMetadataFields.d2 != null) break;
                    this.kotlinMetadataFields.d2 = new ArrayList<String>();
                }
            }
            switch (this.elementName) {
                case k: {
                    this.kotlinMetadataFields.k = LibraryClassReader.this.getInteger(u2constantValueIndex);
                    break;
                }
                case mv: {
                    this.kotlinMetadataFields.mv.add(LibraryClassReader.this.getInteger(u2constantValueIndex));
                    break;
                }
                case d1: {
                    this.kotlinMetadataFields.d1.add(LibraryClassReader.this.getString(u2constantValueIndex));
                    break;
                }
                case d2: {
                    this.kotlinMetadataFields.d2.add(LibraryClassReader.this.getString(u2constantValueIndex));
                    break;
                }
                case xi: {
                    this.kotlinMetadataFields.xi = LibraryClassReader.this.getInteger(u2constantValueIndex);
                    break;
                }
                case xs: {
                    this.kotlinMetadataFields.xs = LibraryClassReader.this.getString(u2constantValueIndex);
                    break;
                }
                case pn: {
                    this.kotlinMetadataFields.pn = LibraryClassReader.this.getString(u2constantValueIndex);
                }
            }
        }

        @Override
        public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
            int u2elementValuesCount = LibraryClassReader.this.dataInput.readUnsignedShort();
            for (int index = 0; index < u2elementValuesCount; ++index) {
                ElementValue elementValue = LibraryClassReader.this.createElementValue();
                elementValue.accept(clazz, annotation, this);
            }
        }
    }

    private static final class KotlinMetadataElementValues {
        public int k = -1;
        public List<Integer> mv;
        public List<String> d1;
        public List<String> d2;
        public int xi = 0;
        public String xs;
        public String pn;

        private KotlinMetadataElementValues() {
        }
    }
}

