/*
 * Decompiled with CFR 0.152.
 */
package proguard.io.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.function.BiFunction;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.ClassReader;
import proguard.io.DataEntry;
import proguard.io.DataEntryClassWriter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.DirectorySource;
import proguard.io.FilteredDataEntryReader;
import proguard.io.FixedFileWriter;
import proguard.io.JarReader;
import proguard.io.JarWriter;
import proguard.io.NameFilteredDataEntryReader;
import proguard.io.ZipWriter;
import proguard.util.ExtensionMatcher;
import proguard.util.OrMatcher;

public class IOUtil {
    private IOUtil() {
    }

    public static ClassPool read(String fileName, boolean isLibrary) throws IOException {
        return IOUtil.read(fileName, "**", isLibrary, (dataEntryReader, classPool) -> dataEntryReader);
    }

    public static ClassPool read(String fileName, String classNameFilter, boolean isLibrary, BiFunction<DataEntryReader, ClassPoolFiller, DataEntryReader> extraDataEntryReader) throws IOException {
        ClassPool classPool = new ClassPool();
        ClassPoolFiller classPoolFiller = new ClassPoolFiller(classPool);
        DirectorySource source = new DirectorySource(new File(fileName));
        DataEntryReader classReader = new NameFilteredDataEntryReader("**.class", (DataEntryReader)new ClassReader(isLibrary, false, false, false, null, new ClassNameFilter(classNameFilter, (ClassVisitor)classPoolFiller)));
        classReader = extraDataEntryReader.apply(classReader, classPoolFiller);
        classReader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher("aar")), new JarReader(new NameFilteredDataEntryReader("classes.jar", (DataEntryReader)new JarReader(classReader))), new FilteredDataEntryReader(new DataEntryNameFilter(new OrMatcher(new ExtensionMatcher("jar"), new ExtensionMatcher("zip"), new ExtensionMatcher("apk"), new ExtensionMatcher("jmod"))), new JarReader(classReader), classReader));
        source.pumpDataEntries(classReader);
        return classPool;
    }

    public static void writeJar(ClassPool programClassPool, String outputJarFileName) throws IOException {
        IOUtil.writeJar(programClassPool, outputJarFileName, null);
    }

    public static void writeJar(ClassPool programClassPool, String outputJarFileName, String mainClassName) throws IOException {
        class MyJarWriter
        extends JarWriter
        implements Closeable {
            final /* synthetic */ String val$mainClassName;

            public MyJarWriter(DataEntryWriter dataEntryWriter) {
                this.val$mainClassName = dataEntryWriter;
                super(zipEntryWriter);
            }

            @Override
            protected OutputStream createManifestOutputStream(DataEntry manifestEntry) throws IOException {
                OutputStream outputStream = super.createManifestOutputStream(manifestEntry);
                if (this.val$mainClassName != null) {
                    PrintWriter writer = new PrintWriter(outputStream);
                    writer.println("Main-Class: " + this.val$mainClassName);
                    writer.flush();
                }
                return outputStream;
            }

            @Override
            public void close() throws IOException {
                super.close();
            }
        }
        try (MyJarWriter jarWriter = new MyJarWriter((DataEntryWriter)new ZipWriter(new FixedFileWriter(new File(outputJarFileName))), mainClassName);){
            programClassPool.classesAccept(new DataEntryClassWriter(jarWriter));
        }
    }
}

