/*
 * Decompiled with CFR 0.152.
 */
package proguard.testutils.cpa;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.transfer.JvmTransferRelation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.ParticularReferenceValue;
import proguard.evaluation.value.UnknownValue;
import proguard.evaluation.value.Value;
import proguard.testutils.cpa.ExpressionAbstractState;
import proguard.testutils.cpa.InstructionExpression;
import proguard.testutils.cpa.MethodExpression;
import proguard.testutils.cpa.ValueExpression;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J,\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\nH\u0014J\u0010\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\nH\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0016J,\u0010!\u001a\u00020\"2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016\u00a8\u0006&"}, d2={"Lproguard/testutils/cpa/ExpressionTransferRelation;", "Lproguard/analysis/cpa/jvm/transfer/JvmTransferRelation;", "Lproguard/testutils/cpa/ExpressionAbstractState;", "()V", "applyArithmeticInstruction", "", "instruction", "Lproguard/classfile/instruction/Instruction;", "operands", "resultCount", "", "computeIncrement", "state", "value", "getAbstractByteConstant", "b", "", "getAbstractDefault", "getAbstractDoubleConstant", "d", "", "getAbstractFloatConstant", "f", "", "getAbstractIntegerConstant", "i", "getAbstractLongConstant", "l", "", "getAbstractNull", "getAbstractShortConstant", "s", "", "invokeMethod", "", "Lproguard/analysis/cpa/jvm/state/JvmAbstractState;", "call", "Lproguard/analysis/datastructure/callgraph/Call;", "proguard-core_testFixtures"})
public final class ExpressionTransferRelation
extends JvmTransferRelation<ExpressionAbstractState> {
    @NotNull
    protected List<ExpressionAbstractState> applyArithmeticInstruction(@NotNull Instruction instruction, @NotNull List<ExpressionAbstractState> operands, int resultCount) {
        List list;
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter(operands, (String)"operands");
        if (resultCount == 2) {
            Object[] objectArray = new ExpressionAbstractState[]{this.getAbstractDefault(), new ExpressionAbstractState(SetsKt.setOf((Object)new InstructionExpression(instruction, operands)))};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        } else {
            Object[] objectArray = new ExpressionAbstractState[]{new ExpressionAbstractState(SetsKt.setOf((Object)new InstructionExpression(instruction, operands)))};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        return list;
    }

    @NotNull
    protected ExpressionAbstractState computeIncrement(@NotNull ExpressionAbstractState state, int value) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ExpressionAbstractState(SetsKt.setOf((Object)new InstructionExpression((Instruction)new VariableInstruction(-124, 0, value), CollectionsKt.listOf((Object)state))));
    }

    @NotNull
    public List<ExpressionAbstractState> getAbstractDoubleConstant(double d) {
        Object[] objectArray = new ExpressionAbstractState[]{this.getAbstractDefault(), new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularDoubleValue(d))))};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public ExpressionAbstractState getAbstractFloatConstant(float f) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularFloatValue(f))));
    }

    @NotNull
    public ExpressionAbstractState getAbstractIntegerConstant(int i) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularIntegerValue(i))));
    }

    @NotNull
    public List<ExpressionAbstractState> getAbstractLongConstant(long l) {
        Object[] objectArray = new ExpressionAbstractState[]{this.getAbstractDefault(), new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularLongValue(l))))};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public ExpressionAbstractState getAbstractNull() {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularReferenceValue("", null, null, (Object)0, null))));
    }

    @NotNull
    public ExpressionAbstractState getAbstractShortConstant(short s) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularIntegerValue((int)s))));
    }

    public void invokeMethod(@NotNull JvmAbstractState<ExpressionAbstractState> state, @NotNull Call call, @NotNull List<ExpressionAbstractState> operands) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(operands, (String)"operands");
        String string = call.getTarget().descriptor.returnType;
        if (string == null) {
            string = "?";
        }
        switch (ClassUtil.internalTypeSize((String)string)) {
            case 0: {
                return;
            }
            case 1: {
                Object[] objectArray = new ExpressionAbstractState[1];
                String string2 = call.getTarget().getFqn();
                if (string2 == null) {
                    string2 = "?";
                }
                objectArray[0] = new ExpressionAbstractState(SetsKt.setOf((Object)new MethodExpression(string2, operands)));
                state.pushAll(CollectionsKt.mutableListOf((Object[])objectArray));
                break;
            }
            default: {
                Object[] objectArray = new ExpressionAbstractState[2];
                objectArray[0] = this.getAbstractDefault();
                String string3 = call.getTarget().getFqn();
                if (string3 == null) {
                    string3 = "?";
                }
                objectArray[1] = new ExpressionAbstractState(SetsKt.setOf((Object)new MethodExpression(string3, operands)));
                state.pushAll(CollectionsKt.mutableListOf((Object[])objectArray));
            }
        }
    }

    @NotNull
    public ExpressionAbstractState getAbstractDefault() {
        UnknownValue unknownValue = BasicValueFactory.UNKNOWN_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)unknownValue, (String)"UNKNOWN_VALUE");
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)unknownValue)));
    }

    @NotNull
    public ExpressionAbstractState getAbstractByteConstant(byte b) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularIntegerValue((int)b))));
    }
}

