/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.bam.BamCache;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.BlockAbstraction;
import proguard.analysis.cpa.bam.ExpandOperator;
import proguard.analysis.cpa.bam.ReduceOperator;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.interfaces.AbstractState;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.interfaces.Precision;
import proguard.analysis.cpa.interfaces.TransferRelation;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.edges.JvmAssumeExceptionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmUnknownCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.JvmReferenceAbstractState;
import proguard.analysis.cpa.jvm.domain.reference.Reference;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.heap.tree.JvmTreeHeapFollowerAbstractState;
import proguard.analysis.cpa.jvm.util.ConstantLookupVisitor;
import proguard.analysis.cpa.jvm.util.InstructionClassifier;
import proguard.analysis.cpa.jvm.witness.JvmHeapLocation;
import proguard.analysis.cpa.jvm.witness.JvmLocalVariableLocation;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.MethodSignature;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;

public class JvmMemoryLocationTransferRelation<AbstractStateT extends LatticeAbstractState<AbstractStateT>>
implements TransferRelation {
    private static final Logger log = LogManager.getLogger(JvmMemoryLocationTransferRelation.class);
    private final AbstractStateT threshold;
    private final JvmCfa cfa;
    private final BamCache<MethodSignature> cache;
    private final ReduceOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> tracedCpaReduceOperator;
    private final ExpandOperator<JvmCfaNode, JvmCfaEdge, MethodSignature> tracedCpaExpandOperator;

    public JvmMemoryLocationTransferRelation(AbstractStateT threshold, BamCpa<JvmCfaNode, JvmCfaEdge, MethodSignature> bamCpa) {
        this.threshold = threshold;
        this.cfa = (JvmCfa)bamCpa.getCfa();
        this.cache = bamCpa.getCache();
        this.tracedCpaReduceOperator = bamCpa.getReduceOperator();
        this.tracedCpaExpandOperator = bamCpa.getExpandOperator();
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState abstractState, Precision precision) {
        if (!(abstractState instanceof JvmMemoryLocationAbstractState)) {
            throw new IllegalArgumentException(this.getClass().getName() + " does not support " + abstractState.getClass().getName());
        }
        JvmMemoryLocationAbstractState state = (JvmMemoryLocationAbstractState)abstractState.copy();
        JvmCfaNode programLocation = state.getProgramLocation();
        Collection<JvmCfaEdge> intraproceduralEdges = programLocation.getEnteringIntraproceduralEdges();
        ArrayList<JvmMemoryLocationAbstractState> successors = new ArrayList<JvmMemoryLocationAbstractState>();
        if (!intraproceduralEdges.isEmpty()) {
            for (JvmCfaEdge edge : intraproceduralEdges) {
                JvmCfaNode intraproceduralParentNode = edge.getSource();
                Optional<AbstractState> intraproceduralParentState = this.getAnalysisAbstractState(state.getSourceReachedSet(), intraproceduralParentNode);
                if (!intraproceduralParentState.isPresent()) continue;
                Collection<JvmCallCfaEdge> interproceduralCallEdges = intraproceduralParentNode.getKnownMethodCallEdges();
                boolean shouldAnalyzeIntraproceduralCallEdge = intraproceduralParentNode.getLeavingEdges().stream().anyMatch(e -> e instanceof JvmCallCfaEdge && e.getTarget() instanceof JvmUnknownCfaNode);
                boolean interproceduralSuccessorFound = false;
                if (!(state.getLocationDependentMemoryLocation().getMemoryLocation() instanceof JvmLocalVariableLocation)) {
                    AbstractState currentState = this.getAnalysisAbstractState(state.getSourceReachedSet(), programLocation).get();
                    for (JvmCallCfaEdge callEdge2 : interproceduralCallEdges) {
                        if (state.callStackContains(callEdge2.getTarget().getSignature())) {
                            shouldAnalyzeIntraproceduralCallEdge = true;
                            continue;
                        }
                        AbstractState reducedEntryState = this.tracedCpaReduceOperator.reduce(intraproceduralParentState.get(), callEdge2.getTarget(), callEdge2.getCall());
                        BlockAbstraction calleeAbstraction = this.cache.get(reducedEntryState, precision, callEdge2.getTarget().getSignature());
                        if (calleeAbstraction != null) {
                            boolean hasIndirectPredecessor;
                            JvmStackLocation stackLocation;
                            int index;
                            if (state.getLocationDependentMemoryLocation().getMemoryLocation() instanceof JvmStackLocation && (index = (stackLocation = (JvmStackLocation)state.getLocationDependentMemoryLocation().getMemoryLocation()).getIndex()) > ClassUtil.internalTypeSize(callEdge2.getTarget().getSignature().descriptor.returnType)) continue;
                            JvmCfaNode calleeExitNode = this.cfa.getFunctionReturnExitNode(callEdge2.getTarget().getSignature(), callEdge2.getTarget().getClazz());
                            Optional<AbstractState> returnState = this.getAnalysisAbstractState((ProgramLocationDependentReachedSet)calleeAbstraction.getReachedSet(), calleeExitNode);
                            if (!returnState.isPresent()) {
                                shouldAnalyzeIntraproceduralCallEdge = true;
                                continue;
                            }
                            JvmAbstractState returnJvmAbstractState = (JvmAbstractState)returnState.get().getStateByName("Jvm");
                            LatticeAbstractState value = (LatticeAbstractState)state.getLocationDependentMemoryLocation().getMemoryLocation().extractValueOrDefault(returnJvmAbstractState, this.threshold);
                            boolean hasDirectPredecessor = !value.isLessOrEqual(this.threshold);
                            boolean bl = hasIndirectPredecessor = returnJvmAbstractState.getHeap() instanceof JvmTreeHeapFollowerAbstractState && !returnJvmAbstractState.getFieldOrDefault(state.getLocationDependentMemoryLocation().getMemoryLocation(), "", this.threshold).isLessOrEqual(this.threshold);
                            if (!hasDirectPredecessor && !hasIndirectPredecessor || !((LatticeAbstractState)this.tracedCpaExpandOperator.expand(intraproceduralParentState.get(), returnState.get(), callEdge2.getTarget(), callEdge2.getCall())).isLessOrEqual((LatticeAbstractState)currentState)) continue;
                            JvmMemoryLocation parentLocation = state.getLocationDependentMemoryLocation().getMemoryLocation();
                            LinkedList<JvmMemoryLocationAbstractState.StackEntry> callStack = state.copyStack();
                            callStack.push(new JvmMemoryLocationAbstractState.StackEntry(calleeExitNode.getSignature(), state.getSourceReachedSet(), intraproceduralParentState.get()));
                            (hasDirectPredecessor ? Stream.of(state.getLocationDependentMemoryLocation().getMemoryLocation()) : (hasIndirectPredecessor ? Stream.of(new JvmHeapLocation(((JvmTreeHeapFollowerAbstractState)returnJvmAbstractState.getHeap()).getReferenceAbstractState(state.getLocationDependentMemoryLocation().getMemoryLocation()), "")) : Stream.of(new JvmMemoryLocation[0]))).map(l -> new JvmMemoryLocationAbstractState((JvmMemoryLocation)l, calleeExitNode, (ProgramLocationDependentReachedSet)calleeAbstraction.getReachedSet(), callStack)).forEach(successors::add);
                            interproceduralSuccessorFound = true;
                            continue;
                        }
                        shouldAnalyzeIntraproceduralCallEdge = true;
                    }
                }
                if (!interproceduralSuccessorFound) {
                    shouldAnalyzeIntraproceduralCallEdge = true;
                }
                ArrayList<JvmMemoryLocation> intraproceduralSuccessorMemoryLocations = new ArrayList<JvmMemoryLocation>();
                if (edge instanceof JvmInstructionCfaEdge && (!InstructionClassifier.isInvoke(((JvmInstructionCfaEdge)edge).getInstruction().opcode) || shouldAnalyzeIntraproceduralCallEdge)) {
                    intraproceduralSuccessorMemoryLocations.addAll(this.getSuccessorMemoryLocationsForInstruction(state, intraproceduralParentState.get(), ((JvmInstructionCfaEdge)edge).getInstruction(), state.getProgramLocation().getClazz(), precision));
                } else if (edge instanceof JvmAssumeExceptionCfaEdge) {
                    intraproceduralSuccessorMemoryLocations.add(state.getLocationDependentMemoryLocation().getMemoryLocation());
                }
                successors.addAll(this.getSuccessorsFromMemoryLocations(intraproceduralSuccessorMemoryLocations, (JvmAbstractState)intraproceduralParentState.get().getStateByName("Jvm"), state.getSourceReachedSet(), state.copyStack()));
            }
        }
        if (programLocation.isEntryNode()) {
            JvmMemoryLocationAbstractState.StackEntry currentEntry = state.peekCallStack();
            Optional<JvmMemoryLocation> callerMemoryLocation = this.createCallerLocation(state);
            if (callerMemoryLocation.isPresent()) {
                if (currentEntry == null) {
                    Optional<AbstractState> calledState = this.getAnalysisAbstractState(state.getSourceReachedSet(), programLocation);
                    if (!calledState.isPresent()) {
                        return Collections.emptyList();
                    }
                    programLocation.getEnteringEdges().stream().filter(CallEdge.class::isInstance).map(callEdge -> this.getCallersInfo((JvmCallCfaEdge)callEdge, programLocation, (AbstractState)calledState.get())).flatMap(Collection::stream).forEach(ci -> this.getSuccessorsFromMemoryLocations(Collections.singletonList(callerMemoryLocation.get()), (JvmAbstractState)ci.state.getStateByName("Jvm"), ci.reachedSet, new LinkedList<JvmMemoryLocationAbstractState.StackEntry>()).stream().findFirst().ifPresent(successors::add));
                } else {
                    LinkedList<JvmMemoryLocationAbstractState.StackEntry> successorStack = state.copyStack();
                    successorStack.pop();
                    successors.addAll(this.getSuccessorsFromMemoryLocations(Collections.singletonList(callerMemoryLocation.get()), (JvmAbstractState)currentEntry.callerState.getStateByName("Jvm"), currentEntry.reachedSet, successorStack));
                }
            }
        }
        successors.forEach(s -> ((JvmMemoryLocationAbstractState)abstractState).addSourceLocation(s.getLocationDependentMemoryLocation()));
        return successors;
    }

    protected List<JvmMemoryLocation> processCall(JvmMemoryLocation memoryLocation, ConstantInstruction callInstruction, Clazz clazz) {
        return this.backtraceStackLocation(memoryLocation, callInstruction, clazz);
    }

    private Optional<AbstractState> getAnalysisAbstractState(ProgramLocationDependentReachedSet reachedSet, JvmCfaNode location) {
        Collection<AbstractState> states = reachedSet.getReached(location);
        if (states.isEmpty()) {
            log.info(String.format("Missing entry state in the cache for method %s at offset %d", location.getSignature().getFqn(), location.getOffset()));
            return Optional.empty();
        }
        return states.stream().findFirst();
    }

    private List<JvmMemoryLocation> getSuccessorMemoryLocationsForInstruction(JvmMemoryLocationAbstractState abstractState, AbstractState parentState, Instruction instruction, Clazz clazz, Precision precision) {
        ArrayList<JvmMemoryLocation> answer = new ArrayList<JvmMemoryLocation>();
        instruction.accept(clazz, null, null, 0, new InstructionAbstractInterpreter(answer, abstractState.getLocationDependentMemoryLocation().getMemoryLocation(), parentState));
        return answer;
    }

    private Collection<CallerInfo> getCallersInfo(JvmCallCfaEdge callEdge, JvmCfaNode calledLocation, AbstractState calledState) {
        JvmCfaNode callerLocation = callEdge.getSource();
        Collection<BlockAbstraction> callerCacheEntries = this.cache.get(callerLocation.getSignature());
        ArrayList<CallerInfo> callerInfos = new ArrayList<CallerInfo>();
        for (BlockAbstraction cacheEntry : callerCacheEntries) {
            Optional<AbstractState> callerState = ((ProgramLocationDependentReachedSet)cacheEntry.getReachedSet()).getReached(callerLocation).stream().findFirst();
            if (!callerState.isPresent() || !this.tracedCpaReduceOperator.reduce(callerState.get(), calledLocation, callEdge.getCall()).equals(calledState)) continue;
            callerInfos.add(new CallerInfo((ProgramLocationDependentReachedSet)cacheEntry.getReachedSet(), callerState.get()));
        }
        return callerInfos;
    }

    private Optional<JvmMemoryLocation> createCallerLocation(JvmMemoryLocationAbstractState currentState) {
        JvmMemoryLocation memoryLocation = currentState.getLocationDependentMemoryLocation().getMemoryLocation();
        if (memoryLocation instanceof JvmLocalVariableLocation) {
            JvmLocalVariableLocation argumentLocation = (JvmLocalVariableLocation)memoryLocation;
            String currentDescriptor = currentState.getProgramLocation().getSignature().descriptor.toString();
            boolean isStatic = (currentState.getProgramLocation().getClazz().findMethod(currentState.getProgramLocation().getSignature().method, currentDescriptor).getAccessFlags() & 8) != 0;
            int parameterNumber = ClassUtil.internalMethodParameterNumber(currentDescriptor, isStatic, argumentLocation.index);
            int parameterSize = ClassUtil.internalMethodParameterSize(currentDescriptor, isStatic);
            boolean isCategory2 = ClassUtil.isInternalCategory2Type(ClassUtil.internalMethodParameterType(currentDescriptor, parameterNumber));
            return Optional.of(new JvmStackLocation(parameterSize - argumentLocation.index - (isCategory2 ? (parameterNumber == ClassUtil.internalMethodParameterNumber(currentDescriptor, isStatic, argumentLocation.index + 1) ? 2 : 0) : 1)));
        }
        if (memoryLocation instanceof JvmStaticFieldLocation || memoryLocation instanceof JvmHeapLocation) {
            return Optional.of(memoryLocation);
        }
        if (memoryLocation instanceof JvmStackLocation) {
            return Optional.empty();
        }
        throw new IllegalStateException("Unsupported memory location type " + memoryLocation.getClass().getCanonicalName());
    }

    private Collection<JvmMemoryLocationAbstractState> getSuccessorsFromMemoryLocations(List<JvmMemoryLocation> successorMemoryLocations, JvmAbstractState<AbstractStateT> parentState, ProgramLocationDependentReachedSet successorsReachedSet, LinkedList<JvmMemoryLocationAbstractState.StackEntry> callStack) {
        ArrayList<JvmMemoryLocation> resultMemoryLocations = new ArrayList<JvmMemoryLocation>();
        for (JvmMemoryLocation location : successorMemoryLocations) {
            JvmHeapLocation heapLocation;
            if (!((LatticeAbstractState)location.extractValueOrDefault(parentState, this.threshold)).isLessOrEqual(this.threshold)) {
                resultMemoryLocations.add(location);
                continue;
            }
            if (!(parentState.getHeap() instanceof JvmTreeHeapFollowerAbstractState) || ((LatticeAbstractState)(heapLocation = new JvmHeapLocation(((JvmTreeHeapFollowerAbstractState)parentState.getHeap()).getReferenceAbstractState(location), "")).extractValueOrDefault(parentState, this.threshold)).isLessOrEqual(this.threshold)) continue;
            resultMemoryLocations.add(heapLocation);
        }
        return resultMemoryLocations.stream().map(l -> new JvmMemoryLocationAbstractState((JvmMemoryLocation)l, parentState.getProgramLocation(), successorsReachedSet, callStack)).collect(Collectors.toList());
    }

    private List<JvmMemoryLocation> backtraceStackLocation(JvmMemoryLocation memoryLocation, Instruction instruction, Clazz clazz) {
        ArrayList<JvmMemoryLocation> result = new ArrayList<JvmMemoryLocation>();
        if (!(memoryLocation instanceof JvmStackLocation)) {
            result.add(memoryLocation);
            return result;
        }
        int index = ((JvmStackLocation)memoryLocation).getIndex();
        int pushCount = instruction.stackPushCount(clazz);
        int popCount = instruction.stackPopCount(clazz);
        if (index >= pushCount) {
            result.add(new JvmStackLocation(index - pushCount + popCount));
            return result;
        }
        result.addAll(this.getPoppedLocations(popCount));
        return result;
    }

    private List<JvmMemoryLocation> getPoppedLocations(int popCount) {
        ArrayList<JvmMemoryLocation> result = new ArrayList<JvmMemoryLocation>();
        for (int i = 0; i < popCount; ++i) {
            result.add(new JvmStackLocation(i));
        }
        return result;
    }

    private boolean isStackLocationTooDeep(JvmStackLocation stackLocation, Instruction instruction, Clazz clazz) {
        return stackLocation.index >= instruction.stackPushCount(clazz);
    }

    private class InstructionAbstractInterpreter
    implements InstructionVisitor {
        private final List<JvmMemoryLocation> answer;
        private final JvmMemoryLocation memoryLocation;
        private final AbstractState parentState;
        private final ConstantLookupVisitor constantLookupVisitor = new ConstantLookupVisitor();

        public InstructionAbstractInterpreter(List<JvmMemoryLocation> answer, JvmMemoryLocation memoryLocation, AbstractState parentState) {
            this.answer = answer;
            this.memoryLocation = memoryLocation;
            this.parentState = parentState;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (simpleInstruction.opcode >= 79 && simpleInstruction.opcode <= 86 && this.memoryLocation instanceof JvmHeapLocation) {
                this.answer.add(this.memoryLocation);
                if (((JvmAbstractState)this.parentState.getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState) {
                    SetAbstractState arrayReference = (SetAbstractState)((JvmReferenceAbstractState)this.parentState.getStateByName("Reference")).peek(simpleInstruction.isCategory2() ? 3 : 2);
                    JvmHeapLocation heapLocation = (JvmHeapLocation)this.memoryLocation;
                    if (heapLocation.reference.stream().anyMatch(arrayReference::contains) && heapLocation.field.equals("[]")) {
                        this.answer.add(new JvmStackLocation(0));
                    }
                }
                return;
            }
            if (!(this.memoryLocation instanceof JvmStackLocation) || InstructionClassifier.isReturn(simpleInstruction.opcode)) {
                this.answer.add(this.memoryLocation);
                return;
            }
            int index = ((JvmStackLocation)this.memoryLocation).getIndex();
            if (JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, simpleInstruction, clazz)) {
                this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, simpleInstruction, clazz));
                return;
            }
            switch (simpleInstruction.opcode) {
                case 89: {
                    this.answer.add(new JvmStackLocation(0));
                    break;
                }
                case 90: {
                    this.answer.add(index == 2 ? new JvmStackLocation(0) : this.memoryLocation);
                    break;
                }
                case 91: {
                    this.answer.add(index == 3 ? new JvmStackLocation(0) : this.memoryLocation);
                    break;
                }
                case 92: {
                    this.answer.add(index > 1 ? new JvmStackLocation(index - 2) : this.memoryLocation);
                    break;
                }
                case 93: {
                    this.answer.add(index > 2 ? new JvmStackLocation(index - 3) : this.memoryLocation);
                    break;
                }
                case 94: {
                    this.answer.add(index > 3 ? new JvmStackLocation(index - 4) : this.memoryLocation);
                    break;
                }
                case 95: {
                    this.answer.add(new JvmStackLocation(1 - index));
                    break;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: {
                    this.answer.add(new JvmStackLocation(0));
                    this.answer.add(new JvmStackLocation(1));
                    if (!(((JvmAbstractState)this.parentState.getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState)) break;
                    this.answer.add(new JvmHeapLocation((SetAbstractState)((JvmReferenceAbstractState)this.parentState.getStateByName("Reference")).peek(1), "[]"));
                    break;
                }
                default: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, simpleInstruction, clazz));
                }
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode == -124) {
                this.answer.add(this.memoryLocation);
                return;
            }
            if (variableInstruction.isLoad()) {
                this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, variableInstruction, clazz));
                if (this.memoryLocation instanceof JvmStackLocation && !JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, variableInstruction, clazz)) {
                    this.answer.add(new JvmLocalVariableLocation(variableInstruction.variableIndex + ((JvmStackLocation)this.memoryLocation).index));
                }
                return;
            }
            if (!(this.memoryLocation instanceof JvmLocalVariableLocation) || ((JvmLocalVariableLocation)this.memoryLocation).index != variableInstruction.variableIndex) {
                this.answer.add(this.memoryLocation);
                return;
            }
            this.answer.add(new JvmStackLocation(0));
            if (variableInstruction.isCategory2()) {
                this.answer.add(new JvmStackLocation(1));
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -78: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                    if (!(this.memoryLocation instanceof JvmStackLocation) || JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, constantInstruction, clazz)) break;
                    this.answer.add(new JvmStaticFieldLocation(this.constantLookupVisitor.result));
                    break;
                }
                case -77: {
                    this.constantLookupVisitor.isStatic = true;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.memoryLocation instanceof JvmStackLocation) {
                        this.answer.add(new JvmStackLocation(((JvmStackLocation)this.memoryLocation).getIndex() + this.constantLookupVisitor.resultSize));
                        break;
                    }
                    if (this.memoryLocation instanceof JvmStaticFieldLocation) {
                        if (this.constantLookupVisitor.result.equals(((JvmStaticFieldLocation)this.memoryLocation).fqn)) {
                            this.answer.add(new JvmStackLocation(0));
                            if (this.constantLookupVisitor.resultSize != 2) break;
                            this.answer.add(new JvmStackLocation(1));
                            break;
                        }
                        this.answer.add(this.memoryLocation);
                        break;
                    }
                    this.answer.add(this.memoryLocation);
                    break;
                }
                case -76: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                    if (!(this.memoryLocation instanceof JvmStackLocation) || JvmMemoryLocationTransferRelation.this.isStackLocationTooDeep((JvmStackLocation)this.memoryLocation, constantInstruction, clazz) || !(((JvmAbstractState)this.parentState.getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState)) break;
                    this.answer.add(new JvmHeapLocation((SetAbstractState)((JvmReferenceAbstractState)this.parentState.getStateByName("Reference")).peek(), this.constantLookupVisitor.result));
                    break;
                }
                case -75: {
                    this.constantLookupVisitor.isStatic = false;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.constantLookupVisitor);
                    if (this.memoryLocation instanceof JvmStackLocation) {
                        this.answer.add(new JvmStackLocation(((JvmStackLocation)this.memoryLocation).index + this.constantLookupVisitor.resultSize + 1));
                        break;
                    }
                    if (!(this.memoryLocation instanceof JvmHeapLocation)) {
                        this.answer.add(this.memoryLocation);
                        break;
                    }
                    JvmHeapLocation heapLocation = (JvmHeapLocation)this.memoryLocation;
                    if (!this.constantLookupVisitor.result.equals(heapLocation.field) || !(((JvmAbstractState)this.parentState.getStateByName("Jvm")).getHeap() instanceof JvmTreeHeapFollowerAbstractState)) {
                        this.answer.add(this.memoryLocation);
                        break;
                    }
                    SetAbstractState reference = (SetAbstractState)((JvmReferenceAbstractState)this.parentState.getStateByName("Reference")).peek(this.constantLookupVisitor.resultSize);
                    SetAbstractState referenceIntersection = heapLocation.reference.stream().filter(reference::contains).collect(Collectors.toCollection(() -> new SetAbstractState<Reference>(new Reference[0])));
                    if (referenceIntersection.size() == 0 || reference.size() != 1 || this.constantLookupVisitor.result.endsWith("[]")) {
                        this.answer.add(this.memoryLocation);
                    }
                    if (referenceIntersection.size() <= 0) break;
                    this.answer.add(new JvmStackLocation(0));
                    if (this.constantLookupVisitor.resultSize <= 1) break;
                    this.answer.add(new JvmStackLocation(1));
                    break;
                }
                case -74: 
                case -73: 
                case -72: 
                case -71: 
                case -70: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.processCall(this.memoryLocation, constantInstruction, clazz));
                    break;
                }
                default: {
                    this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, constantInstruction, clazz));
                }
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, branchInstruction, clazz));
        }

        @Override
        public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
            this.answer.addAll(JvmMemoryLocationTransferRelation.this.backtraceStackLocation(this.memoryLocation, switchInstruction, clazz));
        }
    }

    private static class CallerInfo {
        public final ProgramLocationDependentReachedSet reachedSet;
        public final AbstractState state;

        public CallerInfo(ProgramLocationDependentReachedSet reachedSet, AbstractState state) {
            this.reachedSet = reachedSet;
            this.state = state;
        }
    }
}

