/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import proguard.analysis.cpa.interfaces.CallEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCallCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.analysis.cpa.jvm.witness.JvmStaticFieldLocation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.Signature;
import proguard.classfile.util.ClassUtil;

public class JvmInvokeTaintSink
extends JvmTaintSink {
    public final Optional<Predicate<Call>> callMatcher;
    public final boolean takesInstance;
    public final Set<Integer> takesArgs;
    public final Set<String> takesGlobals;

    public JvmInvokeTaintSink(Signature signature, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals) {
        this(signature, Optional.empty(), takesInstance, takesArgs, takesGlobals);
    }

    public JvmInvokeTaintSink(Signature signature, Predicate<Call> callMatcher, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals) {
        this(signature, Optional.of(callMatcher), takesInstance, takesArgs, takesGlobals);
    }

    private JvmInvokeTaintSink(Signature signature, Optional<Predicate<Call>> callMatcher, boolean takesInstance, Set<Integer> takesArgs, Set<String> takesGlobals) {
        super(signature);
        if (!takesInstance && takesArgs.isEmpty() && takesGlobals.isEmpty()) {
            throw new RuntimeException(String.format("Tainted sink for method %s must have taint somewhere!", signature));
        }
        this.callMatcher = callMatcher;
        this.takesInstance = takesInstance;
        this.takesArgs = takesArgs;
        this.takesGlobals = takesGlobals;
    }

    @Override
    public Set<JvmMemoryLocation> getMemoryLocations() {
        HashSet<JvmMemoryLocation> result = new HashSet<JvmMemoryLocation>();
        String fqn = this.signature.getFqn();
        String descriptor = fqn.substring(fqn.indexOf("("));
        int parameterSize = ClassUtil.internalMethodParameterSize(descriptor);
        if (this.takesInstance) {
            result.add(new JvmStackLocation(parameterSize));
        }
        this.takesArgs.forEach(i -> result.add(new JvmStackLocation(parameterSize - ClassUtil.internalMethodVariableIndex(descriptor, true, (int)i))));
        this.takesGlobals.forEach(n -> result.add(new JvmStaticFieldLocation((String)n)));
        return result;
    }

    @Override
    public boolean matchCfaEdge(JvmCfaEdge edge) {
        if (!(edge instanceof JvmCallCfaEdge)) {
            return false;
        }
        CallEdge callEdge = (CallEdge)((Object)edge);
        return this.signature.equals(callEdge.getCall().getTarget()) && this.callMatcher.map(p -> p.test(callEdge.getCall())).orElse(true) != false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JvmInvokeTaintSink)) {
            return false;
        }
        JvmInvokeTaintSink taintSink = (JvmInvokeTaintSink)o;
        return this.takesInstance == taintSink.takesInstance && Objects.equals(this.signature, taintSink.signature) && Objects.equals(this.takesArgs, taintSink.takesArgs) && Objects.equals(this.takesGlobals, taintSink.takesGlobals) && Objects.equals(this.callMatcher, taintSink.callMatcher);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.signature, this.takesInstance, this.takesArgs, this.takesGlobals, this.callMatcher);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder("[JvmInvokeTaintSink] ").append(this.signature);
        if (this.takesInstance) {
            result.append(", takes instance");
        }
        if (!this.takesArgs.isEmpty()) {
            result.append(", takes args (").append(this.takesArgs.stream().map(Objects::toString).sorted().collect(Collectors.joining(", "))).append(")");
        }
        if (!this.takesGlobals.isEmpty()) {
            result.append(", takes globals (").append(this.takesGlobals.stream().sorted().collect(Collectors.joining(", "))).append(")");
        }
        this.callMatcher.ifPresent(p -> result.append(" filtered by ").append(p));
        return result.toString();
    }
}

