/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.taint;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import proguard.analysis.cpa.jvm.cfa.edges.JvmCfaEdge;
import proguard.analysis.cpa.jvm.cfa.edges.JvmInstructionCfaEdge;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.jvm.witness.JvmStackLocation;
import proguard.classfile.Signature;

public class JvmReturnTaintSink
extends JvmTaintSink {
    public JvmReturnTaintSink(Signature signature) {
        super(signature);
    }

    @Override
    public Set<JvmMemoryLocation> getMemoryLocations() {
        return Collections.singleton(new JvmStackLocation(0));
    }

    @Override
    public boolean matchCfaEdge(JvmCfaEdge edge) {
        return edge instanceof JvmInstructionCfaEdge && edge.getTarget().isReturnExitNode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JvmReturnTaintSink)) {
            return false;
        }
        JvmReturnTaintSink taintSink = (JvmReturnTaintSink)o;
        return Objects.equals(this.signature, taintSink.signature);
    }

    @Override
    public int hashCode() {
        return this.signature.hashCode();
    }

    @Override
    public String toString() {
        return "[JvmReturnTaintSink] " + this.signature;
    }
}

