/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.state.heap.tree;

import java.util.List;
import java.util.Objects;
import proguard.analysis.cpa.defaults.LatticeAbstractState;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;

public class JvmShallowHeapAbstractState<ReferenceT, StateT extends LatticeAbstractState<StateT>>
implements JvmHeapAbstractState<StateT> {
    public final MapAbstractState<ReferenceT, StateT> referenceToObject;
    protected final Class<ReferenceT> referenceClass;
    protected final StateT defaultValue;

    public JvmShallowHeapAbstractState(MapAbstractState<ReferenceT, StateT> referenceToObject, Class<ReferenceT> referenceClass, StateT defaultValue) {
        this.referenceToObject = referenceToObject;
        this.referenceClass = referenceClass;
        this.defaultValue = defaultValue;
    }

    @Override
    public void expand(JvmHeapAbstractState<StateT> otherState) {
        if (!(otherState instanceof JvmShallowHeapAbstractState)) {
            throw new IllegalArgumentException("The other state should be a JvmTreeHeapAbstractState");
        }
        ((JvmShallowHeapAbstractState)otherState).referenceToObject.forEach(this.referenceToObject::putIfAbsent);
    }

    @Override
    public <T> StateT getFieldOrDefault(T object, String fqn, StateT defaultValue) {
        return (StateT)(this.referenceClass.isInstance(object) && fqn.length() == 0 ? (LatticeAbstractState)this.referenceToObject.getOrDefault(this.referenceClass.cast(object), defaultValue) : defaultValue);
    }

    @Override
    public <T> void setField(T object, String fqn, StateT value) {
        if (!this.referenceClass.isInstance(object) || fqn.length() > 0) {
            return;
        }
        this.referenceToObject.put(this.referenceClass.cast(object), value);
    }

    @Override
    public <T> StateT getArrayElementOrDefault(T array, StateT index, StateT defaultValue) {
        return (StateT)(this.referenceClass.isInstance(array) ? (LatticeAbstractState)this.referenceToObject.getOrDefault(this.referenceClass.cast(array), defaultValue) : defaultValue);
    }

    @Override
    public <T> void setArrayElement(T array, StateT index, StateT value) {
        if (!this.referenceClass.isInstance(array)) {
            return;
        }
        this.referenceToObject.put(this.referenceClass.cast(array), value);
    }

    @Override
    public StateT newObject(String className, JvmCfaNode creationCite) {
        return this.defaultValue;
    }

    @Override
    public StateT newArray(String type, List<StateT> dimensions, JvmCfaNode creationCite) {
        return this.defaultValue;
    }

    @Override
    public JvmShallowHeapAbstractState<ReferenceT, StateT> join(JvmHeapAbstractState<StateT> abstractState) {
        JvmShallowHeapAbstractState other = (JvmShallowHeapAbstractState)abstractState;
        MapAbstractState<ReferenceT, StateT> newReferenceToState = this.referenceToObject.join(other.referenceToObject);
        if (this.referenceToObject == newReferenceToState) {
            return this;
        }
        if (other.referenceToObject == newReferenceToState) {
            return other;
        }
        return new JvmShallowHeapAbstractState<ReferenceT, StateT>(newReferenceToState, this.referenceClass, this.defaultValue);
    }

    @Override
    public boolean isLessOrEqual(JvmHeapAbstractState<StateT> abstractState) {
        return abstractState instanceof JvmShallowHeapAbstractState && this.referenceToObject.isLessOrEqual(((JvmShallowHeapAbstractState)abstractState).referenceToObject);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JvmShallowHeapAbstractState)) {
            return false;
        }
        JvmShallowHeapAbstractState that = (JvmShallowHeapAbstractState)o;
        return Objects.equals(this.referenceToObject, that.referenceToObject);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.referenceToObject);
    }

    @Override
    public JvmShallowHeapAbstractState<ReferenceT, StateT> copy() {
        return new JvmShallowHeapAbstractState<ReferenceT, StateT>(this.referenceToObject.copy(), this.referenceClass, this.defaultValue);
    }
}

