/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import java.util.Arrays;
import java.util.Objects;
import proguard.classfile.instruction.Instruction;

public abstract class SwitchInstruction
extends Instruction {
    public int defaultOffset;
    public int[] jumpOffsets;

    public SwitchInstruction() {
    }

    public SwitchInstruction(byte opcode, int defaultOffset, int[] jumpOffsets) {
        this.opcode = opcode;
        this.defaultOffset = defaultOffset;
        this.jumpOffsets = jumpOffsets;
    }

    public SwitchInstruction copy(SwitchInstruction switchInstruction) {
        this.opcode = switchInstruction.opcode;
        this.defaultOffset = switchInstruction.defaultOffset;
        this.jumpOffsets = switchInstruction.jumpOffsets;
        return this;
    }

    @Override
    public String toString(int offset) {
        return "[" + offset + "] " + this.toString() + " (target=" + (offset + this.defaultOffset) + ")";
    }

    public String toString() {
        return this.getName() + " (" + this.jumpOffsets.length + " offsets, default=" + this.defaultOffset + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchInstruction that = (SwitchInstruction)o;
        return this.opcode == that.opcode && this.defaultOffset == that.defaultOffset && Arrays.equals(this.jumpOffsets, that.jumpOffsets);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.opcode, this.defaultOffset);
        result = 31 * result + Arrays.hashCode(this.jumpOffsets);
        return result;
    }
}

