/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.util.Arrays;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.BranchTargetFinder;
import proguard.classfile.visitor.ExceptionHandlerFilter;
import proguard.evaluation.BasicBranchUnit;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.ExcessiveComplexityException;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Processor;
import proguard.evaluation.TracedBranchUnit;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.Variables;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ValueFactory;

public class PartialEvaluator
implements AttributeVisitor,
ExceptionInfoVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_RESULTS = false;
    private static final Logger logger = LogManager.getLogger(PartialEvaluator.class);
    private static final int GENERALIZE_AFTER_N_EVALUATIONS = 5;
    private int stopAnalysisAfterNEvaluations = -1;
    public static final int NONE = -2;
    public static final int AT_METHOD_ENTRY = -1;
    public static final int AT_CATCH_ENTRY = -1;
    private final ValueFactory valueFactory;
    private final InvocationUnit invocationUnit;
    private final boolean evaluateAllCode;
    private final InstructionVisitor extraInstructionVisitor;
    private InstructionOffsetValue[] branchOriginValues = new InstructionOffsetValue[8096];
    private InstructionOffsetValue[] branchTargetValues = new InstructionOffsetValue[8096];
    private TracedVariables[] variablesBefore = new TracedVariables[8096];
    private TracedStack[] stacksBefore = new TracedStack[8096];
    private TracedVariables[] variablesAfter = new TracedVariables[8096];
    private TracedStack[] stacksAfter = new TracedStack[8096];
    private boolean[] generalizedContexts = new boolean[8096];
    private int[] evaluationCounts = new int[8096];
    private boolean evaluateExceptions;
    private int codeLength;
    private final BasicBranchUnit branchUnit;
    private final BranchTargetFinder branchTargetFinder;
    private final Stack<MyInstructionBlock> callingInstructionBlockStack;
    private final Stack<MyInstructionBlock> instructionBlockStack = new Stack();

    public PartialEvaluator() {
        this(new BasicValueFactory());
    }

    public PartialEvaluator(ValueFactory valueFactory) {
        this(valueFactory, new BasicInvocationUnit(valueFactory), true);
    }

    public PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean evaluateAllCode) {
        this(valueFactory, invocationUnit, evaluateAllCode, null);
    }

    public PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean evaluateAllCode, InstructionVisitor extraInstructionVisitor) {
        this(valueFactory, invocationUnit, evaluateAllCode, extraInstructionVisitor, evaluateAllCode ? new BasicBranchUnit() : new TracedBranchUnit(), new BranchTargetFinder(), null);
    }

    private PartialEvaluator(PartialEvaluator partialEvaluator) {
        this(partialEvaluator.valueFactory, partialEvaluator.invocationUnit, partialEvaluator.evaluateAllCode, partialEvaluator.extraInstructionVisitor, partialEvaluator.branchUnit, partialEvaluator.branchTargetFinder, partialEvaluator.instructionBlockStack);
    }

    private PartialEvaluator(ValueFactory valueFactory, InvocationUnit invocationUnit, boolean evaluateAllCode, InstructionVisitor extraInstructionVisitor, BasicBranchUnit branchUnit, BranchTargetFinder branchTargetFinder, Stack<MyInstructionBlock> callingInstructionBlockStack) {
        this.valueFactory = valueFactory;
        this.invocationUnit = invocationUnit;
        this.evaluateAllCode = evaluateAllCode;
        this.extraInstructionVisitor = extraInstructionVisitor;
        this.branchUnit = branchUnit;
        this.branchTargetFinder = branchTargetFinder;
        this.callingInstructionBlockStack = callingInstructionBlockStack == null ? this.instructionBlockStack : callingInstructionBlockStack;
    }

    private PartialEvaluator(Builder builder) {
        this.valueFactory = builder.valueFactory == null ? new BasicValueFactory() : builder.valueFactory;
        this.invocationUnit = builder.invocationUnit == null ? new BasicInvocationUnit(this.valueFactory) : builder.invocationUnit;
        this.evaluateAllCode = builder.evaluateAllCode;
        this.extraInstructionVisitor = builder.extraInstructionVisitor;
        this.branchUnit = builder.branchUnit == null ? (this.evaluateAllCode ? new BasicBranchUnit() : new TracedBranchUnit()) : builder.branchUnit;
        this.branchTargetFinder = builder.branchTargetFinder == null ? new BranchTargetFinder() : builder.branchTargetFinder;
        this.callingInstructionBlockStack = builder.callingInstructionBlockStack == null ? this.instructionBlockStack : builder.callingInstructionBlockStack;
        this.stopAnalysisAfterNEvaluations = builder.stopAnalysisAfterNEvaluations;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            logger.error("Unexpected error while performing partial evaluation:");
            logger.error("  Class       = [{}]", (Object)clazz.getName());
            logger.error("  Method      = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
            logger.error("  Exception   = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            throw ex;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        TracedVariables variables = new TracedVariables(codeAttribute.u2maxLocals);
        TracedStack stack = new TracedStack(codeAttribute.u2maxStack);
        this.initializeArrays(codeAttribute);
        this.initializeParameters(clazz, method, codeAttribute, variables);
        this.instructionBlockStack.clear();
        this.callingInstructionBlockStack.clear();
        codeAttribute.accept(clazz, method, (AttributeVisitor)this.branchTargetFinder);
        this.evaluateInstructionBlockAndExceptionHandlers(clazz, method, codeAttribute, variables, stack, 0, codeAttribute.u4codeLength);
    }

    public boolean isTraced(int startOffset, int endOffset) {
        for (int index = startOffset; index < endOffset; ++index) {
            if (!this.isTraced(index)) continue;
            return true;
        }
        return false;
    }

    public boolean isTraced(int instructionOffset) {
        return this.evaluationCounts[instructionOffset] > 0;
    }

    public boolean isInstruction(int instructionOffset) {
        return this.branchTargetFinder.isInstruction(instructionOffset);
    }

    public boolean isTarget(int instructionOffset) {
        return this.branchTargetFinder.isTarget(instructionOffset);
    }

    public boolean isBranchOrigin(int instructionOffset) {
        return this.branchTargetFinder.isBranchOrigin(instructionOffset);
    }

    public boolean isBranchTarget(int instructionOffset) {
        return this.branchTargetFinder.isBranchTarget(instructionOffset);
    }

    public boolean isBranchOrExceptionTarget(int instructionOffset) {
        return this.branchTargetFinder.isBranchTarget(instructionOffset) || this.branchTargetFinder.isExceptionHandler(instructionOffset);
    }

    public boolean isExceptionHandler(int instructionOffset) {
        return this.branchTargetFinder.isExceptionHandler(instructionOffset);
    }

    public boolean isSubroutineStart(int instructionOffset) {
        return this.branchTargetFinder.isSubroutineStart(instructionOffset);
    }

    public boolean isSubroutineInvocation(int instructionOffset) {
        return this.branchTargetFinder.isSubroutineInvocation(instructionOffset);
    }

    public boolean isSubroutine(int instructionOffset) {
        return this.branchTargetFinder.isSubroutine(instructionOffset);
    }

    public boolean isSubroutineReturning(int instructionOffset) {
        return this.branchTargetFinder.isSubroutineReturning(instructionOffset);
    }

    public int subroutineEnd(int instructionOffset) {
        return this.branchTargetFinder.subroutineEnd(instructionOffset);
    }

    public boolean isCreation(int offset) {
        return this.branchTargetFinder.isCreation(offset);
    }

    public boolean isInitializer(int offset) {
        return this.branchTargetFinder.isInitializer(offset);
    }

    public TracedVariables getVariablesBefore(int instructionOffset) {
        return this.variablesBefore[instructionOffset];
    }

    public TracedVariables getVariablesAfter(int instructionOffset) {
        return this.variablesAfter[instructionOffset];
    }

    public TracedStack getStackBefore(int instructionOffset) {
        return this.stacksBefore[instructionOffset];
    }

    public TracedStack getStackAfter(int instructionOffset) {
        return this.stacksAfter[instructionOffset];
    }

    public InstructionOffsetValue branchOrigins(int instructionOffset) {
        return this.branchOriginValues[instructionOffset];
    }

    public InstructionOffsetValue branchTargets(int instructionOffset) {
        return this.branchTargetValues[instructionOffset];
    }

    public InstructionVisitor tracedInstructionFilter(InstructionVisitor instructionVisitor) {
        return this.tracedInstructionFilter(true, instructionVisitor);
    }

    public InstructionVisitor tracedInstructionFilter(boolean traced, InstructionVisitor instructionVisitor) {
        return new MyTracedInstructionFilter(traced, instructionVisitor);
    }

    private void pushCallingInstructionBlock(TracedVariables variables, TracedStack stack, int startOffset) {
        this.callingInstructionBlockStack.push(new MyInstructionBlock(variables, stack, startOffset));
    }

    private void pushInstructionBlock(TracedVariables variables, TracedStack stack, int startOffset) {
        this.instructionBlockStack.push(new MyInstructionBlock(variables, stack, startOffset));
    }

    private void evaluateInstructionBlockAndExceptionHandlers(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables, TracedStack stack, int startOffset, int endOffset) {
        this.evaluateInstructionBlock(clazz, method, codeAttribute, variables, stack, startOffset);
        this.evaluateExceptionHandlers(clazz, method, codeAttribute, startOffset, endOffset);
    }

    private void evaluateInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables, TracedStack stack, int startOffset) {
        this.evaluateSingleInstructionBlock(clazz, method, codeAttribute, variables, stack, startOffset);
        while (!this.instructionBlockStack.empty()) {
            MyInstructionBlock instructionBlock = this.instructionBlockStack.pop();
            this.evaluateSingleInstructionBlock(clazz, method, codeAttribute, instructionBlock.variables, instructionBlock.stack, instructionBlock.startOffset);
        }
    }

    private void evaluateSingleInstructionBlock(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables, TracedStack stack, int startOffset) {
        block21: {
            Instruction instruction;
            byte[] code = codeAttribute.code;
            Processor processor = new Processor(variables, stack, this.valueFactory, this.branchUnit, this.invocationUnit, this.evaluateAllCode);
            int instructionOffset = startOffset;
            int maxOffset = startOffset;
            do {
                int evaluationCount;
                if (maxOffset < instructionOffset) {
                    maxOffset = instructionOffset;
                }
                if ((evaluationCount = this.evaluationCounts[instructionOffset]) == 0) {
                    if (this.variablesBefore[instructionOffset] == null) {
                        this.variablesBefore[instructionOffset] = new TracedVariables(variables);
                        this.stacksBefore[instructionOffset] = new TracedStack(stack);
                    } else {
                        this.variablesBefore[instructionOffset].initialize(variables);
                        this.stacksBefore[instructionOffset].copy(stack);
                    }
                    this.generalizedContexts[instructionOffset] = true;
                } else {
                    boolean variablesChanged = this.variablesBefore[instructionOffset].generalize(variables, true);
                    boolean stackChanged = this.stacksBefore[instructionOffset].generalize(stack);
                    if (!variablesChanged && !stackChanged && this.generalizedContexts[instructionOffset]) break block21;
                    if (evaluationCount >= 5) {
                        if (this.stopAnalysisAfterNEvaluations != -1 && evaluationCount >= this.stopAnalysisAfterNEvaluations) {
                            throw new ExcessiveComplexityException("Stopping evaluation after " + evaluationCount + " evaluations.");
                        }
                        variables.generalize(this.variablesBefore[instructionOffset], false);
                        stack.generalize(this.stacksBefore[instructionOffset]);
                        this.generalizedContexts[instructionOffset] = true;
                    } else {
                        this.generalizedContexts[instructionOffset] = false;
                    }
                }
                int n = instructionOffset;
                this.evaluationCounts[n] = this.evaluationCounts[n] + 1;
                InstructionOffsetValue storeValue = new InstructionOffsetValue(instructionOffset);
                variables.setProducerValue(storeValue);
                stack.setProducerValue(storeValue);
                instruction = InstructionFactory.create(code, instructionOffset);
                this.branchUnit.reset();
                if (this.extraInstructionVisitor != null) {
                    instruction.accept(clazz, method, codeAttribute, instructionOffset, this.extraInstructionVisitor);
                }
                try {
                    instruction.accept(clazz, method, codeAttribute, instructionOffset, processor);
                }
                catch (RuntimeException ex) {
                    logger.error("Unexpected error while evaluating instruction:");
                    logger.error("  Class       = [{}]", (Object)clazz.getName());
                    logger.error("  Method      = [{}{}]", (Object)method.getName(clazz), (Object)method.getDescriptor(clazz));
                    logger.error("  Instruction = {}", (Object)instruction.toString(clazz, instructionOffset));
                    logger.error("  Exception   = [{}] ({})", (Object)ex.getClass().getName(), (Object)ex.getMessage());
                    throw ex;
                }
                InstructionOffsetValue branchTargets = this.branchUnit.getTraceBranchTargets();
                int branchTargetCount = branchTargets.instructionOffsetCount();
                if (evaluationCount == 0) {
                    if (this.variablesAfter[instructionOffset] == null) {
                        this.variablesAfter[instructionOffset] = new TracedVariables(variables);
                        this.stacksAfter[instructionOffset] = new TracedStack(stack);
                    } else {
                        this.variablesAfter[instructionOffset].initialize(variables);
                        this.stacksAfter[instructionOffset].copy(stack);
                    }
                } else {
                    this.variablesAfter[instructionOffset].generalize(variables, true);
                    this.stacksAfter[instructionOffset].generalize(stack);
                }
                if (this.branchUnit.wasCalled()) {
                    int index;
                    InstructionOffsetValue instructionOffsetValue = this.branchTargetValues[instructionOffset] = this.branchTargetValues[instructionOffset] == null ? branchTargets : this.branchTargetValues[instructionOffset].generalize(branchTargets);
                    if (branchTargetCount == 0) break block21;
                    InstructionOffsetValue instructionOffsetValue2 = new InstructionOffsetValue(instructionOffset);
                    for (index = 0; index < branchTargetCount; ++index) {
                        int branchTarget = branchTargets.instructionOffset(index);
                        this.branchOriginValues[branchTarget] = this.branchOriginValues[branchTarget] == null ? instructionOffsetValue2 : this.branchOriginValues[branchTarget].generalize(instructionOffsetValue2);
                    }
                    if (branchTargetCount > 1) {
                        for (index = 0; index < branchTargetCount; ++index) {
                            this.pushInstructionBlock(new TracedVariables(variables), new TracedStack(stack), branchTargets.instructionOffset(index));
                        }
                        break block21;
                    }
                    instructionOffset = branchTargets.instructionOffset(0);
                } else {
                    instructionOffset += instruction.length(instructionOffset);
                }
                if (instruction.opcode != -88 && instruction.opcode != -55) continue;
                this.evaluateSubroutine(clazz, method, codeAttribute, variables, stack, instructionOffset);
                break block21;
            } while (instruction.opcode != -87);
            this.pushCallingInstructionBlock(new TracedVariables(variables), new TracedStack(stack), instructionOffset);
        }
    }

    private void evaluateSubroutine(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables, TracedStack stack, int subroutineStart) {
        int subroutineEnd = this.branchTargetFinder.subroutineEnd(subroutineStart);
        PartialEvaluator subroutinePartialEvaluator = new PartialEvaluator(this);
        subroutinePartialEvaluator.initializeArrays(codeAttribute);
        subroutinePartialEvaluator.evaluateInstructionBlockAndExceptionHandlers(clazz, method, codeAttribute, variables, stack, subroutineStart, subroutineEnd);
        this.generalize(subroutinePartialEvaluator, 0, codeAttribute.u4codeLength);
    }

    private void generalize(PartialEvaluator other, int codeStart, int codeEnd) {
        for (int offset = codeStart; offset < codeEnd; ++offset) {
            if (other.branchOriginValues[offset] != null) {
                InstructionOffsetValue instructionOffsetValue = this.branchOriginValues[offset] = this.branchOriginValues[offset] == null ? other.branchOriginValues[offset] : this.branchOriginValues[offset].generalize(other.branchOriginValues[offset]);
            }
            if (!other.isTraced(offset)) continue;
            if (other.branchTargetValues[offset] != null) {
                InstructionOffsetValue instructionOffsetValue = this.branchTargetValues[offset] = this.branchTargetValues[offset] == null ? other.branchTargetValues[offset] : this.branchTargetValues[offset].generalize(other.branchTargetValues[offset]);
            }
            if (this.evaluationCounts[offset] == 0) {
                this.variablesBefore[offset] = other.variablesBefore[offset];
                this.stacksBefore[offset] = other.stacksBefore[offset];
                this.variablesAfter[offset] = other.variablesAfter[offset];
                this.stacksAfter[offset] = other.stacksAfter[offset];
                this.generalizedContexts[offset] = other.generalizedContexts[offset];
                this.evaluationCounts[offset] = other.evaluationCounts[offset];
                continue;
            }
            this.variablesBefore[offset].generalize(other.variablesBefore[offset], false);
            this.stacksBefore[offset].generalize(other.stacksBefore[offset]);
            this.variablesAfter[offset].generalize(other.variablesAfter[offset], false);
            this.stacksAfter[offset].generalize(other.stacksAfter[offset]);
            int n = offset;
            this.evaluationCounts[n] = this.evaluationCounts[n] + other.evaluationCounts[offset];
        }
    }

    private void evaluateExceptionHandlers(Clazz clazz, Method method, CodeAttribute codeAttribute, int startOffset, int endOffset) {
        ExceptionHandlerFilter exceptionEvaluator = new ExceptionHandlerFilter(startOffset, endOffset, this);
        do {
            this.evaluateExceptions = false;
            codeAttribute.exceptionsAccept(clazz, method, startOffset, endOffset, exceptionEvaluator);
        } while (this.evaluateExceptions);
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        int startPC = exceptionInfo.u2startPC;
        int endPC = exceptionInfo.u2endPC;
        if (this.mayThrowExceptions(clazz, method, codeAttribute, startPC, endPC)) {
            int handlerPC = exceptionInfo.u2handlerPC;
            int catchType = exceptionInfo.u2catchType;
            TracedVariables variables = new TracedVariables(codeAttribute.u2maxLocals);
            TracedStack stack = new TracedStack(codeAttribute.u2maxStack);
            InstructionOffsetValue storeValue = new InstructionOffsetValue(handlerPC | 0x20000000);
            variables.setProducerValue(storeValue);
            stack.setProducerValue(storeValue);
            this.generalizeVariables(startPC, endPC, this.evaluateAllCode, variables);
            this.invocationUnit.enterExceptionHandler(clazz, method, codeAttribute, handlerPC, catchType, stack);
            int evaluationCount = this.evaluationCounts[handlerPC];
            this.evaluateInstructionBlock(clazz, method, codeAttribute, variables, stack, handlerPC);
            if (!this.evaluateExceptions) {
                this.evaluateExceptions = evaluationCount < this.evaluationCounts[handlerPC];
            }
        }
    }

    private void initializeArrays(CodeAttribute codeAttribute) {
        int newCodeLength = codeAttribute.u4codeLength;
        if (this.branchOriginValues.length < newCodeLength) {
            this.branchOriginValues = new InstructionOffsetValue[newCodeLength];
            this.branchTargetValues = new InstructionOffsetValue[newCodeLength];
            this.variablesBefore = new TracedVariables[newCodeLength];
            this.stacksBefore = new TracedStack[newCodeLength];
            this.variablesAfter = new TracedVariables[newCodeLength];
            this.stacksAfter = new TracedStack[newCodeLength];
            this.generalizedContexts = new boolean[newCodeLength];
            this.evaluationCounts = new int[newCodeLength];
        } else {
            int index;
            Arrays.fill(this.branchOriginValues, 0, this.codeLength, null);
            Arrays.fill(this.branchTargetValues, 0, this.codeLength, null);
            Arrays.fill(this.generalizedContexts, 0, this.codeLength, false);
            Arrays.fill(this.evaluationCounts, 0, this.codeLength, 0);
            for (index = 0; index < newCodeLength; ++index) {
                if (this.variablesBefore[index] != null) {
                    this.variablesBefore[index].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksBefore[index] != null) {
                    this.stacksBefore[index].reset(codeAttribute.u2maxStack);
                }
                if (this.variablesAfter[index] != null) {
                    this.variablesAfter[index].reset(codeAttribute.u2maxLocals);
                }
                if (this.stacksAfter[index] == null) continue;
                this.stacksAfter[index].reset(codeAttribute.u2maxStack);
            }
            for (index = newCodeLength; index < this.codeLength; ++index) {
                if (this.variablesBefore[index] != null) {
                    this.variablesBefore[index].reset(0);
                }
                if (this.stacksBefore[index] != null) {
                    this.stacksBefore[index].reset(0);
                }
                if (this.variablesAfter[index] != null) {
                    this.variablesAfter[index].reset(0);
                }
                if (this.stacksAfter[index] == null) continue;
                this.stacksAfter[index].reset(0);
            }
        }
        this.codeLength = newCodeLength;
    }

    private void initializeParameters(Clazz clazz, Method method, CodeAttribute codeAttribute, TracedVariables variables) {
        Variables parameters = new Variables(codeAttribute.u2maxLocals);
        this.invocationUnit.enterMethod(clazz, method, parameters);
        variables.initialize(parameters);
        for (int index = 0; index < parameters.size(); ++index) {
            InstructionOffsetValue producerValue = new InstructionOffsetValue(index | 0x1000000);
            variables.setProducerValue(index, producerValue);
        }
    }

    private boolean mayThrowExceptions(Clazz clazz, Method method, CodeAttribute codeAttribute, int startOffset, int endOffset) {
        for (int index = startOffset; index < endOffset; ++index) {
            if (!this.isTraced(index) || !this.evaluateAllCode && !InstructionFactory.create(codeAttribute.code, index).mayInstanceThrowExceptions(clazz)) continue;
            return true;
        }
        return false;
    }

    private void generalizeVariables(int startOffset, int endOffset, boolean includeAfterLastInstruction, TracedVariables generalizedVariables) {
        boolean first = true;
        int lastIndex = -1;
        for (int index = startOffset; index < endOffset; ++index) {
            if (!this.isTraced(index)) continue;
            TracedVariables tracedVariables = this.variablesBefore[index];
            if (first) {
                generalizedVariables.initialize(tracedVariables);
                first = false;
            } else {
                generalizedVariables.generalize(tracedVariables, false);
            }
            lastIndex = index;
        }
        if (includeAfterLastInstruction && lastIndex >= 0) {
            TracedVariables tracedVariables = this.variablesAfter[lastIndex];
            if (first) {
                generalizedVariables.initialize(tracedVariables);
            } else {
                generalizedVariables.generalize(tracedVariables, false);
            }
        }
        if (first) {
            generalizedVariables.reset(generalizedVariables.size());
        }
    }

    public PartialEvaluator stopAnalysisAfterNEvaluations(int stopAnalysisAfterNEvaluations) {
        this.stopAnalysisAfterNEvaluations = stopAnalysisAfterNEvaluations;
        return this;
    }

    private class MyTracedInstructionFilter
    implements InstructionVisitor {
        private final boolean traced;
        private final InstructionVisitor instructionVisitor;

        public MyTracedInstructionFilter(boolean traced, InstructionVisitor instructionVisitor) {
            this.traced = traced;
            this.instructionVisitor = instructionVisitor;
        }

        @Override
        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitSimpleInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
            }
        }

        @Override
        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, offset, variableInstruction);
            }
        }

        @Override
        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, constantInstruction);
            }
        }

        @Override
        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitBranchInstruction(clazz, method, codeAttribute, offset, branchInstruction);
            }
        }

        @Override
        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitTableSwitchInstruction(clazz, method, codeAttribute, offset, tableSwitchInstruction);
            }
        }

        @Override
        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
            if (this.shouldVisit(offset)) {
                this.instructionVisitor.visitLookUpSwitchInstruction(clazz, method, codeAttribute, offset, lookUpSwitchInstruction);
            }
        }

        private boolean shouldVisit(int offset) {
            return PartialEvaluator.this.isTraced(offset) == this.traced;
        }
    }

    private static class MyInstructionBlock {
        private final TracedVariables variables;
        private final TracedStack stack;
        private final int startOffset;

        private MyInstructionBlock(TracedVariables variables, TracedStack stack, int startOffset) {
            this.variables = variables;
            this.stack = stack;
            this.startOffset = startOffset;
        }
    }

    public static class Builder {
        private ValueFactory valueFactory;
        private InvocationUnit invocationUnit;
        private boolean evaluateAllCode = true;
        private InstructionVisitor extraInstructionVisitor;
        private BasicBranchUnit branchUnit;
        private BranchTargetFinder branchTargetFinder;
        private Stack<MyInstructionBlock> callingInstructionBlockStack;
        private int stopAnalysisAfterNEvaluations = -1;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public PartialEvaluator build() {
            return new PartialEvaluator(this);
        }

        public Builder setValueFactory(ValueFactory valueFactory) {
            this.valueFactory = valueFactory;
            return this;
        }

        public Builder setInvocationUnit(InvocationUnit invocationUnit) {
            this.invocationUnit = invocationUnit;
            return this;
        }

        public Builder setEvaluateAllCode(boolean evaluateAllCode) {
            this.evaluateAllCode = evaluateAllCode;
            return this;
        }

        public Builder setExtraInstructionVisitor(InstructionVisitor extraInstructionVisitor) {
            this.extraInstructionVisitor = extraInstructionVisitor;
            return this;
        }

        public Builder setBranchUnit(BasicBranchUnit branchUnit) {
            this.branchUnit = branchUnit;
            return this;
        }

        public Builder setBranchTargetFinder(BranchTargetFinder branchTargetFinder) {
            this.branchTargetFinder = branchTargetFinder;
            return this;
        }

        public Builder setCallingInstructionBlockStack(Stack<MyInstructionBlock> callingInstructionBlockStack) {
            this.callingInstructionBlockStack = callingInstructionBlockStack;
            return this;
        }

        public Builder stopAnalysisAfterNEvaluations(int stopAnalysisAfterNEvaluations) {
            this.stopAnalysisAfterNEvaluations = stopAnalysisAfterNEvaluations;
            return this;
        }
    }
}

