/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.util.Arrays;
import proguard.evaluation.value.Category1Value;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TopValue;
import proguard.evaluation.value.Value;

public class Stack {
    private static final TopValue TOP_VALUE = new TopValue();
    protected Value[] values;
    protected int currentSize;
    protected int actualMaxSize;

    public Stack(int maxSize) {
        this.values = new Value[maxSize];
    }

    public Stack(Stack stack) {
        this(stack.values.length);
        this.copy(stack);
    }

    public int getActualMaxSize() {
        return this.actualMaxSize;
    }

    public void reset(int maxSize) {
        if (this.values.length < maxSize) {
            this.values = new Value[maxSize];
        }
        this.clear();
        this.actualMaxSize = 0;
    }

    public void copy(Stack other) {
        if (this.values.length < other.values.length) {
            this.values = new Value[other.values.length];
        }
        System.arraycopy(other.values, 0, this.values, 0, other.currentSize);
        this.currentSize = other.currentSize;
        this.actualMaxSize = other.actualMaxSize;
    }

    public boolean generalize(Stack other) {
        if (this.currentSize != other.currentSize) {
            throw new IllegalArgumentException("Stacks have different current sizes [" + this.currentSize + "] and [" + other.currentSize + "]");
        }
        boolean changed = false;
        for (int index = 0; index < this.currentSize; ++index) {
            Value thisValue = this.values[index];
            if (thisValue == null) continue;
            Value newValue = null;
            Value otherValue = other.values[index];
            if (otherValue != null) {
                newValue = thisValue.generalize(otherValue);
            }
            changed = changed || !thisValue.equals(newValue);
            this.values[index] = newValue;
        }
        if (this.actualMaxSize < other.actualMaxSize) {
            this.actualMaxSize = other.actualMaxSize;
        }
        return changed;
    }

    public void clear() {
        Arrays.fill(this.values, 0, this.currentSize, null);
        this.currentSize = 0;
    }

    public int size() {
        return this.currentSize;
    }

    public Value getBottom(int index) {
        return this.values[index];
    }

    public void setBottom(int index, Value value) {
        this.values[index] = value;
    }

    public Value getTop(int index) {
        return this.values[this.currentSize - index - 1];
    }

    public void setTop(int index, Value value) {
        this.values[this.currentSize - index - 1] = value;
    }

    public void removeTop(int index) {
        System.arraycopy(this.values, this.currentSize - index, this.values, this.currentSize - index - 1, index);
        --this.currentSize;
    }

    public void push(Value value) {
        if (value.isCategory2()) {
            this.values[this.currentSize++] = TOP_VALUE;
        }
        this.values[this.currentSize++] = value;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public Value pop() {
        Value value = this.values[--this.currentSize];
        this.values[this.currentSize] = null;
        if (value.isCategory2()) {
            this.values[--this.currentSize] = null;
        }
        return value;
    }

    public IntegerValue ipop() {
        return this.pop().integerValue();
    }

    public LongValue lpop() {
        return this.pop().longValue();
    }

    public FloatValue fpop() {
        return this.pop().floatValue();
    }

    public DoubleValue dpop() {
        return this.pop().doubleValue();
    }

    public ReferenceValue apop() {
        return this.pop().referenceValue();
    }

    public InstructionOffsetValue opop() {
        return this.pop().instructionOffsetValue();
    }

    public void pop1() {
        this.values[--this.currentSize] = null;
    }

    public void pop2() {
        this.values[--this.currentSize] = null;
        this.values[--this.currentSize] = null;
    }

    public void dup() {
        this.values[this.currentSize] = this.values[this.currentSize - 1].category1Value();
        ++this.currentSize;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup_x1() {
        this.values[this.currentSize] = this.values[this.currentSize - 1].category1Value();
        this.values[this.currentSize - 1] = this.values[this.currentSize - 2].category1Value();
        this.values[this.currentSize - 2] = this.values[this.currentSize];
        ++this.currentSize;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup_x2() {
        this.values[this.currentSize] = this.values[this.currentSize - 1].category1Value();
        this.values[this.currentSize - 1] = this.values[this.currentSize - 2];
        this.values[this.currentSize - 2] = this.values[this.currentSize - 3];
        this.values[this.currentSize - 3] = this.values[this.currentSize];
        ++this.currentSize;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup2() {
        this.values[this.currentSize] = this.values[this.currentSize - 2];
        this.values[this.currentSize + 1] = this.values[this.currentSize - 1];
        this.currentSize += 2;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup2_x1() {
        this.values[this.currentSize + 1] = this.values[this.currentSize - 1];
        this.values[this.currentSize] = this.values[this.currentSize - 2];
        this.values[this.currentSize - 1] = this.values[this.currentSize - 3];
        this.values[this.currentSize - 2] = this.values[this.currentSize + 1];
        this.values[this.currentSize - 3] = this.values[this.currentSize];
        this.currentSize += 2;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void dup2_x2() {
        this.values[this.currentSize + 1] = this.values[this.currentSize - 1];
        this.values[this.currentSize] = this.values[this.currentSize - 2];
        this.values[this.currentSize - 1] = this.values[this.currentSize - 3];
        this.values[this.currentSize - 2] = this.values[this.currentSize - 4];
        this.values[this.currentSize - 3] = this.values[this.currentSize + 1];
        this.values[this.currentSize - 4] = this.values[this.currentSize];
        this.currentSize += 2;
        if (this.actualMaxSize < this.currentSize) {
            this.actualMaxSize = this.currentSize;
        }
    }

    public void swap() {
        Category1Value value1 = this.values[this.currentSize - 1].category1Value();
        Category1Value value2 = this.values[this.currentSize - 2].category1Value();
        this.values[this.currentSize - 1] = value2;
        this.values[this.currentSize - 2] = value1;
    }

    public void replaceReferences(Value toReplace, Value replacement) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != toReplace) continue;
            this.values[i] = replacement;
        }
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Stack other = (Stack)object;
        if (this.currentSize != other.currentSize) {
            return false;
        }
        for (int index = 0; index < this.currentSize; ++index) {
            Value thisValue = this.values[index];
            Value otherValue = other.values[index];
            if (!(thisValue == null ? otherValue != null : !thisValue.equals(otherValue))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.currentSize;
        for (int index = 0; index < this.currentSize; ++index) {
            Value value = this.values[index];
            if (value == null) continue;
            hashCode ^= value.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < this.currentSize; ++index) {
            Value value = this.values[index];
            buffer = buffer.append('[').append(value == null ? "empty" : value.toString()).append(']');
        }
        return buffer.toString();
    }
}

