/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class ReferenceTracingValueFactory
implements InstructionVisitor,
ValueFactory {
    private final ValueFactory valueFactory;
    private final boolean preserveTraceValueOnCasts;
    private Value traceValue;

    public ReferenceTracingValueFactory(ValueFactory valueFactory) {
        this(valueFactory, true);
    }

    public ReferenceTracingValueFactory(ValueFactory valueFactory, boolean preserveTraceValueOnCasts) {
        this.valueFactory = valueFactory;
        this.preserveTraceValueOnCasts = preserveTraceValueOnCasts;
    }

    public void setTraceValue(Value traceValue) {
        this.traceValue = traceValue;
    }

    public TracedReferenceValue cast(TracedReferenceValue referenceValue, String type, Clazz referencedClass, boolean alwaysCast) {
        ReferenceValue castValue = referenceValue.getReferenceValue().cast(type, referencedClass, this.valueFactory, alwaysCast);
        return new TracedReferenceValue(castValue, this.preserveTraceValueOnCasts ? referenceValue.getTraceValue() : this.traceValue);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.traceValue = null;
    }

    @Override
    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case -68: 
            case -65: 
            case 1: {
                this.traceValue = new InstructionOffsetValue(offset | 0x8000000);
                break;
            }
            case 50: {
                this.traceValue = new InstructionOffsetValue(offset);
                break;
            }
            default: {
                this.traceValue = null;
            }
        }
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -69: 
            case -67: 
            case -59: 
            case 18: 
            case 19: {
                this.traceValue = new InstructionOffsetValue(offset | 0x8000000);
                break;
            }
            case -78: 
            case -76: {
                this.traceValue = new InstructionOffsetValue(offset | 0x4000000);
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.traceValue = new InstructionOffsetValue(offset | 0x2000000);
                break;
            }
            case -64: {
                this.traceValue = new InstructionOffsetValue(offset | 0x10000000);
                break;
            }
            default: {
                this.traceValue = null;
            }
        }
    }

    @Override
    public Value createValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        return this.trace(this.valueFactory.createValue(type, referencedClass, mayBeExtension, mayBeNull));
    }

    @Override
    public IntegerValue createIntegerValue() {
        return this.valueFactory.createIntegerValue();
    }

    @Override
    public IntegerValue createIntegerValue(int value) {
        return this.valueFactory.createIntegerValue(value);
    }

    @Override
    public IntegerValue createIntegerValue(int min, int max) {
        return this.valueFactory.createIntegerValue(min, max);
    }

    @Override
    public LongValue createLongValue() {
        return this.valueFactory.createLongValue();
    }

    @Override
    public LongValue createLongValue(long value) {
        return this.valueFactory.createLongValue(value);
    }

    @Override
    public FloatValue createFloatValue() {
        return this.valueFactory.createFloatValue();
    }

    @Override
    public FloatValue createFloatValue(float value) {
        return this.valueFactory.createFloatValue(value);
    }

    @Override
    public DoubleValue createDoubleValue() {
        return this.valueFactory.createDoubleValue();
    }

    @Override
    public DoubleValue createDoubleValue(double value) {
        return this.valueFactory.createDoubleValue(value);
    }

    @Override
    public ReferenceValue createReferenceValue() {
        return this.trace(this.valueFactory.createReferenceValue());
    }

    @Override
    public ReferenceValue createReferenceValueNull() {
        return this.trace(this.valueFactory.createReferenceValueNull());
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull) {
        return this.trace(this.valueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull));
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object value) {
        return this.trace(this.valueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, value));
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset) {
        return this.trace(this.valueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull));
    }

    @Override
    public ReferenceValue createReferenceValue(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Clazz creationClass, Method creationMethod, int creationOffset, Object value) {
        return this.trace(this.valueFactory.createReferenceValue(type, referencedClass, mayBeExtension, mayBeNull, value));
    }

    @Override
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id) {
        return this.trace(this.valueFactory.createReferenceValueForId(type, referencedClass, mayBeExtension, mayBeNull, id));
    }

    @Override
    public ReferenceValue createReferenceValueForId(String type, Clazz referencedClass, boolean mayBeExtension, boolean mayBeNull, Object id, Object value) {
        return this.trace(this.valueFactory.createReferenceValueForId(type, referencedClass, mayBeExtension, mayBeNull, id, value));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength) {
        return this.trace(this.valueFactory.createArrayReferenceValue(type, referencedClass, arrayLength));
    }

    @Override
    public ReferenceValue createArrayReferenceValue(String type, Clazz referencedClass, IntegerValue arrayLength, Value elementValue) {
        return this.trace(this.valueFactory.createArrayReferenceValue(type, referencedClass, arrayLength, elementValue));
    }

    public Value trace(Value value) {
        return value.computationalType() == 5 ? this.trace(value.referenceValue()) : value;
    }

    public ReferenceValue trace(ReferenceValue referenceValue) {
        return this.traceValue != null ? new TracedReferenceValue(referenceValue, this.traceValue) : referenceValue;
    }
}

