/*
 * Decompiled with CFR 0.152.
 */
package proguard.testutils;

import com.tschuchort.compiletesting.KotlinCompilation;
import io.kotest.common.SoftDeprecated;
import io.kotest.core.annotation.AutoScan;
import io.kotest.core.listeners.TestListener;
import io.kotest.core.spec.Spec;
import io.kotest.core.test.TestCase;
import io.kotest.core.test.TestResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.io.ClassFilter;
import proguard.io.ClassReader;
import proguard.io.DataEntry;
import proguard.io.DataEntryReader;
import proguard.io.FileDataEntry;
import proguard.io.JarReader;
import proguard.testutils.ClassPoolBuilder;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u001f\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00012\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0086\u0002J\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lproguard/testutils/LibraryClassPoolBuilder;", "", "compiler", "Lcom/tschuchort/compiletesting/KotlinCompilation;", "(Lcom/tschuchort/compiletesting/KotlinCompilation;)V", "getJavaRuntimeClassPool", "Lproguard/classfile/ClassPool;", "jdkHome", "Ljava/io/File;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "fromFile", "", "file", "Companion", "proguard-core_testFixtures"})
@SourceDebugExtension(value={"SMAP\nClassPoolBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPoolBuilder.kt\nproguard/testutils/LibraryClassPoolBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1#2:243\n3792#3:244\n4307#3,2:245\n1855#4,2:247\n*S KotlinDebug\n*F\n+ 1 ClassPoolBuilder.kt\nproguard/testutils/LibraryClassPoolBuilder\n*L\n192#1:244\n192#1:245,2\n194#1:247,2\n*E\n"})
final class LibraryClassPoolBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KotlinCompilation compiler;
    @NotNull
    private static final Map<Integer, ClassPool> libraryClassPools = new LinkedHashMap();

    public LibraryClassPoolBuilder(@NotNull KotlinCompilation compiler) {
        Intrinsics.checkNotNullParameter((Object)compiler, (String)"compiler");
        this.compiler = compiler;
    }

    @NotNull
    public final ClassPool getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        Object[] objectArray = new Object[]{this.compiler.getJdkHome(), this.compiler.getKotlinStdLibJdkJar(), this.compiler.getKotlinStdLibJdkJar()};
        int key = Objects.hash(objectArray);
        if (!libraryClassPools.containsKey(key)) {
            File it;
            ClassPool libraryClassPool = this.getJavaRuntimeClassPool(this.compiler.getJdkHome());
            File file = this.compiler.getKotlinStdLibJar();
            if (file != null) {
                it = file;
                boolean bl = false;
                this.fromFile(libraryClassPool, it);
            }
            File file2 = this.compiler.getKotlinReflectJar();
            if (file2 != null) {
                it = file2;
                boolean bl = false;
                this.fromFile(libraryClassPool, it);
            }
            Integer n = key;
            libraryClassPools.put(n, libraryClassPool);
            ClassPoolBuilder.Companion.initialize(new ClassPool(), libraryClassPool, true);
        }
        ClassPool classPool = libraryClassPools.get(key);
        Intrinsics.checkNotNull((Object)classPool);
        return classPool;
    }

    /*
     * WARNING - void declaration
     */
    private final ClassPool getJavaRuntimeClassPool(File jdkHome) {
        ClassPool libraryClassPool = new ClassPool();
        if (jdkHome != null && jdkHome.exists()) {
            if (FilesKt.resolve((File)jdkHome, (String)"jmods").exists()) {
                void $this$filterTo$iv$iv;
                File[] fileArray = FilesKt.resolve((File)jdkHome, (String)"jmods").listFiles();
                Intrinsics.checkNotNullExpressionValue((Object)fileArray, (String)"jdkHome.resolve(\"jmods\").listFiles()");
                Object[] $this$filter$iv = fileArray;
                boolean $i$f$filter = false;
                Object[] objectArray = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (void element$iv$iv : $this$filterTo$iv$iv) {
                    File it = (File)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"java.base.jmod")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.fromFile(libraryClassPool, it);
                }
            } else {
                File runtimeJar = FilesKt.resolve((File)jdkHome, (String)"jre").exists() ? FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)jdkHome, (String)"jre"), (String)"lib"), (String)"rt.jar") : FilesKt.resolve((File)FilesKt.resolve((File)jdkHome, (String)"lib"), (String)"rt.jar");
                this.fromFile(libraryClassPool, runtimeJar);
            }
        }
        return libraryClassPool;
    }

    private final void fromFile(ClassPool $this$fromFile, File file) {
        DataEntryReader classReader = (DataEntryReader)new ClassReader(true, false, false, true, true, null, (ClassVisitor)new ClassPoolFiller($this$fromFile));
        new JarReader((DataEntryReader)new ClassFilter(classReader)).read((DataEntry)new FileDataEntry(file));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lproguard/testutils/LibraryClassPoolBuilder$Companion;", "", "()V", "libraryClassPools", "", "", "Lproguard/classfile/ClassPool;", "LibraryClassPoolProcessingInfoCleaningListener", "proguard-core_testFixtures"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @AutoScan
        @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\b"}, d2={"Lproguard/testutils/LibraryClassPoolBuilder$Companion$LibraryClassPoolProcessingInfoCleaningListener;", "Lio/kotest/core/listeners/TestListener;", "()V", "beforeTest", "", "testCase", "Lio/kotest/core/test/TestCase;", "(Lio/kotest/core/test/TestCase;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "proguard-core_testFixtures"})
        @SourceDebugExtension(value={"SMAP\nClassPoolBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassPoolBuilder.kt\nproguard/testutils/LibraryClassPoolBuilder$Companion$LibraryClassPoolProcessingInfoCleaningListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,242:1\n1855#2,2:243\n*S KotlinDebug\n*F\n+ 1 ClassPoolBuilder.kt\nproguard/testutils/LibraryClassPoolBuilder$Companion$LibraryClassPoolProcessingInfoCleaningListener\n*L\n232#1:243,2\n*E\n"})
        public static final class LibraryClassPoolProcessingInfoCleaningListener
        implements TestListener {
            @NotNull
            public static final LibraryClassPoolProcessingInfoCleaningListener INSTANCE = new LibraryClassPoolProcessingInfoCleaningListener();

            private LibraryClassPoolProcessingInfoCleaningListener() {
            }

            @Nullable
            public Object beforeTest(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
                Iterable $this$forEach$iv = libraryClassPools.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ClassPool it = (ClassPool)element$iv;
                    boolean bl = false;
                    it.classesAccept(LibraryClassPoolProcessingInfoCleaningListener::beforeTest$lambda$1$lambda$0);
                }
                return Unit.INSTANCE;
            }

            @NotNull
            public String getName() {
                return TestListener.DefaultImpls.getName((TestListener)this);
            }

            @Nullable
            public Object afterAny(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.afterAny((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
            }

            @Nullable
            public Object afterContainer(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.afterContainer((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
            }

            @Nullable
            public Object afterEach(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.afterEach((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
            }

            @Nullable
            public Object afterInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.afterInvocation((TestListener)this, (TestCase)testCase, (int)iteration, $completion);
            }

            @Nullable
            public Object afterSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.afterSpec((TestListener)this, (Spec)spec, $completion);
            }

            @SoftDeprecated(message="Use afterAny")
            @Nullable
            public Object afterTest(@NotNull TestCase testCase, @NotNull TestResult result, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.afterTest((TestListener)this, (TestCase)testCase, (TestResult)result, $completion);
            }

            @Nullable
            public Object beforeAny(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.beforeAny((TestListener)this, (TestCase)testCase, $completion);
            }

            @Nullable
            public Object beforeContainer(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.beforeContainer((TestListener)this, (TestCase)testCase, $completion);
            }

            @Nullable
            public Object beforeEach(@NotNull TestCase testCase, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.beforeEach((TestListener)this, (TestCase)testCase, $completion);
            }

            @Nullable
            public Object beforeInvocation(@NotNull TestCase testCase, int iteration, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.beforeInvocation((TestListener)this, (TestCase)testCase, (int)iteration, $completion);
            }

            @Nullable
            public Object beforeSpec(@NotNull Spec spec, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.beforeSpec((TestListener)this, (Spec)spec, $completion);
            }

            @Nullable
            public Object finalizeSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Map<TestCase, ? extends TestResult> results, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.finalizeSpec((TestListener)this, kclass, results, $completion);
            }

            @Nullable
            public Object prepareSpec(@NotNull KClass<? extends Spec> kclass, @NotNull Continuation<? super Unit> $completion) {
                return TestListener.DefaultImpls.prepareSpec((TestListener)this, kclass, $completion);
            }

            private static final void beforeTest$lambda$1$lambda$0(Clazz clazz) {
                clazz.setProcessingInfo(null);
                clazz.setProcessingFlags(0);
            }
        }
    }
}

