/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMember;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;

public interface MemberVisitor {
    default public void visitAnyMember(Clazz clazz, Member member) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support " + member.getClass().getName());
    }

    default public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        this.visitAnyMember(programClass, programMember);
    }

    default public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.visitProgramMember(programClass, programField);
    }

    default public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.visitProgramMember(programClass, programMethod);
    }

    default public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        this.visitAnyMember(libraryClass, libraryMember);
    }

    default public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.visitLibraryMember(libraryClass, libraryField);
    }

    default public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.visitLibraryMember(libraryClass, libraryMethod);
    }
}

