/*
 * ProGuardCORE -- library to process Java bytecode.
 *
 * Copyright (c) 2002-2020 Guardsquare NV
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package proguard.classfile.kotlin;

import static proguard.classfile.kotlin.KotlinConstants.METADATA_KIND_MULTI_FILE_CLASS_FACADE;

import java.util.*;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.visitor.*;

public class KotlinMultiFileFacadeKindMetadata extends KotlinMetadata {
  public List<String> partClassNames;
  public List<Clazz> referencedPartClasses;

  public KotlinMultiFileFacadeKindMetadata(int[] mv, String[] d1, int xi, String xs, String pn) {
    super(METADATA_KIND_MULTI_FILE_CLASS_FACADE, mv, xi, xs, pn);

    this.partClassNames = new ArrayList<>(Arrays.asList(d1));
  }

  @Override
  public void accept(Clazz clazz, KotlinMetadataVisitor kotlinMetadataVisitor) {
    kotlinMetadataVisitor.visitKotlinMultiFileFacadeMetadata(clazz, this);
  }

  // Implementations for Object.
  @Override
  public String toString() {
    return "Kotlin multi-file facade";
  }
}
