/*
 * ProGuardCORE -- library to process Java bytecode.
 *
 * Copyright (c) 2002-2020 Guardsquare NV
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package proguard.classfile.visitor;

import proguard.classfile.*;

/**
 * This {@link ClassVisitor} lets a given {@link MemberVisitor} visit all {@link Method} instances
 * of the classes it visits.
 *
 * @author Eric Lafortune
 */
public class AllMethodVisitor implements ClassVisitor {
  private final MemberVisitor memberVisitor;

  public AllMethodVisitor(MemberVisitor memberVisitor) {
    this.memberVisitor = memberVisitor;
  }

  // Implementations for ClassVisitor.

  @Override
  public void visitAnyClass(Clazz clazz) {
    clazz.methodsAccept(memberVisitor);
  }
}
