/*
 * Decompiled with CFR 0.152.
 */
package proguard.testutils;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0003\u00a8\u0006\u0006"}, d2={"isClassFile", "", "Ljava/io/File;", "Ljava/nio/file/Path;", "isJavaFile", "isKotlinFile", "proguard-core_testFixtures"})
public final class FileUtilKt {
    public static final boolean isJavaFile(@NotNull File $this$isJavaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFile, (String)"<this>");
        String string = $this$isJavaFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        return StringsKt.endsWith$default((String)string, (String)".java", (boolean)false, (int)2, null);
    }

    public static final boolean isClassFile(@NotNull File $this$isClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassFile, (String)"<this>");
        String string = $this$isClassFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        return StringsKt.endsWith$default((String)string, (String)".class", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFile(@NotNull File $this$isKotlinFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFile, (String)"<this>");
        String string = $this$isKotlinFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.name");
        if (StringsKt.endsWith$default((String)string, (String)".kt", (boolean)false, (int)2, null)) return true;
        String string2 = $this$isKotlinFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.name");
        if (!StringsKt.endsWith$default((String)string2, (String)".kts", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean isJavaFile(@NotNull Path $this$isJavaFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isJavaFile, (String)"<this>");
        File file = $this$isJavaFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"this.toFile()");
        return FileUtilKt.isJavaFile(file);
    }

    public static final boolean isClassFile(@NotNull Path $this$isClassFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isClassFile, (String)"<this>");
        File file = $this$isClassFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"this.toFile()");
        return FileUtilKt.isClassFile(file);
    }

    public static final boolean isKotlinFile(@NotNull Path $this$isKotlinFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isKotlinFile, (String)"<this>");
        File file = $this$isKotlinFile.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"this.toFile()");
        return FileUtilKt.isKotlinFile(file);
    }
}

