/*
 * Decompiled with CFR 0.152.
 */
package proguard.testutils;

import com.tschuchort.compiletesting.SourceFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import proguard.testutils.FileSource;
import proguard.testutils.FileUtilKt;
import proguard.testutils.JavaSource;
import proguard.testutils.KotlinSource;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u00a8\u0006\u0006"}, d2={"Lproguard/testutils/TestSource;", "", "()V", "asSourceFile", "Lcom/tschuchort/compiletesting/SourceFile;", "Companion", "proguard-core_testFixtures"})
public abstract class TestSource {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public abstract SourceFile asSourceFile();

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lproguard/testutils/TestSource$Companion;", "", "()V", "fromFile", "Lproguard/testutils/TestSource;", "file", "Ljava/io/File;", "proguard-core_testFixtures"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TestSource fromFile(@NotNull File file) {
            TestSource testSource;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (FileUtilKt.isJavaFile(file)) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                testSource = new JavaSource(string, FilesKt.readText$default((File)file, null, (int)1, null));
            } else if (FileUtilKt.isKotlinFile(file)) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                testSource = new KotlinSource(string, FilesKt.readText$default((File)file, null, (int)1, null));
            } else {
                testSource = new FileSource(file);
            }
            return testSource;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

