/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import proguard.analysis.cpa.algorithms.CpaAlgorithm;
import proguard.analysis.cpa.bam.BamCacheImpl;
import proguard.analysis.cpa.bam.BamCpa;
import proguard.analysis.cpa.bam.CpaWithBamOperators;
import proguard.analysis.cpa.bam.NoOpRebuildOperator;
import proguard.analysis.cpa.defaults.BreadthFirstWaitlist;
import proguard.analysis.cpa.defaults.HashMapAbstractState;
import proguard.analysis.cpa.defaults.NeverAbortOperator;
import proguard.analysis.cpa.defaults.ProgramLocationDependentReachedSet;
import proguard.analysis.cpa.defaults.SetAbstractState;
import proguard.analysis.cpa.interfaces.AbortOperator;
import proguard.analysis.cpa.jvm.cfa.JvmCfa;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.memory.JvmMemoryLocationCpa;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintCpa;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSink;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintSource;
import proguard.analysis.cpa.jvm.domain.taint.JvmTaintTransformer;
import proguard.analysis.cpa.jvm.domain.taint.TaintExpandOperator;
import proguard.analysis.cpa.jvm.domain.taint.TaintReduceOperator;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmForgetfulHeapAbstractState;
import proguard.analysis.cpa.jvm.witness.JvmMemoryLocation;
import proguard.analysis.cpa.util.TaintAnalyzerResult;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodSignature;
import proguard.classfile.Signature;

public class TaintAnalyzer {
    private final Function<MethodSignature, BamCpa<SetAbstractState<JvmTaintSource>>> cpaCreator;
    private final Function<MethodSignature, JvmAbstractState<SetAbstractState<JvmTaintSource>>> initialStateCreator;
    private final Function<BamCpa<SetAbstractState<JvmTaintSource>>, JvmMemoryLocationCpa<SetAbstractState<JvmTaintSource>>> memoryCpaCreator;
    private final Collection<? extends JvmTaintSink> taintSinks;

    private TaintAnalyzer(Function<MethodSignature, BamCpa<SetAbstractState<JvmTaintSource>>> cpaCreator, Function<MethodSignature, JvmAbstractState<SetAbstractState<JvmTaintSource>>> initialStateCreator, Function<BamCpa<SetAbstractState<JvmTaintSource>>, JvmMemoryLocationCpa<SetAbstractState<JvmTaintSource>>> memoryCpaCreator, Collection<? extends JvmTaintSink> taintSinks) {
        this.cpaCreator = cpaCreator;
        this.initialStateCreator = initialStateCreator;
        this.memoryCpaCreator = memoryCpaCreator;
        this.taintSinks = taintSinks;
    }

    public TaintAnalyzerResult analyze(MethodSignature mainSignature) {
        BamCpa<SetAbstractState<JvmTaintSource>> taintCpa = this.cpaCreator.apply(mainSignature);
        CpaAlgorithm<SetAbstractState<JvmTaintSource>> cpaAlgorithm = new CpaAlgorithm<SetAbstractState<JvmTaintSource>>(taintCpa);
        BreadthFirstWaitlist<JvmAbstractState<SetAbstractState<JvmTaintSource>>> waitList = new BreadthFirstWaitlist<JvmAbstractState<SetAbstractState<JvmTaintSource>>>();
        ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>> reachedSet = new ProgramLocationDependentReachedSet<JvmAbstractState<SetAbstractState<JvmTaintSource>>>();
        JvmAbstractState<SetAbstractState<JvmTaintSource>> initialState = this.initialStateCreator.apply(mainSignature);
        waitList.add(initialState);
        reachedSet.add(initialState);
        cpaAlgorithm.run(reachedSet, waitList);
        return new TaintAnalyzerResult(taintCpa, reachedSet, this.taintSinks, this.memoryCpaCreator.apply(taintCpa));
    }

    public static class Builder {
        private final JvmCfa cfa;
        private final Set<? extends JvmTaintSource> taintSources;
        private final Set<? extends JvmTaintSink> taintSinks;
        private int maxCallStackDepth = 10;
        private AbortOperator abortOperator = NeverAbortOperator.INSTANCE;
        private AbortOperator memoryLocationAbortOperator = NeverAbortOperator.INSTANCE;
        private Map<MethodSignature, JvmTaintTransformer> taintTransformers = Collections.emptyMap();
        private Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations = Collections.emptyMap();

        public Builder(JvmCfa cfa, Set<? extends JvmTaintSource> taintSources, Set<? extends JvmTaintSink> taintSinks) {
            this.cfa = cfa;
            this.taintSources = taintSources;
            this.taintSinks = taintSinks;
        }

        public TaintAnalyzer build() {
            Map<Signature, Set<JvmTaintSource>> sourcesMap = JvmTaintCpa.createSourcesMap(this.taintSources);
            JvmTaintCpa intraproceduralCpa = new JvmTaintCpa(sourcesMap, this.taintTransformers, this.extraTaintPropagationLocations, this.abortOperator);
            boolean reduceHeap = false;
            CpaWithBamOperators<SetAbstractState<JvmTaintSource>> interproceduralCpa = new CpaWithBamOperators<SetAbstractState<JvmTaintSource>>(intraproceduralCpa, new TaintReduceOperator(reduceHeap, sourcesMap), new TaintExpandOperator(this.cfa, sourcesMap, reduceHeap), new NoOpRebuildOperator());
            BamCacheImpl cache = new BamCacheImpl();
            return new TaintAnalyzer(mainMethodSignature -> new BamCpa(interproceduralCpa, this.cfa, (MethodSignature)mainMethodSignature, cache, this.maxCallStackDepth), mainMethodSignature -> new JvmAbstractState((JvmCfaNode)this.cfa.getFunctionEntryNode(mainMethodSignature), new JvmFrameAbstractState(), new JvmForgetfulHeapAbstractState(SetAbstractState.bottom()), new HashMapAbstractState()), taintBamCpa -> new JvmMemoryLocationCpa(SetAbstractState.bottom(), taintBamCpa, this.extraTaintPropagationLocations, this.memoryLocationAbortOperator), this.taintSinks);
        }

        public Builder setMaxCallStackDepth(int maxCallStackDepth) {
            this.maxCallStackDepth = maxCallStackDepth;
            return this;
        }

        public Builder setAbortOperator(AbortOperator abortOperator) {
            this.abortOperator = abortOperator;
            return this;
        }

        public Builder setMemoryLocationAbortOperator(AbortOperator memoryLocationAbortOperator) {
            this.memoryLocationAbortOperator = memoryLocationAbortOperator;
            return this;
        }

        public Builder setTaintTransformers(Map<MethodSignature, JvmTaintTransformer> taintTransformers) {
            this.taintTransformers = taintTransformers;
            return this;
        }

        public Builder setExtraTaintPropagationLocations(Map<Call, Set<JvmMemoryLocation>> extraTaintPropagationLocations) {
            this.extraTaintPropagationLocations = extraTaintPropagationLocations;
            return this;
        }
    }
}

