/*
 * Decompiled with CFR 0.152.
 */
package proguard.testutils.cpa;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.transfer.JvmTransferRelation;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.UnknownValue;
import proguard.evaluation.value.Value;
import proguard.testutils.cpa.ExpressionAbstractState;
import proguard.testutils.cpa.InstructionExpression;
import proguard.testutils.cpa.MethodExpression;
import proguard.testutils.cpa.ValueExpression;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J,\u0010 \u001a\u00020!2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016\u00a8\u0006%"}, d2={"Lproguard/testutils/cpa/ExpressionTransferRelation;", "Lproguard/analysis/cpa/jvm/transfer/JvmTransferRelation;", "Lproguard/testutils/cpa/ExpressionAbstractState;", "()V", "calculateArithmeticInstruction", "instruction", "Lproguard/classfile/instruction/Instruction;", "operands", "", "computeIncrement", "state", "value", "", "getAbstractByteConstant", "b", "", "getAbstractDefault", "getAbstractDoubleConstant", "d", "", "getAbstractFloatConstant", "f", "", "getAbstractIntegerConstant", "i", "getAbstractLongConstant", "l", "", "getAbstractNull", "getAbstractShortConstant", "s", "", "invokeMethod", "", "Lproguard/analysis/cpa/jvm/state/JvmAbstractState;", "call", "Lproguard/analysis/datastructure/callgraph/Call;", "proguard-core_testFixtures"})
public final class ExpressionTransferRelation
extends JvmTransferRelation<ExpressionAbstractState> {
    @NotNull
    protected ExpressionAbstractState calculateArithmeticInstruction(@NotNull Instruction instruction, @NotNull List<ExpressionAbstractState> operands) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        Intrinsics.checkNotNullParameter(operands, (String)"operands");
        return new ExpressionAbstractState(SetsKt.setOf((Object)new InstructionExpression(instruction, operands)));
    }

    @NotNull
    protected ExpressionAbstractState computeIncrement(@NotNull ExpressionAbstractState state, int value) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new ExpressionAbstractState(SetsKt.setOf((Object)new InstructionExpression((Instruction)new VariableInstruction(-124, 0, value), CollectionsKt.listOf((Object)state))));
    }

    @NotNull
    public List<ExpressionAbstractState> getAbstractDoubleConstant(double d) {
        Object[] objectArray = new ExpressionAbstractState[]{this.getAbstractDefault(), new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularDoubleValue(d))))};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public ExpressionAbstractState getAbstractFloatConstant(float f) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularFloatValue(f))));
    }

    @NotNull
    public ExpressionAbstractState getAbstractIntegerConstant(int i) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularIntegerValue(i))));
    }

    @NotNull
    public List<ExpressionAbstractState> getAbstractLongConstant(long l) {
        Object[] objectArray = new ExpressionAbstractState[]{this.getAbstractDefault(), new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularLongValue(l))))};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    public ExpressionAbstractState getAbstractNull() {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new TypedReferenceValue(null, null, true, true))));
    }

    @NotNull
    public ExpressionAbstractState getAbstractShortConstant(short s) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularIntegerValue((int)s))));
    }

    public void invokeMethod(@NotNull JvmAbstractState<ExpressionAbstractState> state, @NotNull Call call, @NotNull List<ExpressionAbstractState> operands) {
        Intrinsics.checkNotNullParameter(state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        Intrinsics.checkNotNullParameter(operands, (String)"operands");
        MethodDescriptor methodDescriptor = call.getTarget().descriptor;
        String string = methodDescriptor != null ? methodDescriptor.returnType : null;
        if (string == null) {
            string = "?";
        }
        switch (ClassUtil.internalTypeSize((String)string)) {
            case 0: {
                return;
            }
            case 1: {
                Object[] objectArray = new ExpressionAbstractState[1];
                String string2 = call.getTarget().getFqn();
                if (string2 == null) {
                    string2 = "?";
                }
                objectArray[0] = new ExpressionAbstractState(SetsKt.setOf((Object)new MethodExpression(string2, operands)));
                state.pushAll(CollectionsKt.mutableListOf((Object[])objectArray));
                break;
            }
            default: {
                Object[] objectArray = new ExpressionAbstractState[2];
                objectArray[0] = this.getAbstractDefault();
                String string3 = call.getTarget().getFqn();
                if (string3 == null) {
                    string3 = "?";
                }
                objectArray[1] = new ExpressionAbstractState(SetsKt.setOf((Object)new MethodExpression(string3, operands)));
                state.pushAll(CollectionsKt.mutableListOf((Object[])objectArray));
            }
        }
    }

    @NotNull
    public ExpressionAbstractState getAbstractDefault() {
        UnknownValue unknownValue = BasicValueFactory.UNKNOWN_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)unknownValue, (String)"UNKNOWN_VALUE");
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)unknownValue)));
    }

    @NotNull
    public ExpressionAbstractState getAbstractByteConstant(byte b) {
        return new ExpressionAbstractState(SetsKt.setOf((Object)new ValueExpression((Value)new ParticularIntegerValue((int)b))));
    }
}

