/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.datastructure.callgraph;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.EntryPoint;
import proguard.analysis.datastructure.callgraph.Node;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.MethodSignature;
import proguard.util.CallGraphWalker;

public class CallGraph {
    private static final transient Logger log = LogManager.getLogger(CallGraph.class);
    public final Map<MethodSignature, Set<Call>> incoming;
    public final Map<MethodSignature, Set<Call>> outgoing;
    private static final boolean STOP_AT_ENTRYPOINT = true;
    private final boolean concurrent;

    public CallGraph() {
        this(new HashMap<MethodSignature, Set<Call>>(), new HashMap<MethodSignature, Set<Call>>(), false);
    }

    protected CallGraph(Map<MethodSignature, Set<Call>> incoming, Map<MethodSignature, Set<Call>> outgoing, boolean concurrent) {
        this.incoming = incoming;
        this.outgoing = outgoing;
        this.concurrent = concurrent;
    }

    public static CallGraph concurrentCallGraph() {
        return new CallGraph(new ConcurrentHashMap<MethodSignature, Set<Call>>(), new ConcurrentHashMap<MethodSignature, Set<Call>>(), true);
    }

    public void addCall(Call call) {
        if (!(call.caller.signature instanceof MethodSignature)) {
            log.error("Location of call {} is not a method", (Object)call);
            return;
        }
        if (call.getTarget() == null) {
            log.error("Target of call {} is null", (Object)call);
            return;
        }
        this.outgoing.computeIfAbsent((MethodSignature)call.caller.signature, e -> this.newCallSet()).add(call);
        this.incoming.computeIfAbsent(call.getTarget(), e -> this.newCallSet()).add(call);
    }

    private Set<Call> newCallSet() {
        return this.concurrent ? Collections.synchronizedSet(new LinkedHashSet()) : new LinkedHashSet();
    }

    public void clear() {
        this.incoming.clear();
        this.outgoing.clear();
    }

    public Node reconstructCallGraph(ClassPool programClassPool, MethodSignature start) {
        return CallGraphWalker.predecessorPathsAccept(this, start, n -> this.handleUntilEntryPoint(programClassPool, (Node)n, null));
    }

    public Node reconstructCallGraph(ClassPool programClassPool, MethodSignature start, int maxDepth, int maxWidth) {
        return CallGraphWalker.predecessorPathsAccept(this, start, n -> this.handleUntilEntryPoint(programClassPool, (Node)n, null), maxDepth, maxWidth);
    }

    public Node reconstructCallGraph(ClassPool programClassPool, MethodSignature start, Set<EntryPoint> entryPoints) {
        return CallGraphWalker.predecessorPathsAccept(this, start, n -> this.handleUntilEntryPoint(programClassPool, (Node)n, entryPoints));
    }

    private boolean handleUntilEntryPoint(ClassPool programClassPool, Node curr, Set<EntryPoint> entryPoints) {
        Clazz currClass = programClassPool.getClass(curr.signature.getClassName());
        if (currClass == null) {
            log.error("Could not find class {} in class pool", (Object)curr.signature.getClassName());
            curr.isTruncated = true;
            return false;
        }
        Set entrypointSuperclassNames = EntryPoint.WELL_KNOWN_ENTRYPOINT_CLASSES.stream().filter(e -> this.classExtendsOrEquals(currClass, e.replace('.', '/'))).collect(Collectors.toSet());
        Optional<EntryPoint> matchingEntrypoint = EntryPoint.WELL_KNOWN_ENTRYPOINTS.stream().filter(e -> entrypointSuperclassNames.contains(e.className) && e.methodName.equals(curr.signature.method)).findFirst();
        if (matchingEntrypoint.isPresent()) {
            curr.matchingEntrypoint = matchingEntrypoint.get();
            if (entryPoints != null) {
                entryPoints.add(new EntryPoint(matchingEntrypoint.get().type, curr.signature.getClassName(), curr.signature.method));
            }
            return false;
        }
        return true;
    }

    private boolean classExtendsOrEquals(Clazz currClass, String className) {
        if (Objects.equals(currClass.getSuperName(), className)) {
            return true;
        }
        if (currClass.getSuperClass() != null) {
            if (Objects.equals(currClass.getSuperClass().getName(), className)) {
                return true;
            }
            return this.classExtendsOrEquals(currClass.getSuperClass(), className);
        }
        return false;
    }
}

