/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.analysis.datastructure.CodeLocation;
import proguard.analysis.datastructure.callgraph.ConcreteCall;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.MethodDescriptor;
import proguard.classfile.MethodSignature;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.AnyMethodrefConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.MethodResult;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.executor.StringReflectionExecutor;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;
import proguard.evaluation.value.object.AnalyzedObject;
import proguard.evaluation.value.object.AnalyzedObjectFactory;
import proguard.evaluation.value.object.Model;
import proguard.util.PartialEvaluatorUtils;

public class ExecutingInvocationUnit
extends BasicInvocationUnit {
    private static final Logger log = LogManager.getLogger(ExecutingInvocationUnit.class);
    @Nullable
    private Value[] parameters;
    private final boolean enableSameInstanceIdApproximation;
    private final List<Executor> registeredExecutors;
    private final Map<MethodSignature, Executor> responsibleExecutor = new HashMap<MethodSignature, Executor>();

    protected ExecutingInvocationUnit(ValueFactory valueFactory, boolean enableSameInstanceIdApproximation, List<Executor> registeredExecutors) {
        super(valueFactory);
        this.enableSameInstanceIdApproximation = enableSameInstanceIdApproximation;
        this.registeredExecutors = registeredExecutors;
    }

    @Deprecated
    public ExecutingInvocationUnit(ValueFactory valueFactory) {
        this(valueFactory, false, new ArrayList<Executor>(Collections.singletonList(new StringReflectionExecutor())));
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant) {
        try {
            super.visitAnyMethodrefConstant(clazz, anyMethodrefConstant);
        }
        finally {
            this.parameters = null;
        }
    }

    @Override
    public void setMethodParameterValue(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, int parameterIndex, Value value) {
        if (this.parameters == null) {
            String type = anyMethodrefConstant.getType(clazz);
            int parameterCount = ClassUtil.internalMethodParameterCount(type, this.isStatic);
            this.parameters = new Value[parameterCount];
        }
        this.parameters[parameterIndex] = value;
    }

    @Override
    public boolean methodMayHaveSideEffects(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType) {
        return this.parameters != null && this.parameters.length > 0;
    }

    @Override
    public Value getMethodReturnValue(Clazz clazz, AnyMethodrefConstant anyMethodrefConstant, String returnType) {
        if (anyMethodrefConstant.referencedMethod == null || this.parameters == null) {
            return super.getMethodReturnValue(clazz, anyMethodrefConstant, returnType);
        }
        MethodExecutionInfo methodInfo = new MethodExecutionInfo(anyMethodrefConstant, null, this.parameters);
        Executor executor = this.getResponsibleExecutor(methodInfo.getSignature());
        MethodResult result = this.executeMethod(executor, methodInfo);
        this.applySideEffects(result);
        if (methodInfo.returnsVoid()) {
            return null;
        }
        if (!result.isReturnValuePresent()) {
            throw new IllegalStateException("The return value is not present for a method not returning void");
        }
        return result.getReturnValue();
    }

    private void applySideEffects(MethodResult result) {
        ArrayList<Value> valuesWithSideEffects = new ArrayList<Value>();
        if (result.isInstanceUpdated()) {
            this.getUpdatedInstance(result).ifPresent(valuesWithSideEffects::add);
        }
        if (result.isAnyParameterUpdated()) {
            valuesWithSideEffects.addAll(this.getUpdatedParameters(result));
        }
        for (Value replacingValue : valuesWithSideEffects) {
            this.replaceReferenceInVariables(replacingValue, this.variables);
            this.replaceReferenceOnStack(replacingValue, this.stack);
        }
    }

    private Optional<Value> getUpdatedInstance(MethodResult result) {
        IdentifiedReferenceValue updatedInstance = (IdentifiedReferenceValue)result.getUpdatedInstance();
        if (!updatedInstance.isSpecific() || !this.parameters[0].isSpecific()) {
            throw new IllegalStateException("An updated instance was provided but either it or the original instance are not specific");
        }
        if (!updatedInstance.id.equals(((IdentifiedReferenceValue)this.parameters[0]).id)) {
            log.error("The updated instance has unexpectedly a different identifier from the calling instance");
            return Optional.empty();
        }
        return Optional.of(result.getUpdatedInstance());
    }

    private Collection<Value> getUpdatedParameters(MethodResult result) {
        ArrayList<Value> toReturn = new ArrayList<Value>();
        List<Value> updatedParameters = result.getUpdatedParameters();
        int firstParameterIndex = this.isStatic ? 0 : 1;
        for (int i = 0; i < updatedParameters.size(); ++i) {
            Value updatedParameter = updatedParameters.get(i);
            if (updatedParameter == null) continue;
            Value oldParameter = this.parameters[i + firstParameterIndex];
            if (!updatedParameter.isSpecific() || !oldParameter.isSpecific()) {
                throw new IllegalStateException("An updated parameter was provided but either it or the original parameter are not specific");
            }
            Object updatedId = PartialEvaluatorUtils.getIdFromSpecificReferenceValue(updatedParameter.referenceValue());
            Object oldId = PartialEvaluatorUtils.getIdFromSpecificReferenceValue(oldParameter.referenceValue());
            if (!oldId.equals(updatedId)) {
                log.error("The updated parameter has unexpectedly a different identifier from its original value");
                continue;
            }
            toReturn.add(updatedParameter);
        }
        return toReturn;
    }

    private Executor getResponsibleExecutor(MethodSignature signature) {
        return this.responsibleExecutor.computeIfAbsent(signature, sig -> this.registeredExecutors.stream().filter(executor -> executor.isSupportedMethodCall(signature)).findFirst().orElse(null));
    }

    public MethodResult executeMethod(ConcreteCall call, Value ... parameters) {
        MethodExecutionInfo methodInfo = new MethodExecutionInfo(call, parameters);
        Executor executor = this.getResponsibleExecutor(call.getTarget());
        return this.executeMethod(executor, methodInfo);
    }

    public MethodResult executeMethod(Executor executor, MethodExecutionInfo methodInfo) {
        if (executor == null) {
            return this.createFallbackResult(methodInfo);
        }
        MethodResult result = executor.getMethodResult(methodInfo, (type, referencedClazz, isParticular, concreteValue, valueMayBeExtension, valueId) -> this.createValue(type, referencedClazz, isParticular, concreteValue, valueMayBeExtension, valueId, methodInfo.getCaller()));
        if (result.isResultValid()) {
            return result;
        }
        return this.createFallbackResult(methodInfo);
    }

    private MethodResult createFallbackResult(MethodExecutionInfo methodInfo) {
        ReferenceValue instanceValue = methodInfo.getInstanceOrNullIfStatic();
        Object instanceId = null;
        if (instanceValue != null && instanceValue.isSpecific()) {
            instanceId = PartialEvaluatorUtils.getIdFromSpecificReferenceValue(instanceValue);
        }
        boolean returnsSameTypeAsInstance = methodInfo.returnsSameTypeAsInstance();
        MethodResult.Builder resultBuilder = new MethodResult.Builder();
        if (methodInfo.returnsVoid()) {
            return resultBuilder.build();
        }
        boolean returnsOwnInstance = methodInfo.isConstructor() || this.enableSameInstanceIdApproximation && returnsSameTypeAsInstance;
        Object newInstanceId = returnsOwnInstance ? instanceId : null;
        resultBuilder.setReturnValue(this.createNonParticularValue(methodInfo.getReturnType(), methodInfo.getReturnClass(), ClassUtil.isExtendable(methodInfo.getReturnClass()), newInstanceId));
        return resultBuilder.build();
    }

    @NotNull
    private Value createValue(String type, Clazz referencedClass, boolean isParticular, @Nullable Object concreteValue, boolean valueMayBeExtension, @Nullable Object valueId, @Nullable CodeLocation callerLocation) {
        if (type.charAt(0) == 'V') {
            throw new IllegalStateException("A value should not be created for void type");
        }
        if (!isParticular) {
            return this.createNonParticularValue(type, referencedClass, valueMayBeExtension, valueId);
        }
        if (ClassUtil.isInternalPrimitiveType(type)) {
            Objects.requireNonNull(concreteValue, "Values of primitive types can't be null");
            switch (type.charAt(0)) {
                case 'Z': {
                    return this.valueFactory.createIntegerValue((Boolean)concreteValue != false ? 1 : 0);
                }
                case 'C': {
                    return this.valueFactory.createIntegerValue(((Character)concreteValue).charValue());
                }
                case 'B': {
                    return this.valueFactory.createIntegerValue(((Byte)concreteValue).byteValue());
                }
                case 'S': {
                    return this.valueFactory.createIntegerValue(((Short)concreteValue).shortValue());
                }
                case 'I': {
                    return this.valueFactory.createIntegerValue((Integer)concreteValue);
                }
                case 'F': {
                    return this.valueFactory.createFloatValue(((Float)concreteValue).floatValue());
                }
                case 'D': {
                    return this.valueFactory.createDoubleValue((Double)concreteValue);
                }
                case 'J': {
                    return this.valueFactory.createLongValue((Long)concreteValue);
                }
            }
            throw new IllegalStateException("Trying to create a value of an unknown primitive type");
        }
        if (ClassUtil.internalArrayTypeDimensionCount(type) == 1 && ClassUtil.isInternalPrimitiveType(ClassUtil.internalTypeFromArrayType(type)) && concreteValue != null) {
            if (concreteValue instanceof Model) {
                throw new IllegalStateException("Modeled arrays are not supported by ExecutingInvocationUnit");
            }
            return this.valueFactory.createArrayReferenceValue(type, null, this.valueFactory.createIntegerValue(Array.getLength(concreteValue)), concreteValue);
        }
        boolean valueMayBeNull = concreteValue == null;
        AnalyzedObject resultObject = AnalyzedObjectFactory.create(concreteValue, type, referencedClass);
        if (valueId != null) {
            return this.valueFactory.createReferenceValueForId(referencedClass, valueMayBeExtension, valueMayBeNull, valueId, resultObject);
        }
        if (callerLocation != null) {
            return this.valueFactory.createReferenceValue(referencedClass, valueMayBeExtension, valueMayBeNull, callerLocation, resultObject);
        }
        return this.valueFactory.createReferenceValue(referencedClass, valueMayBeExtension, valueMayBeNull, resultObject);
    }

    @NotNull
    private Value createNonParticularValue(String type, Clazz referencedClass, boolean valueMayBeExtension, @Nullable Object valueId) {
        if (type.charAt(0) == 'V') {
            throw new IllegalStateException("A value should not be created for void type");
        }
        if (ClassUtil.isInternalPrimitiveType(type)) {
            return this.valueFactory.createValue(type, null, false, false);
        }
        if (valueId != null) {
            return this.valueFactory.createReferenceValueForId(type, referencedClass, valueMayBeExtension, true, valueId);
        }
        return this.valueFactory.createValue(type, referencedClass, valueMayBeExtension, true);
    }

    public boolean isSupportedMethodCall(String internalClassName, String methodName) {
        return this.isSupportedMethodCall(new MethodSignature(internalClassName, methodName, (MethodDescriptor)null));
    }

    public boolean isSupportedMethodCall(MethodSignature methodSignature) {
        return this.getResponsibleExecutor(methodSignature) != null;
    }

    private void replaceReferenceInVariables(Value newValue, Variables variables) {
        if (!newValue.isSpecific()) {
            throw new IllegalStateException("Can't identify a non specific value");
        }
        for (int i = 0; i < variables.size(); ++i) {
            Value oldValue = variables.getValue(i);
            if (oldValue == null) continue;
            if (oldValue.isCategory2()) {
                ++i;
            }
            if (!oldValue.isSpecific() || !(oldValue instanceof ReferenceValue) || !Objects.equals(PartialEvaluatorUtils.getIdFromSpecificReferenceValue(oldValue.referenceValue()), PartialEvaluatorUtils.getIdFromSpecificReferenceValue(newValue.referenceValue()))) continue;
            variables.store(i, newValue);
        }
    }

    private void replaceReferenceOnStack(Value newValue, Stack stack) {
        if (!newValue.isSpecific()) {
            throw new IllegalStateException("Can't identify a non specific value");
        }
        for (int i = 0; i < stack.size(); ++i) {
            Value oldValue = stack.getTop(i);
            if (oldValue == null || !oldValue.isSpecific() || !(oldValue instanceof ReferenceValue) || !Objects.equals(PartialEvaluatorUtils.getIdFromSpecificReferenceValue(oldValue.referenceValue()), PartialEvaluatorUtils.getIdFromSpecificReferenceValue(newValue.referenceValue()))) continue;
            stack.setTop(i, newValue);
        }
    }

    @Override
    public Value getFieldValue(Clazz clazz, FieldrefConstant fieldrefConstant, String type) {
        FieldValueGetterVisitor constantVisitor = new FieldValueGetterVisitor();
        fieldrefConstant.referencedFieldAccept(new MemberAccessFilter(24, 0, constantVisitor));
        return constantVisitor.value == null ? super.getFieldValue(clazz, fieldrefConstant, type) : constantVisitor.value;
    }

    private class FieldValueGetterVisitor
    implements MemberVisitor,
    AttributeVisitor,
    ConstantVisitor {
        Value value = null;
        private ProgramField currentField;

        private FieldValueGetterVisitor() {
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            this.currentField = programField;
            programField.attributesAccept(programClass, this);
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
            clazz.constantPoolEntryAccept(constantValueAttribute.u2constantValueIndex, this);
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createIntegerValue(integerConstant.getValue());
        }

        @Override
        public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createFloatValue(floatConstant.getValue());
        }

        @Override
        public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createDoubleValue(doubleConstant.getValue());
        }

        @Override
        public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createLongValue(longConstant.getValue());
        }

        @Override
        public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
            this.value = ExecutingInvocationUnit.this.valueFactory.createReferenceValue(this.currentField.referencedClass, ClassUtil.isExtendable(this.currentField.referencedClass), false, AnalyzedObjectFactory.createPrecise(stringConstant.getString(clazz)));
        }
    }

    public static class Builder {
        protected boolean enableSameInstanceIdApproximation = false;
        protected boolean useDefaultStringReflectionExecutor = true;
        protected List<Executor.Builder<?>> registeredExecutorBuilders = new ArrayList();

        public Builder setEnableSameInstanceIdApproximation(boolean enableSameInstanceIdApproximation) {
            this.enableSameInstanceIdApproximation = enableSameInstanceIdApproximation;
            return this;
        }

        public Builder addExecutor(Executor.Builder<?> executor) {
            this.registeredExecutorBuilders.add(executor);
            return this;
        }

        public Builder addExecutors(Executor.Builder<?> ... executors) {
            this.registeredExecutorBuilders.addAll(Arrays.asList(executors));
            return this;
        }

        public Builder useDefaultStringReflectionExecutor(boolean useDefaultStringReflectionExecutor) {
            this.useDefaultStringReflectionExecutor = useDefaultStringReflectionExecutor;
            return this;
        }

        public ExecutingInvocationUnit build(ValueFactory valueFactory) {
            ArrayList<Executor> registeredExecutors = new ArrayList<Executor>();
            if (this.useDefaultStringReflectionExecutor) {
                registeredExecutors.add(new StringReflectionExecutor.Builder().build());
            }
            this.registeredExecutorBuilders.stream().map(Executor.Builder::build).forEach(registeredExecutors::add);
            return new ExecutingInvocationUnit(valueFactory, this.enableSameInstanceIdApproximation, registeredExecutors);
        }
    }
}

