/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor;

import java.util.HashMap;
import java.util.Optional;
import proguard.evaluation.executor.Executor;
import proguard.evaluation.executor.ReflectionExecutor;
import proguard.evaluation.executor.instancehandler.ExecutorInstanceHandler;
import proguard.evaluation.executor.instancehandler.ExecutorMethodInstanceHandler;
import proguard.evaluation.executor.matcher.ExecutorClassMatcher;
import proguard.evaluation.executor.matcher.ExecutorMatcher;
import proguard.evaluation.value.ParticularReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.object.AnalyzedObject;
import proguard.evaluation.value.object.AnalyzedObjectFactory;
import proguard.util.CollectionMatcher;
import proguard.util.ConstantMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.StringMatcher;

public class StringReflectionExecutor
extends ReflectionExecutor {
    @Override
    public Optional<ReflectionExecutor.InstanceCopyResult> getInstanceOrCopyIfMutable(ReferenceValue instanceValue) {
        if (!(instanceValue instanceof ParticularReferenceValue)) {
            return Optional.empty();
        }
        AnalyzedObject instanceObject = instanceValue.getValue();
        if (instanceObject.isModeled()) {
            return Optional.empty();
        }
        if (instanceObject.isNull()) {
            return Optional.empty();
        }
        String type = instanceObject.getType();
        if (type == null) {
            throw new IllegalStateException("Unexpected null type on non-null instance object!");
        }
        switch (type) {
            case "Ljava/lang/StringBuilder;": {
                return Optional.of(new ReflectionExecutor.InstanceCopyResult(AnalyzedObjectFactory.createPrecise(new StringBuilder((StringBuilder)instanceObject.getPreciseValue())), true));
            }
            case "Ljava/lang/StringBuffer;": {
                return Optional.of(new ReflectionExecutor.InstanceCopyResult(AnalyzedObjectFactory.createPrecise(new StringBuffer((StringBuffer)instanceObject.getPreciseValue())), true));
            }
            case "Ljava/lang/String;": {
                return Optional.of(new ReflectionExecutor.InstanceCopyResult(instanceObject, false));
            }
        }
        return Optional.empty();
    }

    @Override
    public ExecutorMatcher getExecutorMatcher() {
        return new ExecutorClassMatcher(new CollectionMatcher("java/lang/String", "java/lang/StringBuilder", "java/lang/StringBuffer"));
    }

    @Override
    public ExecutorInstanceHandler getDefaultInstanceHandler() {
        HashMap<String, StringMatcher> matcherMap = new HashMap<String, StringMatcher>();
        matcherMap.put("java/lang/String", new FixedStringMatcher("toString"));
        matcherMap.put("java/lang/StringBuffer", new ConstantMatcher(true));
        matcherMap.put("java/lang/StringBuilder", new ConstantMatcher(true));
        return new ExecutorMethodInstanceHandler(matcherMap);
    }

    public static class Builder
    implements Executor.Builder<StringReflectionExecutor> {
        @Override
        public StringReflectionExecutor build() {
            return new StringReflectionExecutor();
        }
    }
}

