/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor.matcher;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.MethodSignature;
import proguard.evaluation.executor.matcher.ExecutorMatcher;
import proguard.util.OrMatcher;
import proguard.util.StringMatcher;

public class ExecutorMethodMatcher
implements ExecutorMatcher {
    private final Map<String, StringMatcher> methodMatchers;

    public ExecutorMethodMatcher(Map<String, StringMatcher> methodMatchers) {
        this.methodMatchers = methodMatchers;
    }

    @Override
    public boolean matches(MethodSignature methodSignature) {
        StringMatcher matcher = this.methodMatchers.get(methodSignature.getClassName());
        return matcher != null && matcher.matches(methodSignature.method);
    }

    public static class Builder {
        private final Map<String, StringMatcher> methodMatchers = new HashMap<String, StringMatcher>();

        public Builder addMethodMatch(String className, StringMatcher methodMatcher) {
            this.methodMatchers.merge(className, methodMatcher, (xva$0, xva$1) -> new OrMatcher((StringMatcher)xva$0, (StringMatcher)xva$1));
            return this;
        }

        public ExecutorMethodMatcher build() {
            return new ExecutorMethodMatcher(this.methodMatchers);
        }
    }
}

