/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.executor.matcher;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.MethodSignature;
import proguard.evaluation.executor.matcher.ExecutorMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.OrMatcher;
import proguard.util.StringMatcher;

public class ExecutorMethodSignatureMatcher
implements ExecutorMatcher {
    private final Map<String, Map<String, StringMatcher>> methodMatchers;

    public ExecutorMethodSignatureMatcher(Map<String, Map<String, StringMatcher>> methodMatchers) {
        this.methodMatchers = methodMatchers;
    }

    @Override
    public boolean matches(MethodSignature signature) {
        Map<String, StringMatcher> descriptorMatchers = this.methodMatchers.get(signature.getClassName());
        if (descriptorMatchers == null) {
            return false;
        }
        StringMatcher descriptorMatcher = descriptorMatchers.get(signature.method);
        return descriptorMatcher != null && descriptorMatcher.matches(signature.descriptor.toString());
    }

    public static class Builder {
        private final Map<String, Map<String, StringMatcher>> methodMatchers = new HashMap<String, Map<String, StringMatcher>>();

        public Builder addMethodMatch(String className, String methodName, StringMatcher descriptorMatcher) {
            this.methodMatchers.computeIfAbsent(className, name -> new HashMap()).merge(methodName, descriptorMatcher, (xva$0, xva$1) -> new OrMatcher((StringMatcher)xva$0, (StringMatcher)xva$1));
            return this;
        }

        public Builder addMethodMatch(MethodSignature signature) {
            return this.addMethodMatch(signature.getClassName(), signature.method, new FixedStringMatcher(signature.descriptor.toString()));
        }

        public ExecutorMethodSignatureMatcher build() {
            return new ExecutorMethodSignatureMatcher(this.methodMatchers);
        }
    }
}

