/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.Metrics;
import proguard.analysis.datastructure.callgraph.Call;
import proguard.analysis.datastructure.callgraph.CallGraph;
import proguard.analysis.datastructure.callgraph.Node;
import proguard.classfile.MethodSignature;

public class CallGraphWalker {
    private static final Logger log = LogManager.getLogger(CallGraphWalker.class);
    public static final int MAX_DEPTH_DEFAULT = 100;
    public static final int MAX_WIDTH_DEFAULT = 100;

    public static Set<MethodSignature> getSuccessors(CallGraph callGraph, MethodSignature start, int maxDepth, int maxWidth) {
        LinkedHashSet<MethodSignature> visited = new LinkedHashSet<MethodSignature>();
        CallGraphWalker.explore(callGraph, start, CallGraphWalker::calculateSuccessors, n -> visited.add(n.signature), maxDepth, maxWidth);
        return visited;
    }

    public static Set<MethodSignature> getSuccessors(CallGraph callGraph, MethodSignature start) {
        return CallGraphWalker.getSuccessors(callGraph, start, 100, 100);
    }

    public static Set<MethodSignature> getPredecessors(CallGraph callGraph, MethodSignature start, int maxDepth, int maxWidth) {
        LinkedHashSet<MethodSignature> visited = new LinkedHashSet<MethodSignature>();
        CallGraphWalker.explore(callGraph, start, CallGraphWalker::calculatePredecessors, n -> visited.add(n.signature), maxDepth, maxWidth);
        return visited;
    }

    public static Set<MethodSignature> getPredecessors(CallGraph callGraph, MethodSignature start) {
        return CallGraphWalker.getPredecessors(callGraph, start, 100, 100);
    }

    public static Node successorPathsAccept(CallGraph callGraph, MethodSignature start, Predicate<Node> handler, int maxDepth, int maxWidth) {
        return CallGraphWalker.explore(callGraph, start, CallGraphWalker::calculateSuccessors, handler, maxDepth, maxWidth);
    }

    public static Node successorPathsAccept(CallGraph callGraph, MethodSignature start, Predicate<Node> handler) {
        return CallGraphWalker.successorPathsAccept(callGraph, start, handler, 100, 100);
    }

    public static Node predecessorPathsAccept(CallGraph callGraph, MethodSignature start, Predicate<Node> handler, int maxDepth, int maxWidth) {
        return CallGraphWalker.explore(callGraph, start, CallGraphWalker::calculatePredecessors, handler, maxDepth, maxWidth);
    }

    public static Node predecessorPathsAccept(CallGraph callGraph, MethodSignature start, Predicate<Node> handler) {
        return CallGraphWalker.predecessorPathsAccept(callGraph, start, handler, 100, 100);
    }

    private static Node explore(CallGraph callGraph, MethodSignature start, BiFunction<CallGraph, Node, Collection<Node>> getNext, Predicate<Node> handler, int maxDepth, int maxWidth) {
        Node root = new Node(start);
        ArrayList<Node> worklist = new ArrayList<Node>();
        worklist.add(root);
        int currLevel = 0;
        while (!worklist.isEmpty()) {
            if (currLevel >= maxDepth) {
                Metrics.increaseCount(Metrics.MetricType.CALL_GRAPH_RECONSTRUCTION_MAX_DEPTH_REACHED);
                worklist.forEach(n -> {
                    n.isTruncated = true;
                });
                break;
            }
            worklist = CallGraphWalker.currentLevelAccept(callGraph, getNext, handler, worklist, maxWidth);
            ++currLevel;
        }
        return root;
    }

    private static ArrayList<Node> currentLevelAccept(CallGraph callGraph, BiFunction<CallGraph, Node, Collection<Node>> getNext, Predicate<Node> handler, ArrayList<Node> worklist, int maxWidth) {
        ArrayList<Node> nextLevel = new ArrayList<Node>();
        for (Node curr : worklist) {
            if (!handler.test(curr)) continue;
            for (Node next : getNext.apply(callGraph, curr)) {
                if (nextLevel.size() >= maxWidth) {
                    Metrics.increaseCount(Metrics.MetricType.CALL_GRAPH_RECONSTRUCTION_MAX_WIDTH_REACHED);
                    next.isTruncated = true;
                    continue;
                }
                nextLevel.add(next);
            }
        }
        return nextLevel;
    }

    private static Set<Node> calculatePredecessors(CallGraph callGraph, Node curr) {
        LinkedHashSet<Node> predecessors = new LinkedHashSet<Node>();
        for (Call i : callGraph.incoming.getOrDefault(curr.signature, Collections.emptySet())) {
            if (!(i.caller.signature instanceof MethodSignature)) {
                log.error("Call graph edge {} does not have a method as the caller member!", (Object)i);
                continue;
            }
            if (curr.successorsContain((MethodSignature)i.caller.signature)) continue;
            Node prev = new Node((MethodSignature)i.caller.signature);
            curr.predecessors.add(prev);
            curr.incomingCallLocations.add(i.caller);
            prev.successors.add(curr);
            prev.outgoingCallLocations.add(i.caller);
            predecessors.add(prev);
        }
        return predecessors;
    }

    private static Set<Node> calculateSuccessors(CallGraph callGraph, Node curr) {
        LinkedHashSet<Node> successors = new LinkedHashSet<Node>();
        for (Call i : callGraph.outgoing.getOrDefault(curr.signature, Collections.emptySet())) {
            if (curr.predecessorsContain(i.getTarget())) continue;
            Node successor = new Node(i.getTarget());
            curr.successors.add(successor);
            curr.outgoingCallLocations.add(i.caller);
            successor.predecessors.add(curr);
            successor.incomingCallLocations.add(i.caller);
            successors.add(successor);
        }
        return successors;
    }
}

