/*
 * ProGuardCORE -- library to process Java bytecode.
 *
 * Copyright (c) 2002-2020 Guardsquare NV
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package proguard.evaluation.value;

import static proguard.evaluation.value.BasicValueFactory.UNKNOWN_VALUE;

/**
 * Representation of a partially evaluated top value. A top value is the dummy value that takes up
 * the extra space when storing a long value or a double value.
 *
 * @author Eric Lafortune
 */
public class TopValue extends Category1Value {
  // Implementations for Value.

  public boolean isSpecific() {
    return true;
  }

  public boolean isParticular() {
    return true;
  }

  public final Value generalize(Value other) {
    return this.getClass() == other.getClass() ? this : UNKNOWN_VALUE;
  }

  public final int computationalType() {
    return TYPE_TOP;
  }

  public final String internalType() {
    return null;
  }

  // Implementations for Object.

  public boolean equals(Object object) {
    return object != null && this.getClass() == object.getClass();
  }

  public int hashCode() {
    return this.getClass().hashCode();
  }

  public String toString() {
    return "T";
  }
}
