/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.io.visitor;

import proguard.io.DataEntry;
import proguard.io.DataEntryFilter;
import proguard.resources.file.ResourceFile;
import proguard.resources.file.ResourceFilePool;

public class ProcessingFlagDataEntryFilter
implements DataEntryFilter {
    private final ResourceFilePool resourceFilePool;
    private final int requiredSetProcessingFlags;
    private final int requiredUnsetProcessingFlags;

    public ProcessingFlagDataEntryFilter(ResourceFilePool resourceFilePool, int requiredSetProcessingFlags, int requiredUnsetProcessingFlags) {
        this.resourceFilePool = resourceFilePool;
        this.requiredSetProcessingFlags = requiredSetProcessingFlags;
        this.requiredUnsetProcessingFlags = requiredUnsetProcessingFlags;
    }

    @Override
    public boolean accepts(DataEntry dataEntry) {
        ResourceFile resourceFile = this.resourceFilePool.getResourceFile(dataEntry.getName());
        if (resourceFile != null) {
            int processingFlags = resourceFile.getProcessingFlags();
            return (this.requiredSetProcessingFlags & ~processingFlags) == 0 && (this.requiredUnsetProcessingFlags & processingFlags) == 0;
        }
        return false;
    }
}

