/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.renderer;

import java.util.ArrayList;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.renderer.ConstantViewModel;
import proguard.classfile.util.renderer.FieldViewModel;
import proguard.classfile.util.renderer.MethodViewModel;
import proguard.classfile.util.renderer.ProcessableViewModel;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ProcessingFlags;

public class ClassViewModel
extends ProcessableViewModel {
    private Clazz model;
    private ClassViewModel parent;
    private ClassViewModel[] interfaces;
    private ConstantViewModel[] constantPool;
    private FieldViewModel[] fields;
    private MethodViewModel[] methods;

    public static ClassViewModel render(Clazz clazz) {
        ClassViewModel viewModel = new ClassViewModel(clazz);
        viewModel.parent = ClassViewModel.renderSuperClass(clazz);
        viewModel.interfaces = ClassViewModel.renderInterfaces(clazz);
        viewModel.constantPool = ClassViewModel.renderConstantPool(clazz);
        viewModel.fields = ClassViewModel.renderFields(clazz);
        viewModel.methods = ClassViewModel.renderMethods(clazz);
        viewModel.processingFlags = ClassViewModel.renderProcessingFlags(clazz.getProcessingFlags());
        viewModel.processingInfo = clazz.getProcessingInfo();
        return viewModel;
    }

    public static <T extends ProcessingFlags> ClassViewModel render(Clazz clazz, Class<T> processingFlagsHolder) {
        ClassViewModel.addExtraProcessingFlags(processingFlagsHolder);
        return ClassViewModel.render(clazz);
    }

    private ClassViewModel(Clazz clazz) {
        this.model = clazz;
    }

    public static String renderPreview(Clazz model) {
        return ClassUtil.externalClassAccessFlags(model.getAccessFlags()) + ((model.getAccessFlags() & 0x200) == 0 ? "class " : "") + model.getName();
    }

    public static ClassViewModel renderSuperClass(Clazz model) {
        return model.getSuperClass() != null ? new ClassViewModel(model.getSuperClass()) : null;
    }

    public static ClassViewModel[] renderInterfaces(Clazz model) {
        final ArrayList interfaces = new ArrayList();
        model.hierarchyAccept(false, false, true, false, new ClassVisitor(){

            @Override
            public void visitAnyClass(Clazz clazz) {
                interfaces.add(new ClassViewModel(clazz));
            }
        });
        return interfaces.toArray(new ClassViewModel[interfaces.size()]);
    }

    public static ConstantViewModel[] renderConstantPool(Clazz model) {
        final ArrayList constantList = new ArrayList();
        constantList.add(null);
        model.constantPoolEntriesAccept(new ConstantVisitor(){

            @Override
            public void visitAnyConstant(Clazz clazz, Constant constant) {
                constantList.add(new ConstantViewModel(clazz, constant));
            }
        });
        return constantList.toArray(new ConstantViewModel[constantList.size()]);
    }

    public static FieldViewModel[] renderFields(Clazz model) {
        final ArrayList fields = new ArrayList();
        model.fieldsAccept(new MemberVisitor(){

            private void visitAnyField(Clazz clazz, Field field) {
                fields.add(FieldViewModel.render(clazz, field));
            }

            @Override
            public void visitProgramField(ProgramClass programClass, ProgramField programField) {
                this.visitAnyField(programClass, programField);
            }

            @Override
            public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
                this.visitAnyField(libraryClass, libraryField);
            }
        });
        return fields.toArray(new FieldViewModel[fields.size()]);
    }

    public static MethodViewModel[] renderMethods(Clazz model) {
        final ArrayList methods = new ArrayList();
        model.methodsAccept(new MemberVisitor(){

            private void visitAnyMethod(Clazz clazz, Method method) {
                MethodViewModel methodViewModel = MethodViewModel.render(clazz, method);
                methods.add(methodViewModel);
            }

            @Override
            public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                this.visitAnyMethod(programClass, programMethod);
            }

            @Override
            public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
                this.visitAnyMethod(libraryClass, libraryMethod);
            }
        });
        return methods.toArray(new MethodViewModel[methods.size()]);
    }
}

