/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.Clazz;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.ValueFactory;
import proguard.evaluation.value.object.AnalyzedObject;

public class ParticularReferenceValue
extends IdentifiedReferenceValue {
    private final AnalyzedObject objectValue;

    public ParticularReferenceValue(Clazz referencedClass, ValueFactory valueFactory, Object referenceID, @NotNull AnalyzedObject value) {
        super(value.getType(), referencedClass, false, true, valueFactory, referenceID);
        Objects.requireNonNull(value);
        Objects.requireNonNull(value.getType(), "ParticularReferenceValue should not be created with a 'NullObject', a 'TypedReferenceValue' with null type is expected in that case");
        this.objectValue = value;
    }

    @Override
    @Deprecated
    public Object value() {
        return this.objectValue.isModeled() ? this.objectValue.getModeledValue() : this.objectValue.getPreciseValue();
    }

    @Override
    @NotNull
    public AnalyzedObject getValue() {
        return this.objectValue;
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public int isNull() {
        return this.objectValue.isNull() ? 1 : -1;
    }

    @Override
    public int instanceOf(String otherType, Clazz otherReferencedClass) {
        if (this.referencedClass == null || otherReferencedClass == null) {
            return 0;
        }
        if (this.referencedClass.extendsOrImplements(otherReferencedClass)) {
            return 1;
        }
        if ((this.referencedClass.getAccessFlags() & 0x10) != 0) {
            return -1;
        }
        if ((this.referencedClass.getAccessFlags() & 0x200) == 0 && (otherReferencedClass.getAccessFlags() & 0x200) == 0 && !otherReferencedClass.extendsOrImplements(this.referencedClass)) {
            return -1;
        }
        return 0;
    }

    @Override
    public ReferenceValue cast(String type, Clazz referencedClass, ValueFactory valueFactory, boolean alwaysCast) {
        if (!(alwaysCast || this.type != null && this.instanceOf(type, referencedClass) != 1)) {
            return this;
        }
        if (this.type != null && this.type.equals(type)) {
            return this;
        }
        if (this.instanceOf(type, referencedClass) == 1) {
            return valueFactory.createReferenceValue(referencedClass, true, true, this.objectValue);
        }
        return valueFactory.createReferenceValue(type, referencedClass, true, true);
    }

    @Override
    public ReferenceValue generalize(ReferenceValue other) {
        return other.generalize(this);
    }

    @Override
    public ReferenceValue generalize(ParticularReferenceValue other) {
        if (this.equal(other) == 1) {
            return other;
        }
        return super.generalize((IdentifiedReferenceValue)other);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ (this.objectValue.isNull() ? 1 : this.objectValue.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParticularReferenceValue that = (ParticularReferenceValue)o;
        return Objects.equals(this.getValue(), that.getValue());
    }

    @Override
    public int equal(ReferenceValue other) {
        if (this == other) {
            return 1;
        }
        if (super.equal(other) == -1) {
            return -1;
        }
        if (this.getClass() != other.getClass()) {
            return 0;
        }
        ParticularReferenceValue otherParticularValue = (ParticularReferenceValue)other;
        if (this.getValue().isNull() && otherParticularValue.getValue().isNull() || !this.getValue().isNull() && this.getValue().equals(otherParticularValue.getValue())) {
            return 1;
        }
        return -1;
    }

    @Override
    public String toString() {
        return super.toString() + "(" + (this.objectValue == null ? "null" : this.objectValue.toString()) + ")";
    }
}

